/*
 *    qsodata.c  --  QSO data area functions
 *
 *    Copyright (C) 2001, 2002, 2003, 2004
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <windows.h>
#include <tchar.h>

#include <string.h>
#include <stdio.h>
#include <ctype.h>

#ifdef _WIN32_WCE
#include "Aygshell.h"
#endif /* _WIN32_WCE */

#include "qsodata.h"
#include "dlggen.h"
#include "../resource.h"

#define QSOINFO_ARRAY ((TCHAR**)info)
#define QSOINFO_LEN   8

TCHAR *g_aQsoInfoLabels[] = {
	_T("Call"),
	_T("Name"),
	_T("QTH"),
	_T("Loc"),
	_T("Band"),
	_T("TX RST"),
	_T("RX RST"),
	_T("Notes")
};

static QsoInfo *s_pQsoEdited = 0;

extern HINSTANCE	g_hInst;
extern HWND			s_hWndMain;

/*
static void log_msg_append(gchar *type, gchar *data)
{
	gchar *entry;

	entry = g_strdup_printf("%s:%s%c", type, data, LOG_MSEPARATOR);

	if (strlen(msgbuf.mtext) + strlen(entry) + 1 > LOG_MSG_LEN) {
		g_warning(_("log message too long, entry dropped: %s\n"), entry);
		g_free(entry);
		return;
	}

	strcat(msgbuf.mtext, entry);
	g_free(entry);
}

static int log_msg_send(void)
{
	gint msqid, len;

	if ((msqid = msgget(LOG_MKEY, 0666 | IPC_CREAT)) == -1) {
		g_print("msgget: %s\n", strerror(errno));
		return -1;
	}

	msgbuf.mtype = LOG_MTYPE;

	// allow for the NUL
	len = strlen(msgbuf.mtext) + 1;

	if (msgsnd(msqid, &msgbuf, len, IPC_NOWAIT) < 0) {
		g_print("msgsnd: %m\n");
		return -1;
	}

#if 0
	g_print("msg sent: (%02ld) '%s'\n", msgbuf.mtype, msgbuf.mtext);
#endif

	return 0;
}
*/

QsoInfo* qsodata_new()
{
	QsoInfo *info = (QsoInfo*)malloc(sizeof(QsoInfo));
	if (info == 0)
		return 0;
	qsodata_init(info);
	return info;
}

void qsodata_free(QsoInfo *info)
{
	qsodata_destroy(info);
	free(info);
}

void qsodata_init(QsoInfo *info)
{
	memset(info, 0, sizeof(QsoInfo));
	qsodata_clear(info);
}

void qsodata_destroy(QsoInfo *info)
{
	int i;
	for (i = 0; i < QSOINFO_LEN; ++ i)
		free(QSOINFO_ARRAY[i]);
	memset(info, 0, sizeof(QsoInfo));
}

void qsodata_clear(QsoInfo *info)
{
	int i;
	for (i = 0; i < QSOINFO_LEN; ++ i) {
		free(QSOINFO_ARRAY[i]);
		QSOINFO_ARRAY[i] = _tcsdup(_T(""));
	}
//	info->starttime = 0;
}

/*
void qsodata_log()
{
	char date[32], stime[32], etime[32], *mode;
	struct tm *tm;
	time_t t;

	g_strup(call);

	tm = gmtime(&starttime);
	strftime(date, sizeof(date), "%d %b %Y", tm);
	strftime(stime, sizeof(stime), "%H%M", tm);

	time(&t);
        tm = gmtime(&t);
	strftime(etime, sizeof(etime), "%H%M", tm);

	mode = trx_get_mode_name();

	log_msg_reset();
	log_msg_append("program", "gMFSK v" VERSION);
	log_msg_append("version", LOG_MVERSION);
	log_msg_append("date", date);
	log_msg_append("time", stime);
	log_msg_append("endtime", etime);
	log_msg_append("call", call);
	log_msg_append("mhz", band);
	log_msg_append("mode", mode);
	log_msg_append("tx", txrst);
	log_msg_append("rx", rxrst);
	log_msg_append("name", name);
	log_msg_append("qth", qth);
	log_msg_append("locator", loc);
	log_msg_append("notes", notes);
	log_msg_send();
}
*/

#define ID_LABEL	101
#define ID_ENTRY	201

INT_PTR CALLBACK qsoinfo_dlgproc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
#ifdef _WIN32_WCE
	static SHACTIVATEINFO sai;
#endif /* _WIN32_WCE */

    switch(uMsg)
    {
    case WM_INITDIALOG:
	{
#ifdef _WIN32_WCE
		memset(&sai, 0, sizeof(sai));
        {
            SHINITDLGINFO shidi;
            shidi.dwMask	= SHIDIM_FLAGS;
            shidi.dwFlags	= SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
            shidi.hDlg		= hwnd;
            SHInitDialog(&shidi);
        }
		{
			SHMENUBARINFO mbi;
			memset(&mbi, 0, sizeof(SHMENUBARINFO));
			mbi.cbSize		= sizeof(SHMENUBARINFO);
			mbi.hwndParent	= hwnd;
			mbi.hInstRes	= g_hInst;
			mbi.dwFlags		= SHCMBF_EMPTYBAR;
			SHCreateMenuBar(&mbi);
		}
#endif /* _WIN32_WCE */
        return TRUE;
	}
	case WM_ACTIVATE:
#ifdef _WIN32_WCE
		if (wParam == SPI_SETSIPINFO){
			memset(&sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMActivate(hwnd, wParam, lParam, &sai, 0);
		}
#endif /* _WIN32_WCE */
		break;
	case WM_SETTINGCHANGE:
#ifdef _WIN32_WCE
		if (wParam == SPI_SETSIPINFO) {
			memset(&sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMSettingChange(hwnd, -1, 0, &sai);
		}
#endif /* _WIN32_WCE */
	case WM_SIZE:
	{
		RECT rectWnd, rectValue;
		int  i;
		GetClientRect(hwnd, &rectWnd);
		for (i = 0; i < QSOINFO_LEN; ++ i) {
			HWND hWndValue = GetDlgItem(hwnd, ID_ENTRY + i);
			GetWindowRect(hWndValue, &rectValue);
			ScreenToClient(hwnd, (LPPOINT)(&rectValue.left));
			ScreenToClient(hwnd, (LPPOINT)(&rectValue.right));
			MoveWindow(hWndValue, rectValue.left, rectValue.top,
				rectWnd.right - rectWnd.left - rectValue.left - 2, 
				rectValue.bottom - rectValue.top, TRUE);
		}
#ifndef _WIN32_WCE
		{
			HWND hWndOK		= GetDlgItem(hwnd, IDOK);
			HWND hWndCancel = GetDlgItem(hwnd, IDCANCEL);
			RECT rectButton;
			GetWindowRect(hWndOK, &rectButton);
			ScreenToClient(hwnd, (LPPOINT)(&rectButton.left));
			ScreenToClient(hwnd, (LPPOINT)(&rectButton.right));
			MoveWindow(hWndCancel, 
				rectWnd.right - DLG_MARGIN - (rectButton.right - rectButton.left), 
				rectWnd.bottom - DLG_MARGIN - (rectButton.bottom - rectButton.top),
				rectButton.right - rectButton.left, 
				rectButton.bottom - rectButton.top, TRUE);
			MoveWindow(hWndOK, 
				rectWnd.right - 3 * DLG_MARGIN - 2 * (rectButton.right - rectButton.left),
				rectWnd.bottom - DLG_MARGIN - (rectButton.bottom - rectButton.top),
				rectButton.right - rectButton.left, 
				rectButton.bottom - rectButton.top, TRUE);
		}
#endif /* _WIN32_WCE */
	}
    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) {
			if (LOWORD(wParam) == IDOK) {
				int i;
				QsoInfo *info = s_pQsoEdited;
				for (i = 0; i < QSOINFO_LEN; ++ i) {
					HWND hWnd  = GetDlgItem(hwnd, ID_ENTRY + i);
					int  nLen  = GetWindowTextLength(hWnd);
					QSOINFO_ARRAY[i] = (TCHAR*)realloc(
						QSOINFO_ARRAY[i], (nLen + 1) * sizeof(TCHAR));
					GetWindowText(hWnd, QSOINFO_ARRAY[i], nLen + 1);
				}
			}
            EndDialog(hwnd, LOWORD(wParam) == IDOK);
            return TRUE;
        }
        break;
	case WM_PAINT:
	{
		PAINTSTRUCT paint;
		RECT		rect, rectClient;
		POINT		line[2];
		HGDIOBJ		hOldPen;
		HPEN		hNewPen;
		int			i;
		BeginPaint(hwnd, &paint);
		GetWindowRect(hwnd, &rect);
		GetClientRect(hwnd, &rectClient);
		hNewPen = CreatePen(PS_SOLID, 0, RGB(127, 127, 127));
		hOldPen = SelectObject(paint.hdc, hNewPen);
		for (i = 0; i < QSOINFO_LEN; ++ i) {
			HWND hControl  = GetDlgItem(hwnd, ID_ENTRY + i);
			RECT rectControl;
			GetWindowRect(hControl, &rectControl);
			ScreenToClient(hwnd, (LPPOINT)&rectControl.left);
			ScreenToClient(hwnd, (LPPOINT)&rectControl.right);
			line[0].x = rectControl.left;
			line[1].x = rectControl.right;
			line[0].y = rectControl.bottom;
			line[1].y = line[0].y;
			Polyline(paint.hdc, line, 2);
		}
		SelectObject(paint.hdc, hOldPen);
		DeleteObject(hNewPen);
		EndPaint(hwnd, &paint);
		break;
	}

    default:
        break;
	}

    return FALSE;
}

BOOL qsodata_edit(QsoInfo *info)
{
	DlgTemplate tmpl;
	int         i;

	s_pQsoEdited = info;

	dlggen_create(&tmpl, _T("QSO"),
#ifdef _WIN32_WCE
		WS_POPUP | WS_BORDER, 
#else /* _WIN32_WCE */
		WS_OVERLAPPEDWINDOW | DS_MODALFRAME, 
#endif /* _WIN32_WCE */
		0, 0, 110, 120, _T("Tahoma"), 9);

	for (i = 0; i < QSOINFO_LEN; ++ i) {
		dlggen_add_static(&tmpl, g_aQsoInfoLabels[i],
			WS_CHILD | WS_VISIBLE | SS_RIGHT, 0, 2, 2 + i * 12, 30, 10, ID_LABEL + i);
		dlggen_add_edit_box(&tmpl, QSOINFO_ARRAY[i],
			WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL | ES_AUTOVSCROLL, /* WS_EX_STATICEDGE */ 0,
			34, 2 + i * 12, 101, 10, ID_ENTRY + i);
	}

#ifndef _WIN32_WCE
	dlggen_add_button(&tmpl, _T("OK"),
		WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,
		2, 140, 38, 15, IDOK);
	dlggen_add_button(&tmpl, _T("Cancel"),
		WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,
		50, 140, 38, 15, IDCANCEL);
#endif /* _WIN32_WCE */

	return dlggen_dialog_box(&tmpl, g_hInst, s_hWndMain, qsoinfo_dlgproc) == IDOK;
}
