// #include "../StdAfx.h"

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <tchar.h>
#include <commctrl.h>

#include "main.h"
#include "waterfall.h"
#include "dlggen.h"
#include "../misc/int_fft.h"
#include "ColorTable.h"
#include "trx.h"
#include "macro.h"
#include "stninfo.h"
#include "devinfo.h"
#include "qsodata.h"
#include "../rtty/rtty.h"
#include "sndmodem.h"
#include "waterfall.h"
#include "sliderpopup.h"
#include "../resource.h"

#ifdef _WIN32_WCE
#include "../stdafx-ce.h"
#else
#include <Mmsystem.h>
#endif /* _WIN32_WCE */

#include "Version.h"

#define MAX_LOADSTRING 100

#define MENU_HEIGHT 26

#ifdef _WIN32_WCE
#include <AYGShell.h>
#include <Notify.h>
#endif /* _WIN32_WCE */

#ifndef _WIN32_WCE
// #include "dbgwaterfall.h"
#endif /* _WIN32_WCE */


// Global Variables:
extern "C" {
HINSTANCE			g_hInst			 = 0;	// The current instance
HWND				s_hWndMain		 = 0;	// Main window
HWND				s_hWndCommandBar = 0;	// The command bar handle
TCHAR			   *g_strSoftwareVersion = _T("PocketDigi ") VERSION _T(" by OK1IAK, derived from gMFSK by OH2BNS");
};

TCHAR				szTitle[]       = _T("PocketDigi"); // The title bar text
TCHAR				szWindowClass[] = _T("POCKETDIGI"); // The window class name

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass	(HINSTANCE hInstance, LPTSTR szWindowClass);
BOOL				InitInstance	(HINSTANCE, int);
LRESULT CALLBACK	WndProc			(HWND, UINT, WPARAM, LPARAM);

SndModem			s_SndModem;
Waterfall			s_Waterfall;
SliderPopup			s_SliderPopup;

#ifndef _WIN32_WCE
extern "C" {
//DbgWaterfall		s_DbgWaterfall;
}
#endif /* _WIN32_WCE */

Trx*				s_aChannels[CHANNELS_MAX];
int					s_iChannelActive	  = -1;
HMENU				s_hMenuWaterfallZoom  = 0;
HMENU				s_hMenuWaterfallSpeed = 0;
HMENU				s_hMenuChannels		  = 0;
HMENU				s_hMenuMacros		  = 0;

#define WM_USER_WAKEUP	(WM_USER + 1)

static void UpdateMenuChannels();

static void DoLayout()
{
	RECT rectWnd, rectWaterfall, rect;
	int  i;
	int  iBottom;

	if (s_iChannelActive == -1)
		return;

	GetClientRect(s_hWndMain, &rectWnd);
	GetClientRect(s_Waterfall.hWnd, &rectWaterfall);

	iBottom = /* rectWaterfall.bottom - rectWaterfall.top */ 
		(rectWnd.bottom - rectWnd.top - rectWaterfall.top) / 3;
	MoveWindow(s_Waterfall.hWnd, rectWaterfall.left, rectWaterfall.top,
		rectWnd.right - rectWnd.left, iBottom, TRUE);

	rect.left	= 0;
	rect.right	= rectWnd.right - rectWnd.left;
	rect.top	= rectWaterfall.top + iBottom;

	iBottom     = rectWnd.bottom - 80;
	for (i = 0; i < CHANNELS_MAX; ++ i)
		if (i != s_iChannelActive && s_aChannels[i] != 0) {
			rect.bottom	= rectWnd.bottom;
			if (! trx_layout(s_aChannels[i], LAYOUT_SINGLELINE, &rect) ||
				rect.bottom > iBottom) {
				ShowWindow(s_aChannels[i]->hWnd, SW_HIDE);
				break;
			}
			MoveWindow(s_aChannels[i]->hWnd, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, FALSE);
			ShowWindow(s_aChannels[i]->hWnd, SW_SHOW);
			InvalidateRect(s_aChannels[i]->hWnd, 0, false);
			rect.top = rect.bottom;
		}
	for (; i < CHANNELS_MAX; ++ i)
		if (i != s_iChannelActive && s_aChannels[i] != 0)
			ShowWindow(s_aChannels[i]->hWnd, SW_HIDE);

	rect.bottom	= rectWnd.bottom;
#ifdef _WIN32_WCE
	{
		SIPINFO sipinfo;
		sipinfo.cbSize = sizeof(sipinfo);
		SHSipInfo(SPI_GETSIPINFO, 0, &sipinfo, 0);
		trx_layout(s_aChannels[s_iChannelActive], sipinfo.fdwFlags ? LAYOUT_TRX : LAYOUT_RCV, &rect);
	}
#else /* _WIN32_WCE */
	trx_layout(s_aChannels[s_iChannelActive], LAYOUT_TRX, &rect);
#endif /* _WIN32_WCE */
	MoveWindow(s_aChannels[s_iChannelActive]->hWnd, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, TRUE);
	ShowWindow(s_aChannels[s_iChannelActive]->hWnd, SW_SHOW);
	InvalidateRect(s_aChannels[s_iChannelActive]->hWnd, 0, true);
}

#ifdef _WIN32_WCE
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
#else /* _WIN32_WCE */
int WINAPI SimWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
#endif /* _WIN32_WCE */
{
	TCHAR exepath[MAX_PATH];

	GetModuleFileName(0, exepath, MAX_PATH);

	s_hWndMain = FindWindow(szWindowClass, szTitle);
	if (s_hWndMain !=0) {
#ifdef _WIN32_WCE
		if (_tcscmp(lpCmdLine, APP_RUN_AFTER_WAKEUP) == 0) {
			SendMessage(s_hWndMain, WM_USER_WAKEUP, 0, 0);
			return 0;
		}
#endif /* _WIN32_WCE */
		SetForegroundWindow((HWND)((ULONG)s_hWndMain|1)); // the |1 will activate any owned windows
		if (lpCmdLine != 0 && _tcslen(lpCmdLine) != 0) {
			COPYDATASTRUCT cs; 
			cs.dwData = 0; 
			cs.cbData = 2 + 2 * _tcslen(lpCmdLine); 
			cs.lpData = lpCmdLine;
			SendMessage(s_hWndMain, WM_COPYDATA, NULL, (LPARAM)&cs);
		}
		else 
			SendMessage(s_hWndMain, WM_APP, 0, 0);
		return 0;
	}

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
		return FALSE;
  
#ifdef _WIN32_WCE
/*
	{//FIXME Idle measurement 
		typedef DWORD (_stdcall *GetIdleTimeProc) (void);
		// get the pointer to the function
		GetIdleTimeProc GetIdleTime = (GetIdleTimeProc) GetProcAddress(LoadLibrary(_T("coredll.dll")), _T("GetIdleTime"));
		DWORD dwStartTick, dwIdleSt, dwStopTick, dwIdleEd;
		double PercentIdle;

		dwStartTick = GetTickCount();
		dwIdleSt = GetIdleTime();
		Sleep(2000);
		dwStopTick = GetTickCount();
		dwIdleEd = GetIdleTime();
		PercentIdle = ((100 * (dwIdleEd - dwIdleSt)) / (dwStopTick - dwStartTick));
		printf("Percent Idle: %f\r\n", PercentIdle);
	}
*/

	{ // Main message loop:
		MSG msg;
		CeRunAppAtEvent(exepath, NOTIFICATION_EVENT_WAKEUP);
		while (GetMessage(&msg, NULL, 0, 0)) {
			if (! sliderpopup_pretranslate_message(&s_SliderPopup, &msg)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		CeRunAppAtEvent(exepath, NOTIFICATION_EVENT_NONE);
		return msg.wParam;
	}
#else
	return 0;
#endif /* _WIN32_WCE */
}

//
//  FUNCTION: MyRegisterClass()
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
  WNDCLASS	wc;
  
  wc.style			= CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc	= (WNDPROC)WndProc;
  wc.cbClsExtra		= 0;
  wc.cbWndExtra		= 0;
  wc.hInstance		= hInstance;
  wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_TRACKSTYLUS));
  wc.hCursor		= 0;
  wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
  wc.lpszMenuName	= 0;
  wc.lpszClassName	= szWindowClass;
  
  return RegisterClass(&wc);
}

//
//  FUNCTION: InitInstance(HANDLE, int)
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd;
	int		nStyle = 0;

	g_hInst = hInstance;		// Store instance handle in our global variable

	// Initialize classes
	MyRegisterClass(hInstance, szWindowClass);
	waterfall_register_class(hInstance);
	sliderpopup_register_class(g_hInst);
	trx_register_classes(g_hInst);

	memset(s_aChannels, 0, sizeof(Trx*) * CHANNELS_MAX);

	nStyle = WS_VISIBLE;
#ifndef _WIN32_WCE
	nStyle |= WS_OVERLAPPEDWINDOW;
	s_hMenuChannels			= CreatePopupMenu();
	s_hMenuMacros			= CreatePopupMenu();


//	dbgwaterfall_register_class(hInstance);
//	dbgwaterfall_init(&s_DbgWaterfall);	
#endif /* _WIN32_WCE */
	
	hWnd = CreateWindow(szWindowClass, szTitle, nStyle,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	s_hWndMain = hWnd;

	sndmodem_init(&s_SndModem, s_hWndMain, s_aChannels, CHANNELS_MAX, &s_Waterfall);
	fix_fft_initialize();
	waterfall_init(&s_Waterfall);
	macro_load();
	stninfo_load();
	macro_update_menu(s_hMenuMacros);
  
	UpdateMenuChannels();

	CheckMenuRadioItem(s_hMenuWaterfallZoom, ID_FFTSIZE_0, ID_FFTSIZE_2, 
		ID_FFTSIZE_0 + s_Waterfall.config.magnification, MF_BYCOMMAND);
	CheckMenuRadioItem(s_hMenuWaterfallSpeed, ID_WATERFALL_SPEED_HALF, ID_WATERFALL_SPEED_TRIPLE, 
		ID_WATERFALL_SPEED_HALF + s_Waterfall.config.speed, MF_BYCOMMAND);

	waterfall_create(&s_Waterfall, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE, 0, 0, 240, 100, hWnd, hInstance);
	sliderpopup_init(&s_SliderPopup);

#ifndef _WIN32_WCE
//	dbgwaterfall_create(&s_DbgWaterfall, WS_CAPTION | WS_POPUPWINDOW  | WS_CLIPSIBLINGS | WS_VISIBLE, 
//		0, 0, 2200, 300, 0, hInstance);
#endif /* _WIN32_WCE */

	if (! hWnd)
		return FALSE;
  
    DoLayout();
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	return TRUE;
}

#ifdef _WIN32_WCE
void trx_set_scope(int *data, int len, BOOL autoscale)
{
/*
	HDC hDC = ::GetDC(s_hWndMain);
	RECT rect;
	rect.left   = 0;
	rect.top    = 151;
	rect.right  = 16;
	rect.bottom = 180;
	::ScrollWindowEx(s_hWndMain, 16, 0, &rect, 0, 0, 0, 0);
	for (UINT i = 0; i < 16; ++ i)
		::SetPixel(hDC, i, 180 - (data[i] >> 9), RGB(0, 0, 0));
	::ReleaseDC(s_hWndMain, hDC);
	*/
//FIXME
//	Miniscope *m = MINISCOPE(lookup_widget(appwindow, "miniscope"));
//	miniscope_set_data(m, data, len, autoscale);
}
#endif /* _WIN32_WCE */

static void UpdateMenuChannels()
{
	int i;
	HMENU hMenuModes = 0;
	Trx *pChannel = (s_iChannelActive == -1) ? 0 : s_aChannels[s_iChannelActive];
	TCHAR buf[256];

	if (s_hMenuChannels == 0)
		return;

	// Remove all items
	for (i = 0; i < CHANNELS_MAX + 5; ++ i)
		if (! DeleteMenu(s_hMenuChannels, 0, MF_BYPOSITION))
			break;

	for (i = 0; i < CHANNELS_MAX; ++ i)
		if (s_aChannels[i] != 0) {
			TCHAR strChannel[10];
			_tcscpy(strChannel, _T("Channel 0"));
			strChannel[8] += i;
			AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_CHANNEL0 + i, strChannel);
		}

	CheckMenuRadioItem(s_hMenuChannels, ID_CHANNEL0, ID_CHANNEL0 + CHANNELS_MAX - 1,
		ID_CHANNEL0 + s_iChannelActive, MF_BYCOMMAND);

	hMenuModes = CreatePopupMenu();
	AppendMenu(hMenuModes, MF_ENABLED | MF_STRING, ID_MODE_BPSK31, _T("BPSK31"));
	AppendMenu(hMenuModes, MF_ENABLED /* MF_GRAYED */ | MF_STRING, ID_MODE_QPSK31, _T("QPSK31"));
	AppendMenu(hMenuModes, MF_ENABLED | MF_STRING, ID_MODE_BPSK63, _T("BPSK63"));
	AppendMenu(hMenuModes, MF_ENABLED | MF_STRING, ID_MODE_RTTY,   _T("RTTY")); 
	AppendMenu(hMenuModes, MF_ENABLED | MF_STRING, ID_MODE_CW,	   _T("CW"));
	AppendMenu(hMenuModes, MF_ENABLED | MF_STRING, ID_MODE_MFSK16, _T("MFSK16"));
//	AppendMenu(hMenuModes, MF_ENABLED | MF_STRING, ID_MODE_MFSK8,  _T("MFSK8"));

	CheckMenuRadioItem(hMenuModes, ID_MODE_BPSK31, ID_MODE_MFSK16,
		ID_MODE_BPSK31 + pChannel->mode, MF_BYCOMMAND);

	AppendMenu(s_hMenuChannels, MF_ENABLED | MF_SEPARATOR, 0, 0);
	AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_CHANNEL_NEW,     _T("New Channel"));
	AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_CHANNEL_CLOSE,   _T("Close Channel"));
	AppendMenu(s_hMenuChannels, MF_ENABLED | MF_SEPARATOR, 0, 0);
	if (pChannel->pQso->strCall != 0 && _tcsicmp(pChannel->pQso->strCall, _T("")))
		_stprintf(buf, _T("QSO:\t%s"), pChannel->pQso->strCall);
	else
		_stprintf(buf, _T("QSO:\tNone"));
	AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_CHANNEL_QSOEDIT, buf);

	AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_LOGGING, _T("Logging"));
	if (pChannel->log.hFile)
		CheckMenuItem(s_hMenuChannels, ID_LOGGING, MF_BYCOMMAND | MF_CHECKED);

	_stprintf(buf, _T("Mode:\t%s"), trx_mode_names[pChannel->mode]);
	AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuModes, buf);

	if (pChannel->mode == MODE_BPSK31 ||
		pChannel->mode == MODE_QPSK31 ||
		pChannel->mode == MODE_PSK63  ||
		pChannel->mode == MODE_MFSK16) {
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_AFC, _T("AFC"));
		if (pChannel->afcon)
			CheckMenuItem(s_hMenuChannels, ID_AFC, MF_BYCOMMAND | MF_CHECKED);
	} 

	if (pChannel->mode == MODE_BPSK31 ||
		pChannel->mode == MODE_QPSK31 ||
		pChannel->mode == MODE_PSK63  ||
		pChannel->mode == MODE_MFSK16) {
		if (pChannel->squelchon)
			_stprintf(buf, _T("SQL:\t%3d%%"), pChannel->iSquelchThreshold);
		else
			_stprintf(buf, _T("SQL:\tOff"));
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_SQLTHR, buf);
		if (pChannel->squelchon)
			CheckMenuItem(s_hMenuChannels, ID_SQLTHR, MF_BYCOMMAND | MF_CHECKED);
	}

	if (pChannel->mode == MODE_RTTY || pChannel->mode == MODE_QPSK31) {
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_REVERSE, _T("Reverse"));
		if ((pChannel->mode == MODE_RTTY) ? pChannel->rtty_reverse : pChannel->reverse)
			CheckMenuItem(s_hMenuChannels, ID_REVERSE, MF_BYCOMMAND | MF_CHECKED);
	} else if (pChannel->mode == MODE_CW) {
		HMENU hMenuBW    = CreatePopupMenu();
		HMENU hMenuTaps  = CreatePopupMenu();
		HMENU hMenuSpeed = CreatePopupMenu();
		int   iValue	 = 0;
		AppendMenu(hMenuBW, MF_ENABLED | MF_STRING, ID_CWFILTWIDTH_10,  _T(" 10 Hz"));
		AppendMenu(hMenuBW, MF_ENABLED | MF_STRING, ID_CWFILTWIDTH_20,  _T(" 20 Hz"));
		AppendMenu(hMenuBW, MF_ENABLED | MF_STRING, ID_CWFILTWIDTH_30,	_T(" 30 Hz"));
		AppendMenu(hMenuBW, MF_ENABLED | MF_STRING, ID_CWFILTWIDTH_70,	_T(" 70 Hz"));
		AppendMenu(hMenuBW, MF_ENABLED | MF_STRING, ID_CWFILTWIDTH_150,	_T("150 Hz"));
		AppendMenu(hMenuBW, MF_ENABLED | MF_STRING, ID_CWFILTWIDTH_300,	_T("300 Hz"));
		CheckMenuRadioItem(hMenuBW, ID_CWFILTWIDTH_10, ID_CWFILTWIDTH_300,  ID_CWFILTWIDTH_10 + pChannel->cw_bandwidth, MF_BYCOMMAND);
		switch (pChannel->cw_bandwidth) {
			case 0: iValue = 10; break;
			case 1: iValue = 20; break;
			case 2: iValue = 30; break;
			case 3: iValue = 70; break;
			case 4: iValue = 150; break;
			case 5: iValue = 300; break;
		}
		_stprintf(buf, _T("Filter BW:\t%d Hz"), iValue);
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuBW, buf);
/*
		AppendMenu(hMenuTaps, MF_ENABLED | MF_STRING, ID_CWFILTTAPS_64,  _T(" 64"));
		AppendMenu(hMenuTaps, MF_ENABLED | MF_STRING, ID_CWFILTTAPS_96,  _T(" 96"));
		AppendMenu(hMenuTaps, MF_ENABLED | MF_STRING, ID_CWFILTTAPS_128, _T("128"));
		AppendMenu(hMenuTaps, MF_ENABLED | MF_STRING, ID_CWFILTTAPS_256, _T("256"));
		CheckMenuRadioItem(hMenuTaps, ID_CWFILTTAPS_64, ID_CWFILTTAPS_256, ID_CWFILTTAPS_64 + pChannel->cw_firtaps, MF_BYCOMMAND);
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuTaps, _T("Filter Taps"));
*/

		AppendMenu(hMenuSpeed, MF_ENABLED | MF_STRING, ID_CWWPMRX_1,  _T(" 1 WPM"));
		AppendMenu(hMenuSpeed, MF_ENABLED | MF_STRING, ID_CWWPMRX_2,  _T(" 2 WPM"));
		AppendMenu(hMenuSpeed, MF_ENABLED | MF_STRING, ID_CWWPMRX_5,  _T(" 5 WPM"));
		AppendMenu(hMenuSpeed, MF_ENABLED | MF_STRING, ID_CWWPMRX_10, _T("10 WPM"));
		AppendMenu(hMenuSpeed, MF_ENABLED | MF_STRING, ID_CWWPMRX_20, _T("20 WPM"));
		AppendMenu(hMenuSpeed, MF_ENABLED | MF_STRING, ID_CWWPMRX_40, _T("40 WPM"));
		AppendMenu(hMenuSpeed, MF_ENABLED | MF_STRING, ID_CWWPMRX_60, _T("60 WPM"));
		CheckMenuRadioItem(hMenuSpeed, ID_CWWPMRX_1, ID_CWWPMRX_60, ID_CWWPMRX_1 + pChannel->cw_rxspeed, MF_BYCOMMAND);
		switch (pChannel->cw_bandwidth) {
			case 0: iValue = 1; break;
			case 1: iValue = 2; break;
			case 2: iValue = 5; break;
			case 3: iValue = 10; break;
			case 4: iValue = 20; break;
			case 5: iValue = 40; break;
			case 6: iValue = 60; break;
		}
		_stprintf(buf, _T("Max RX speed:\t%d WPM"), iValue);
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuSpeed, buf);

		_stprintf(buf, _T("TX speed:\t%d WPM"), pChannel->cw_txspeed);
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_CWWPMTX, buf);
	}
}

extern "C" void cw_set_bandwidth(Trx *trx);

LRESULT OnCommand(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	int wmId    = LOWORD(wParam);
	int wmEvent = HIWORD(wParam);

	if (wmId >= ID_CHANNEL0 && wmId <= ID_CHANNEL9) {
		if (trx_is_sending(s_aChannels[s_iChannelActive]))
			return 0;
		int iChannel = wmId - ID_CHANNEL0;
		s_iChannelActive = iChannel;
		UpdateMenuChannels();
		waterfall_draw_ruler(&s_Waterfall, 0);
		DoLayout();
		return 0;
	}

	// Parse the menu selections:
	switch (wmId) {
	case ID_FFTSIZE_0:
	case ID_FFTSIZE_1:
	case ID_FFTSIZE_2:
	case ID_FFTSIZE_4:
	{
		waterfall_set_magnification(&s_Waterfall, (wf_mag_t)(WATERFALL_MAG_0 + wmId - ID_FFTSIZE_0), TRUE);
		CheckMenuRadioItem(s_hMenuWaterfallZoom, ID_FFTSIZE_0, ID_FFTSIZE_4, wmId, MF_BYCOMMAND);
		break;
	}

	case ID_WATERFALL_SPEED_HALF:
	case ID_WATERFALL_SPEED_NORMAL:
	case ID_WATERFALL_SPEED_DOUBLE:
	case ID_WATERFALL_SPEED_TRIPLE:
	{
		int id = wmId - ID_WATERFALL_SPEED_HALF;
		s_Waterfall.config.speed = (wf_speed_t)(WATERFALL_SPEED_HALF + id);
		CheckMenuRadioItem(s_hMenuWaterfallSpeed, 0, 3, id, MF_BYPOSITION);
		break;
	}

	case ID_TOOLS_EXIT:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		int i;
		if (trx_is_sending(trx))
			return 0;
		sndmodem_destroy(&s_SndModem);
		DestroyWindow(s_hWndMain);
//FIXME
		for (i = 0; i < CHANNELS_MAX; ++ i) {
			if (s_aChannels[i] == 0)
				continue;
			trx_free(s_aChannels[i]);
			s_aChannels[i] = 0;
		}
/*
		waterfall_destroy(&s_Waterfall);
		s_iChannelActive = -1;
		DestroyWindow(s_hWndMain);
*/
		break;
	}
	case ID_TOOLS_ABOUT:
	{
		MessageBox(s_hWndMain,
			_T("PocketDigi - HF digital teletype for PocketPC\r\n")
			_T("http://pocketdigi.sourceforge.net\r\n")
			_T("Author: OK1IAK <bubnikv@seznam.cz>\r\n")
			_T("Based on GMFSK, Tomi Manninen, OH2BNS <oh2bns@sral.fi>\r\n")
			_T("Version ") VERSION,
			_T("PocketDigi - About"), MB_OK);
		break;
	}
	case ID_SHOWDEVINFO:
		devinfo_show();
		break;
	case ID_CHANNEL_NEW:
	{
		int i;
		if (trx_is_sending(s_aChannels[s_iChannelActive]))
			return 0;
		for (i = 0; i < CHANNELS_MAX; ++ i)
			if (s_aChannels[i] == 0)
				break;
		if (i < CHANNELS_MAX) {
			Trx *trxOld = s_aChannels[s_iChannelActive];
			Trx *trxNew = trx_new();
			s_aChannels[i] = trxNew;
			trxNew->reverse = trxOld->reverse;
			trxNew->rtty_reverse = trxOld->rtty_reverse;
			trxNew->mode = trxOld->mode;
			trx_initmodem(trxNew);
			trx_create(trxNew, s_hWndMain, g_hInst, &s_SndModem);
			trxNew->nChannelID = i;
			s_iChannelActive = i;
			UpdateMenuChannels();
			waterfall_draw_ruler(&s_Waterfall, 0);
			DoLayout();
		}
		break;
	}
	case ID_CHANNEL_CLOSE:
	{
		int i;
		if (trx_is_sending(s_aChannels[s_iChannelActive]))
			return 0;
		for (i = 0; i < CHANNELS_MAX; ++ i)
			if (i != s_iChannelActive && s_aChannels[i] != 0)
				break;
		if (i < CHANNELS_MAX) {
			trx_free(s_aChannels[s_iChannelActive]);
			s_aChannels[s_iChannelActive] = 0;
			s_iChannelActive = i;
			UpdateMenuChannels();
			waterfall_draw_ruler(&s_Waterfall, 0);
			DoLayout();
		}
		break;
	}
	case ID_SENDBUF:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		if (trx_is_sending(trx))
			return 0;
		sndmodem_stop_recording(&s_SndModem);
		trx->state = TRX_STATE_TX;
		trx->txinit(trx);
		trx_txloop(trx);
		break;
	}
	case ID_STOPTX:
	{
		if (! trx_is_sending(s_aChannels[s_iChannelActive]))
			return 0;		
		s_aChannels[s_iChannelActive]->stopflag = TRUE;
		break;
	}
	case ID_KILLTX:
	{
		if (! trx_is_sending(s_aChannels[s_iChannelActive]))
			return 0;
		s_aChannels[s_iChannelActive]->stopflag = TRUE;
		s_aChannels[s_iChannelActive]->state    = TRX_STATE_FLUSH;
		sndmodem_reset_playing(&s_SndModem);
		break;
	}
	case ID_MODE_BPSK31:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		if (trx_is_sending(trx) || trx->mode == ID_MODE_BPSK31)
			return 0;
		trx->mode = MODE_BPSK31;
		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_MODE_QPSK31:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		if (trx_is_sending(trx) || trx->mode == ID_MODE_QPSK31)
			return 0;
		trx->mode = MODE_QPSK31;
		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_MODE_BPSK63:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		if (trx_is_sending(trx) || trx->mode == ID_MODE_BPSK63)
			return 0;
		trx->mode = MODE_PSK63;
		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_MODE_RTTY:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		if (trx_is_sending(trx) || trx->mode == ID_MODE_RTTY)
			return 0;
		trx->mode = MODE_RTTY;
		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_MODE_MFSK16:
	case ID_MODE_MFSK8:
	{
		Trx			*trx	 = s_aChannels[s_iChannelActive];
		trx_mode_t	 newmode =(wmId == ID_MODE_MFSK16) ? MODE_MFSK16 : MODE_MFSK8;
		if (trx_is_sending(trx) || newmode == trx->mode)
			return 0;
		trx->mode = newmode;
		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_MODE_CW:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		if (trx_is_sending(trx) || trx->mode == ID_MODE_CW)
			return 0;
		trx->mode = MODE_CW;
		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_REVERSE:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		if (trx->mode == MODE_RTTY)
			trx->rtty_reverse = ! trx->rtty_reverse;
		else
			trx->reverse = ! trx->reverse;
		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_AFC:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		trx->afcon = ! trx->afcon;
//		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_SQL:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		trx->squelchon = ! trx->squelchon;
//		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_CWFILTWIDTH_10:
	case ID_CWFILTWIDTH_20:
	case ID_CWFILTWIDTH_30:
	case ID_CWFILTWIDTH_70:
	case ID_CWFILTWIDTH_150:
	case ID_CWFILTWIDTH_300:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		trx->cw_bandwidth = wmId - ID_CWFILTWIDTH_10;
		cw_set_bandwidth(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_CWFILTTAPS_64:
	case ID_CWFILTTAPS_96:
	case ID_CWFILTTAPS_128:
	case ID_CWFILTTAPS_256:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		trx->cw_firtaps = wmId - ID_CWFILTTAPS_64;
		cw_set_bandwidth(trx);
		UpdateMenuChannels();
		break;
	}

	case ID_CWWPMRX_1:
	case ID_CWWPMRX_2:
	case ID_CWWPMRX_5:
	case ID_CWWPMRX_10:
	case ID_CWWPMRX_20:
	case ID_CWWPMRX_40:
	case ID_CWWPMRX_60:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		trx->cw_rxspeed = wmId - ID_CWWPMRX_1;
		cw_set_bandwidth(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_CWWPMTX:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		if (trx_is_sending(trx))
			return 0;
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("TX Speed"), _T("%3d WPM"), FALSE, ID_CWWPMTXRES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	5);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	60);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		5);
		sliderpopup_set_value(&s_SliderPopup, trx->cw_txspeed);
		break;
	}
	case ID_CWWPMTXRES:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		trx->cw_txspeed = s_SliderPopup.iValue;
		UpdateMenuChannels();
		break;
	}

	case ID_SQLTHR:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		if (trx_is_sending(trx))
			return 0;
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 220, _T("Squelch"), _T("%3d%%"), TRUE, ID_SQLTHRRES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	0);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	100);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		10);
		sliderpopup_set_switch(&s_SliderPopup, trx->squelchon);
		sliderpopup_set_value(&s_SliderPopup, trx->iSquelchThreshold);
		break;
	}
	case ID_SQLTHRRES:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		trx->squelchon         = s_SliderPopup.bSwitchValue;
		trx->iSquelchThreshold = s_SliderPopup.iValue;
		UpdateMenuChannels();
		break;
	}

	case ID_TXVOLUME:
	{
		int vol = (int)(0.5 + (double)s_SndModem.iVolume * 100.0 / 65535.0);
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("TX Volume"), _T("%3d %%"), FALSE, ID_TXVOLUMERES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	100);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		5);
		sliderpopup_set_value(&s_SliderPopup, vol);
		s_SliderPopup.bUpdateOnDragging = true;
		break;
	}
	case ID_TXVOLUMERES:
	{
		int vol = (int)(0.5 + (double)s_SliderPopup.iValue * 65535.0 / 100.0);
		Trx *trx = s_aChannels[s_iChannelActive];
		s_SndModem.iVolume = vol;
		break;
	}

	case ID_WFTHRESHOLD:
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("Threshold dB"), _T("%3d db"), FALSE, ID_WFTHRESHOLDRES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	0);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	80);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		5);
		sliderpopup_set_value(&s_SliderPopup, s_Waterfall.config.iDecibelsThreshold);
		s_SliderPopup.bUpdateOnDragging = true;
		break;
	case ID_WFTHRESHOLDRES:
		s_Waterfall.config.iDecibelsThreshold = s_SliderPopup.iValue;
		break;

	case ID_WFRANGE:
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("Range dB"), _T("%3d db"), FALSE, ID_WFRANGERES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	0);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	80);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		5);
		sliderpopup_set_value(&s_SliderPopup, s_Waterfall.config.iDecibelsRange);
		s_SliderPopup.bUpdateOnDragging = true;
		break;
	case ID_WFRANGERES:
		s_Waterfall.config.iDecibelsRange = s_SliderPopup.iValue;
		break;

	case ID_MACRO_EXECUTE1:
	case ID_MACRO_EXECUTE2:
	case ID_MACRO_EXECUTE3:
	case ID_MACRO_EXECUTE4:
	case ID_MACRO_EXECUTE5:
	case ID_MACRO_EXECUTE6:
	case ID_MACRO_EXECUTE7:
	case ID_MACRO_EXECUTE8:
	case ID_MACRO_EXECUTE9:
	case ID_MACRO_EXECUTE10:
	case ID_MACRO_EXECUTE11:
	case ID_MACRO_EXECUTE12:
		macro_send(s_aChannels[s_iChannelActive], wmId - ID_MACRO_EXECUTE1);
		break;

	case ID_MACRO_SENDFILE:
		macro_chooseandsendfile(s_aChannels[s_iChannelActive]);
		break;

	case ID_MACRO_EDIT1:
	case ID_MACRO_EDIT2:
	case ID_MACRO_EDIT3:
	case ID_MACRO_EDIT4:
	case ID_MACRO_EDIT5:
	case ID_MACRO_EDIT6:
	case ID_MACRO_EDIT7:
	case ID_MACRO_EDIT8:
	case ID_MACRO_EDIT9:
	case ID_MACRO_EDIT10:
	case ID_MACRO_EDIT11:
	case ID_MACRO_EDIT12:
		macro_edit(wmId - ID_MACRO_EDIT1);
		macro_update_menu(s_hMenuMacros);
		break;

	case ID_MACRO_DEFAULTS:
		macro_load_defaults();
		macro_update_menu(s_hMenuMacros);
		break;

	case ID_STNINFO_EDIT:
		stninfo_edit();
		break;

	case ID_CHANNEL_QSOEDIT:
		qsodata_edit(s_aChannels[s_iChannelActive]->pQso);
		UpdateMenuChannels();
		break;

	case ID_LOGGING:
	{
		Trx *trx = s_aChannels[s_iChannelActive];
		log_to_file_activate(&trx->log, trx->log.hFile == 0, s_iChannelActive);
		UpdateMenuChannels();
		break;
	}

	default:
		return DefWindowProc(hWnd, WM_COMMAND, wParam, lParam);
	}
	return 0;
}

/*
#if defined( FOR_PocketPC )
// ::GetSystemMetrics( SM_CYMENU ) returns 23, which is too small
// SM_CYMENUSIZE is not defined for Windows CE 3.0 and newer
// 26 from Shell sample for eVT; also from p. 776 of Boling 2nd Edition, and
//  16 Aug 2000 contribution from Gary Peluso to thread called "Full Size PocketPC Dialogs"
//  in microsoft.public.windowsce.app.development
// 15 Aug 03 contribution from Tim Wilson to thread called "menu height?"
//  in microsoft.public.pocketpc.developer suggested using SystemInformation, but
//  BZ found that SystemInformation is part of .NET
const g_kiMenuHeight = 26;
#elif defined( FOR_Smartphone)
// 24 seems to be the right value (BZ guestimate) 25 Mar 04 (4.0.0.59)
const g_kiMenuHeight = 24;
#endif

// 13 Feb 05 (7.7.0.21)
// use ToolBar
// See 20-24 Feb 04 called "SHCreateMenuBar() without a resource file" in
//  microsoft.public.pocketpc.developer. In particular, see 20 Feb 04
//  contribution from Almond Stowger for ideas adapated here. Also, a
//  19 Feb 04 contribution from Eddy Escardo says:
//      SHCreateMenuBar does not currently support programatically
//      generated HMENUs, as the SHCMBF_HMENU flag just means that
//      nToolBarId will represent the ID of a menu in a compiled
//      resource module, not an actual HMENU that you can pass to
//      the SHCreateMenuBar call (as you've probably figured out by now).
// 13 Feb 05
// Adapted from 19 April 2001 contribution by Alex Blekhman to thread
//  called "Toolbar help please" in comp.os.ms-windows.programmer.win32
    DWORD dwStyle = CCS_NODIVIDER | CCS_NOPARENTALIGN | CCS_NORESIZE |
        TBSTYLE_FLAT | TBSTYLE_LIST | WS_CHILD | WS_VISIBLE;
	ASSERT( m_nID != 0 );   // Should be set by initInternal
    VERIFY(PFInitCCCommandBar());
    m_hWnd = CreateWindowEx(
            0,                  // DWORD dwExStyle
            TOOLBARCLASSNAME,   // LPCTSTR lpClassName
            NULL,               // LPCTSTR lpWindowName
            dwStyle,            // DWORD dwStyle
            ClsPFDialogBox::Gap(),
            0,
        // BZ added WS_BORDER to styles (to make edges visible), then experimented
        //  with x and width. Multiplier needed on right for symmetry depended on
        //  whether CS_NORESIZE was included in styles
        //      5 with CS_NORESIZE
        //      7 without CS_NORESIZE
        //  TODO: Why?
	::GetSystemMetrics( SM_CXSCREEN ) - (ClsPFDialogBox::Gap() * 5),
        g_kiMenuHeight,
        m_hWndParent,
        reinterpret_cast<HMENU>(m_nID),  //
		HMENU hMenu
        m_hInstance,        // HINSTANCE hInstance
		NULL);              // LPVOID lpParam
    ASSERT( IsWindow() );
    ASSERT( pMenu != NULL );

    m_sClassName = TOOLBARCLASSNAME;    // keep Validate happy
    IGNORE_RETURN( PFWSendMessage( TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON ), 0 ) );
    m_bIsToolBar = TRUE;
    VERIFY( BuildFromStruct( pMenu ) );
*/

LRESULT	OnMainWindowCreate(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	// When the main window is created using CW_USEDEFAULT the height of the menubar (if one
	// is created is not taken into account). So we resize the window after creating it.
	RECT	rect, rectWnd;
	HMENU	hMenuTools, hMenuWaterfall;
#ifdef _WIN32_WCE
	SHMENUBARINFO mbi;
#endif /* _WIN32_WCE */

    // Start by initializing the common control libraries
	// Menu needs it to work correctly.
	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC  = ICC_BAR_CLASSES;
    InitCommonControlsEx(&icc);

#ifdef _WIN32_WCE
	GetWindowRect(hWnd, &rect);
	rect.bottom -= MENU_HEIGHT;
	//FIXME hide title
//	rect.top     = 0;
	MoveWindow(hWnd, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, FALSE);
#else /* _WIN32_WCE */
	GetWindowRect(s_hWndMain, &rectWnd);
	GetClientRect(s_hWndMain, &rect);
	MoveWindow(s_hWndMain, rectWnd.left, rectWnd.top,
		240 + rectWnd.right - rectWnd.left - rect.right,
		320 - MENU_HEIGHT + rectWnd.bottom - rectWnd.top - rect.bottom, FALSE);
	GetWindowRect(s_hWndMain, &rect);
#endif /* _WIN32_WCE */

  	s_aChannels[0] = trx_new();
	trx_create(s_aChannels[0], hWnd, g_hInst, &s_SndModem);
	s_aChannels[0]->nChannelID = 0;
	s_iChannelActive = 0;
	
	// Create a MenuBar
#ifdef _WIN32_WCE
	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize     = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hWnd;
	mbi.hInstRes   = g_hInst;
	mbi.nToolBarId = IDR_MENUBAR2; // IDM_MAIN_MENU;	
    if (!SHCreateMenuBar(&mbi)) {
		MessageBox(hWnd, L"SHCreateMenuBar Failed - type 1", L"Error", MB_OK);
    } else {
		s_hWndCommandBar = mbi.hwndMB;
		hMenuTools		 = SHGetSubMenu(s_hWndCommandBar, IDM_MAIN_MENUITEM2);
		s_hMenuChannels  = SHGetSubMenu(s_hWndCommandBar, IDM_MAIN_MENUITEM3);
		s_hMenuMacros    = SHGetSubMenu(s_hWndCommandBar, IDM_MAIN_MENUITEM4);
		if (hMenuTools == 0)
			MessageBox(hWnd, L"Menu Tools handler not acquired - type1", L"Error", MB_OK);
		if (s_hMenuChannels == 0)
			MessageBox(hWnd, L"Menu Channels handler not acquired - type1", L"Error", MB_OK);
		if (s_hMenuMacros == 0)
			MessageBox(hWnd, L"Menu Macros handler not acquired - type1", L"Error", MB_OK);
	}

    if (s_hWndCommandBar == 0 || hMenuTools == 0 || s_hMenuChannels == 0 || s_hMenuMacros == 0) {
		// try another run
		memset(&mbi, 0, sizeof(SHMENUBARINFO));
		mbi.cbSize     = sizeof(SHMENUBARINFO);
		mbi.hwndParent = hWnd;
		mbi.hInstRes   = g_hInst;
		mbi.nToolBarId = IDR_MENUBAR2; // IDM_MAIN_MENU;	
		mbi.dwFlags	   = SHCMBF_HMENU;
		if (!SHCreateMenuBar(&mbi)) {
			MessageBox(hWnd, L"SHCreateMenuBar Failed - type 2", L"Error", MB_OK);
		} else {
			s_hWndCommandBar = mbi.hwndMB;
			HMENU hMenu		 = SHGetMenu(s_hWndCommandBar);
			hMenuTools		 = GetSubMenu(hMenu, 1);
			s_hMenuChannels  = GetSubMenu(hMenu, 2);
			s_hMenuMacros    = GetSubMenu(hMenu, 3);
			if (hMenuTools == 0)
				MessageBox(hWnd, L"Menu Tools handler not acquired - type2", L"Error", MB_OK);
			if (s_hMenuChannels == 0)
				MessageBox(hWnd, L"Menu Channels handler not acquired - type2", L"Error", MB_OK);
			if (s_hMenuMacros == 0)
				MessageBox(hWnd, L"Menu Macros handler not acquired - type2", L"Error", MB_OK);
		}
	}

	if (s_hWndCommandBar == 0 || hMenuTools == 0 || s_hMenuChannels == 0 || s_hMenuMacros == 0) {
		HMENU hMenu		 = 0;
		s_hWndCommandBar = CommandBar_Create(g_hInst, hWnd, 101010);
		if (s_hWndCommandBar == 0) {
			MessageBox(hWnd, L"CommandBar_Create Failed - type 3", L"Error", MB_OK);
		} else {
			memset(&mbi, 0, sizeof(SHMENUBARINFO));
			mbi.cbSize     = sizeof(SHMENUBARINFO);
			mbi.hwndParent = hWnd;
			mbi.hInstRes   = g_hInst;
			mbi.dwFlags	   = SHCMBF_EMPTYBAR;
			if (! SHCreateMenuBar(&mbi))
				MessageBox(hWnd, L"SHCMBF_EMPTYBAR Failed - type 3", L"Error", MB_OK);
			CommandBar_InsertMenubar(s_hWndCommandBar, g_hInst, IDR_MENUBAR2 /* IDM_MAIN_MENU */, 0);
			hMenu			 = CommandBar_GetMenu(s_hWndCommandBar, 0);
			hMenuTools		 = GetSubMenu(hMenu, 1);
			s_hMenuChannels  = GetSubMenu(hMenu, 2);
			s_hMenuMacros    = GetSubMenu(hMenu, 3);
			if (hMenuTools == 0)
				MessageBox(hWnd, L"Menu Tools handler not acquired - type3", L"Error", MB_OK);
			if (s_hMenuChannels == 0)
				MessageBox(hWnd, L"Menu Channels handler not acquired - type3", L"Error", MB_OK);
			if (s_hMenuMacros == 0)
				MessageBox(hWnd, L"Menu Macros handler not acquired - type3", L"Error", MB_OK);
		}
	}

	if (s_hWndCommandBar == 0 || hMenuTools == 0 || s_hMenuChannels == 0 || s_hMenuMacros == 0)
		MessageBox(hWnd, L"Menu creation failed", L"Error", MB_OK);

	DeleteMenu(hMenuTools,	  0, MF_BYPOSITION);
	DeleteMenu(s_hMenuMacros, 0, MF_BYPOSITION);

/*
	SendMessage(s_hWndCommandBar, TB_DELETEBUTTON, 0, 0);

    HMENU hMenuTools = SHGetSubMenu(s_hWndCommandBar, IDM_MAIN_MENUITEM2);

	TBBUTTON tbButton;
	memset(&tbButton, 0, sizeof(TBBUTTON));
	tbButton.iBitmap   = I_IMAGENONE;
	tbButton.idCommand = 0x6969;
	tbButton.fsState   = TBSTATE_ENABLED;
	tbButton.fsStyle   = TBSTYLE_DROPDOWN | TBSTYLE_AUTOSIZE | 0x80;
	tbButton.dwData    = (DWORD)s_hMenuWaterfallZoom;
	tbButton.iString   = (int)_T("FFT");
	CommandBar_InsertButton(s_hWndCommandBar, 0, &tbButton);
	tbButton.idCommand = 0x6970;
	tbButton.dwData    = (DWORD)hMenuTools;
	tbButton.iString   = (int)_T("Tools");
	CommandBar_InsertButton(s_hWndCommandBar, 1, &tbButton);
	tbButton.idCommand = 0x6971;
	tbButton.dwData    = (DWORD)s_hMenuChannels;
	tbButton.iString   = (int)_T("Channels");
	CommandBar_InsertButton(s_hWndCommandBar, 2, &tbButton);
*/
#else /*  _WIN32_WCE */
	{ 
		HMENU hMenu	= CreateMenu();
		hMenuTools	= CreatePopupMenu();
		AppendMenu(hMenu, MF_POPUP | MF_ENABLED, (UINT_PTR)hMenuTools,		_T("Tools"));
		AppendMenu(hMenu, MF_POPUP | MF_ENABLED, (UINT_PTR)s_hMenuChannels,	_T("Channels"));
		AppendMenu(hMenu, MF_POPUP | MF_ENABLED, (UINT_PTR)s_hMenuMacros,	_T("Macros"));
		SetMenu(hWnd, hMenu);
	}
#endif /* _WIN32_WCE */

	s_hMenuWaterfallZoom = CreatePopupMenu();
	AppendMenu(s_hMenuWaterfallZoom, MF_ENABLED | MF_STRING, ID_FFTSIZE_0,  _T("Normal"));
	AppendMenu(s_hMenuWaterfallZoom, MF_ENABLED | MF_STRING, ID_FFTSIZE_1,  _T("x2"));
	AppendMenu(s_hMenuWaterfallZoom, MF_ENABLED | MF_STRING, ID_FFTSIZE_2,  _T("x4"));
//	AppendMenu(s_hMenuWaterfallZoom, MF_ENABLED | MF_STRING, ID_FFTSIZE_4,  _T("x8"));

	s_hMenuWaterfallSpeed = CreatePopupMenu();
	AppendMenu(s_hMenuWaterfallSpeed, MF_ENABLED | MF_STRING, ID_WATERFALL_SPEED_HALF,   _T("Half"));
	AppendMenu(s_hMenuWaterfallSpeed, MF_ENABLED | MF_STRING, ID_WATERFALL_SPEED_NORMAL, _T("Normal"));
	AppendMenu(s_hMenuWaterfallSpeed, MF_ENABLED | MF_STRING, ID_WATERFALL_SPEED_DOUBLE, _T("x2"));
	AppendMenu(s_hMenuWaterfallSpeed, MF_ENABLED | MF_STRING, ID_WATERFALL_SPEED_TRIPLE, _T("x3"));

	hMenuWaterfall = CreatePopupMenu();
	AppendMenu(hMenuWaterfall, MF_POPUP | MF_ENABLED, (UINT_PTR)s_hMenuWaterfallZoom,	_T("Zoom"));
	AppendMenu(hMenuWaterfall, MF_POPUP | MF_ENABLED, (UINT_PTR)s_hMenuWaterfallSpeed,  _T("Speed"));
	AppendMenu(hMenuWaterfall, MF_ENABLED | MF_STRING, ID_WFTHRESHOLD,	_T("Threshold dB"));
	AppendMenu(hMenuWaterfall, MF_ENABLED | MF_STRING, ID_WFRANGE,		_T("Range dB"));

	AppendMenu(hMenuTools, MF_ENABLED | MF_STRING, ID_SENDBUF,		_T("Send"));
	AppendMenu(hMenuTools, MF_ENABLED | MF_STRING, ID_STOPTX,		_T("TX stop"));
	AppendMenu(hMenuTools, MF_ENABLED | MF_STRING, ID_KILLTX,		_T("TX kill"));
	AppendMenu(hMenuTools, MF_ENABLED | MF_SEPARATOR, 0, 0);
	AppendMenu(hMenuTools, MF_ENABLED | MF_STRING, ID_STNINFO_EDIT, _T("Station Info"));
	AppendMenu(hMenuTools, MF_POPUP   | MF_ENABLED, (UINT_PTR)hMenuWaterfall, _T("Waterfall"));
	AppendMenu(hMenuTools, MF_ENABLED | MF_STRING, ID_TXVOLUME,		_T("TX Volume"));
	AppendMenu(hMenuTools, MF_ENABLED | MF_SEPARATOR, 0, 0);	
	AppendMenu(hMenuTools, MF_ENABLED | MF_STRING, ID_TOOLS_ABOUT, _T("About"));
	AppendMenu(hMenuTools, MF_ENABLED | MF_STRING, ID_SHOWDEVINFO, _T("Device Info"));
	AppendMenu(hMenuTools, MF_ENABLED | MF_STRING, ID_TOOLS_EXIT,  _T("Exit"));

	return 0;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#ifdef _WIN32_WCE
	static SHACTIVATEINFO sai;
#else /* _WIN32_WCE */
	MSG msg;
	msg.hwnd = hWnd;
	msg.message = message;
	msg.wParam = wParam;
	msg.lParam = lParam;
	::sliderpopup_pretranslate_message(&s_SliderPopup, &msg);
#endif /* _WIN32_WCE */

	switch (message) 
	{
	case WM_COMMAND:
		return OnCommand(hWnd, wParam, lParam);
	case WM_CREATE:
#ifdef _WIN32_WCE
		memset(&sai, 0, sizeof(SHACTIVATEINFO));
#endif /* _WIN32_WCE */
		return OnMainWindowCreate(hWnd, message, wParam, lParam);
	case WM_USER_WAKEUP:
		if (trx_is_sending(s_aChannels[s_iChannelActive])) {
			s_aChannels[s_iChannelActive]->stopflag = TRUE;
			s_aChannels[s_iChannelActive]->state    = TRX_STATE_FLUSH;
			sndmodem_reset_playing(&s_SndModem);
			waveOutRestart(s_SndModem.hWaveOut);
		} else
			waveInStart(s_SndModem.hWaveIn);
		break;
	case WM_ACTIVATE:
//   		if (s_iChannelActive == -1) // exiting
//			break;
#ifdef _WIN32_WCE
		if (SPI_SETSIPINFO == wParam){
//			memset(&sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMActivate(hWnd, wParam, lParam, &sai, 0);
		}
		//FIXME fullscreen
//		SHFullScreen(hWnd, SHFS_HIDETASKBAR);
//		if (LOWORD(wParam) == WA_ACTIVE && s_SndModem.hWaveIn == 0) {
//			sndmodem_init(&s_SndModem, hWnd, s_aChannels, CHANNELS_MAX, &s_Waterfall);
//			waveInStart(s_SndModem.hWaveIn);
//		}
#endif /* _WIN32_WCE */
		break;
      case WM_DESTROY:
        // Destroy MenuBar
        DestroyWindow(s_hWndCommandBar);
		macro_store();
		stninfo_store();
		waterfall_store(&s_Waterfall);
        PostQuitMessage(0);
        break;
	  case WM_SIZE:
		  DoLayout();
		  break;
	case WM_ERASEBKGND:
		// ignore background erasing
		return TRUE;
	case WM_SETTINGCHANGE:
#ifdef _WIN32_WCE
		if (wParam == SPI_SETSIPINFO) {
//			memset(&sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMSettingChange(hWnd, -1, 0, &sai);
		}
#endif /* _WIN32_WCE */
		break;
	  case MM_WIM_DATA:
		sndmodem_wim_data(&s_SndModem);
		break;
	  case MM_WIM_CLOSE:
		sndmodem_wim_close(&s_SndModem);
		break;
	  case MM_WOM_DONE:
		sndmodem_wom_done(&s_SndModem);
		break;
	  case MM_WOM_CLOSE:
		sndmodem_wom_close(&s_SndModem);
		break;
      default:
        return DefWindowProc(hWnd, message, wParam, lParam);
  }
  return 0;
}
