/*
 *    macro.h  --  Fixtexts and macros
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __MACRO_H
#define __MACRO_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "trx.h"

/* ---------------------------------------------------------------------- */

extern BOOL macro_edit(int n);
extern void	macro_update_menu(HMENU hMenu);
extern void macro_send(Trx *trx, int n);
extern void macro_sendtext(Trx *trx, LPCTSTR strMacro, BOOL bRaw);
extern BOOL macro_sendfile(Trx *trx, LPCTSTR szFilePath, BOOL bRaw, BOOL bLock);
extern BOOL macro_chooseandsendfile(Trx *trx);

/// Load all macros from registry.
/// If the registry is empty, add default values
extern void macro_load();
/// Set default macros
extern void macro_load_defaults();
/// Store macros in the registry
extern void macro_store();

#define NUMMACROS		12

/* ---------------------------------------------------------------------- */

#define MACRODEF1NAME	_T("CQ")
#define	MACRODEF1TEXT	\
_T("$tx\r\n")\
_T("cq cq cq de $mycall $mycall $mycall pse k\r\n")\
_T("$rxandclear")

#define MACRODEF2NAME	_T("Call 3")
#define MACRODEF2TEXT	\
_T("$tx\r\n")\
_T("$call $call $call de $mycall $mycall $mycall k")\
_T("$rxandclear")

#define MACRODEF3NAME	_T("Call")
#define MACRODEF3TEXT	_T("$tx\r\n$call de $mycall")

#define MACRODEF4NAME	_T("BTU")
#define MACRODEF4TEXT	_T("btu $call de $mycall k\r\n$rx")

#define MACRODEF5NAME	_T("Signoff")
#define MACRODEF5TEXT	_T("73 $call de $mycall sk\r\n$rx")

#define MACRODEF6NAME	_T("Brag")
#define MACRODEF6TEXT	_T("The equipment is as follows:\r\n$ver\r\n")

#define MACRODEF7NAME	_T("Time")
#define MACRODEF7TEXT	_T("$utctime")

#define MACRODEF8NAME	_T("Date")
#define MACRODEF8TEXT	_T("$utcdate")

#define MACRODEF9NAME	_T("T/R")
#define MACRODEF9TEXT	_T("$txtoggle")

#define MACRODEF10NAME	_T("")
#define MACRODEF10TEXT	_T("")

#define MACRODEF11NAME	_T("")
#define MACRODEF11TEXT	_T("")

#define MACRODEF12NAME	_T("")
#define MACRODEF12TEXT	_T("")

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __MACRO_H */
