#ifndef __DLGGEN_H__
#define __DLGGEN_H__

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define DLG_MARGIN 3

typedef struct _DlgTemplate		DlgTemplate;

struct _DlgTemplate 
{ 
	DLGTEMPLATE	   *pTemplate;
	int				nLength;
	int				nSize;
};

extern DlgTemplate*	dlggen_new();
extern void			dlggen_free(DlgTemplate *tmpl);

extern void			dlggen_create(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, int x, int y, int w, int h,
    LPCTSTR font /* = 0 */, LONG fontSize /* = 8 */);
extern HWND			dlggen_create_dialog(DlgTemplate *tmpl,
	HINSTANCE hInstance, HWND hWndParent, DLGPROC lpDialogFunc);
extern int			dlggen_dialog_box(DlgTemplate *tmpl,
	HINSTANCE hInstance, HWND hWndParent, DLGPROC lpDialogFunc);
extern void			dlggen_destroy(DlgTemplate *tmpl);

extern void			dlggen_add_component(DlgTemplate *tmpl, 
    LPCTSTR type, LPCTSTR caption, DWORD style, DWORD exStyle,
    int x, int y, int w, int h, WORD id);
extern void			dlggen_add_button(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_edit_box(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_static(DlgTemplate *tmpl, 
    LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_listbox(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_scrollbar(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_combobox(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __DLGGEN_H__ */
