#include <windows.h>
#include <tchar.h>

#include "dlggen.h"

static void EnsureSpace(DlgTemplate *tmpl, int length)
{
	void *newBuffer = 0;
	if (length + tmpl->nLength <= tmpl->nSize)
		return;
	tmpl->nSize += length * 2;
	tmpl->pTemplate = realloc(tmpl->pTemplate, tmpl->nSize);
}

static void AppendData(DlgTemplate *tmpl, void* data, int dataLength)
{
	EnsureSpace(tmpl, dataLength);
	memcpy((char*)tmpl->pTemplate + tmpl->nLength, data, dataLength);
    tmpl->nLength += dataLength;
}

static void AlignData(DlgTemplate *tmpl, int size)
{
	int paddingSize = tmpl->nLength % size;
    if (paddingSize != 0) {
		EnsureSpace(tmpl, paddingSize);
        tmpl->nLength += paddingSize;
    }
}

static void AppendString(DlgTemplate *tmpl, LPCTSTR string)
{
#ifndef _UNICODE
	WCHAR* wideString = 0;
    int length = MultiByteToWideChar(CP_ACP, 0, string, -1, NULL, 0);
    wideString = (WCHAR*)malloc(length * sizeof(WCHAR));
    MultiByteToWideChar(CP_ACP, 0, string, -1, wideString, length);
    AppendData(tmpl, wideString, length * sizeof(WCHAR));
    free(wideString);
#else
	int length = (int)wcslen(string) + 1;
    AppendData(tmpl, (void*)string, length * sizeof(WCHAR));
#endif
}

static void AddStandardComponent(DlgTemplate *tmpl, 
	WORD type, LPCTSTR caption, DWORD style,
    DWORD exStyle, int x, int y, int w, int h, WORD id)
{
	DLGITEMTEMPLATE item;
    WORD preType = 0xFFFF;

    // DWORD algin the beginning of the component data
    AlignData(tmpl, sizeof(DWORD));

    item.style			 = style;
    item.x				 = x;
    item.y				 = y;
    item.cx				 = w;
    item.cy				 = h;
    item.id				 = id;
    item.dwExtendedStyle = exStyle;

    AppendData(tmpl, &item, sizeof(DLGITEMTEMPLATE));
    AppendData(tmpl, &preType, sizeof(WORD));
    AppendData(tmpl, &type, sizeof(WORD));
    AppendString(tmpl, caption);

	++ tmpl->pTemplate->cdit;
}

DlgTemplate* dlggen_new()
{
	DlgTemplate *tmpl = (DlgTemplate*)malloc(sizeof(DlgTemplate));
	if (tmpl == 0)
		return 0;
	memset(tmpl, 0, sizeof(DlgTemplate));
	return tmpl;
}

void dlggen_free(DlgTemplate *tmpl)
{
	if (tmpl == 0)
		return;
	dlggen_destroy(tmpl);
	free(tmpl);
}

extern void	dlggen_create(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, int x, int y, int w, int h,
    LPCTSTR font /* = 0 */, LONG fontSize /* = 8 */)
{
	memset(tmpl, 0, sizeof(DlgTemplate));
	tmpl->nLength	= sizeof(DLGTEMPLATE);
	tmpl->nSize		= tmpl->nLength;
	tmpl->pTemplate = (DLGTEMPLATE*)malloc(tmpl->nSize);
	tmpl->pTemplate->style			 = style | DS_SETFONT;
	tmpl->pTemplate->x				 = x;
	tmpl->pTemplate->y				 = y;
	tmpl->pTemplate->cx				 = w;
	tmpl->pTemplate->cy				 = h;
	tmpl->pTemplate->cdit			 = 0;
	tmpl->pTemplate->dwExtendedStyle = 0;

	//the dialog box doesn't have a menu or a special class
    AppendData(tmpl, _T("\0"), 2);
    AppendData(tmpl, _T("\0"), 2);

    //add the dialog's caption to the template
    AppendString(tmpl, caption);

    AppendData(tmpl, &fontSize, sizeof(WORD));
    AppendString(tmpl, font);
}

HWND dlggen_create_dialog(DlgTemplate *tmpl,
	HINSTANCE hInstance, HWND hWndParent, DLGPROC lpDialogFunc)
{
	return CreateDialogIndirect(hInstance, tmpl->pTemplate, hWndParent, lpDialogFunc);
}


int dlggen_dialog_box(DlgTemplate *tmpl,
	HINSTANCE hInstance, HWND hWndParent, DLGPROC lpDialogFunc)
{
	return DialogBoxIndirect(hInstance, tmpl->pTemplate, hWndParent, lpDialogFunc);
}

extern void	dlggen_destroy(DlgTemplate *tmpl)
{
	if (tmpl == 0)
		return;
	free(tmpl->pTemplate);
	memset(tmpl, 0, sizeof(DlgTemplate));
}

void dlggen_add_component(DlgTemplate *tmpl, 
	LPCTSTR type, LPCTSTR caption, DWORD style, DWORD exStyle,
    int x, int y, int w, int h, WORD id)
{
	DLGITEMTEMPLATE item;
    WORD creationDataLength = 0;

    item.style			 = style;
    item.x				 = x;
    item.y				 = y;
    item.cx				 = w;
    item.cy				 = h;
    item.id				 = id;
    item.dwExtendedStyle = exStyle;

    AppendData(tmpl, &item, sizeof(DLGITEMTEMPLATE));
    AppendString(tmpl, type);
    AppendString(tmpl, caption);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));

	++ tmpl->pTemplate->cdit;
}

void dlggen_add_button(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
	WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0080, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_edit_box(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
    WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0081, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_static(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
    WORD creationDataLength = 0;
	AddStandardComponent(tmpl, 0x0082, caption, style, exStyle, x, y, w, h, id);
	AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_listbox(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
	WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0083, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_scrollbar(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
    WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0084, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_combobox(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
    WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0085, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}
