#ifndef __DBGWATERFALL_H__
#define __DBGWATERFALL_H__

#include <windows.h>
#include <windowsx.h>

#include "main.h"
#include "../misc/cmplx.h"
#include "../misc/kiss_fft.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern const TBYTE WIN32CLASS_DBGWATERFALL[];

typedef struct _DbgWaterfall		DbgWaterfall;

/*
 * These are only defaults now.
 */

struct _DbgWaterfall 
{
	HWND		hWnd;
	HFONT		hFont;
	HBITMAP		hBitmap;
	HDC			hBitmapDC;
	UCHAR*		pBitmapBits;

	// size of pixbuf must be multiple of fftlen/2 and
	// big enough to hold the window data
	COLORREF   *pixbuf;
	int			pixbufsize;
	int			pixbufptr;

	complex	   *inbuf;
	int			inptr;

	int			fftlen;
	kiss_fft_cfg fftcfg;
	float	   *window;
    
	COLORREF   *aColorTable;
	int			nColorTableLen;
};

extern ATOM		dbgwaterfall_register_class(HINSTANCE hInstance);
extern DbgWaterfall*	dbgwaterfall_new();
extern void		dbgwaterfall_free(DbgWaterfall *wf);

BOOL			dbgwaterfall_init(DbgWaterfall *wf);
BOOL			dbgwaterfall_create(DbgWaterfall *wf, DWORD dwStyle,
	int x, int y, int nWidth, int nHeight, HWND hWndParent, HANDLE hInstance);
void			dbgwaterfall_destroy(DbgWaterfall *wf);
extern void		dbgwaterfall_set_data(DbgWaterfall *wf, complex *data, int len);
extern void		dbgwaterfall_set_data_raw(DbgWaterfall *wf, complex *aIn, int len);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __DBGWATERFALL_H__ */
