// PocketDigiView.cpp : implementation of the CPocketDigiView class
//

#include "stdafx.h"
#include "PocketDigi.h"

#include "PocketDigiDoc.h"
#include "PocketDigiView.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CPocketDigiView

CPocketDigiView *g_pView = 0;

IMPLEMENT_DYNCREATE(CPocketDigiView, CView)

BEGIN_MESSAGE_MAP(CPocketDigiView, CView)
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

// CPocketDigiView construction/destruction

CPocketDigiView::CPocketDigiView() :
	m_Graph(false)
{
	// TODO: add construction code here
	g_pView = this;

	m_Graph.SetGraphTitle("Test XY Line Graph");
	m_Graph.SetLegendTitle("Legend");
	m_Graph.SetXAxisLabel("time");
	m_Graph.SetYAxisLabel("pwr");
	m_Graph.EnableGridLines(TRUE);
}

CPocketDigiView::~CPocketDigiView()
{
}

BOOL CPocketDigiView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

// CPocketDigiView drawing

void CPocketDigiView::OnDraw(CDC *pDC)
{
	CPocketDigiDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	m_Graph.Draw(pDC);

	// TODO: add draw code for native data here
}


// CPocketDigiView printing

BOOL CPocketDigiView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CPocketDigiView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CPocketDigiView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}


// CPocketDigiView diagnostics

#ifdef _DEBUG
void CPocketDigiView::AssertValid() const
{
	CView::AssertValid();
}

void CPocketDigiView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CPocketDigiDoc* CPocketDigiView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPocketDigiDoc)));
	return (CPocketDigiDoc*)m_pDocument;
}
#endif //_DEBUG

void CPocketDigiView::trx_set_scope(int *data, int len, BOOL autoscale)
{
	//FIXME
//	return;

	int iMaxValue = 0;
	int iTickStep = 1;
	for (int i = 0; i < len; ++ i)
		if (data[i] > iMaxValue)
			iMaxValue = data[i];
	for (i = 0; i < 10; ++ i, iTickStep *= 10)
		if (iTickStep * 10 > iMaxValue)
			break;
	if (iMaxValue < 10.0)
		iMaxValue = 10;
	m_Graph.RemoveAllData();
	m_Graph.SetTickLimits(0.0, (double)len, 0.0, (double)iMaxValue);
	m_Graph.SetTickStep(10, iTickStep);
	m_Graph.OpenDataSet();
	for (int i = 0; i < len; ++ i)
		m_Graph.SetData(i, (double)data[i]);
	m_Graph.SetColor(RED);
//	m_Graph.SetDataLegend("pwr");
	m_Graph.CloseDataSet();
	Invalidate();
}

extern "C" {
void trx_set_scope(int *data, int len, BOOL autoscale)
{
	CPocketDigiView *pView = g_pView;
	if (pView != 0)
		pView->trx_set_scope(data, len, autoscale);
}
}

// CPocketDigiView message handlers
