// graphDraw4View.h : interface of the CGraphDraw4View class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_GRAPHDRAW4VIEW_H__7D7557BE_600A_46B5_864B_7D669214FB6E__INCLUDED_)
#define AFX_GRAPHDRAW4VIEW_H__7D7557BE_600A_46B5_864B_7D669214FB6E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BarGraph.h"
#include "XYLineGraph.h"
#include "ScatterGraph.h"
#include "BoxWhiskerGraph.h"
#include "StackedBarGraph.h"
#include "PieGraph.h"

class CGraphDraw4View : public CView
{
protected: // create from serialization only
	CGraphDraw4View();
	DECLARE_DYNCREATE(CGraphDraw4View)

// Attributes
public:
	CGraphDraw4Doc* GetDocument();
	BOOL okToDraw;

// Operations
public:
	int graphToDisplay;
	CBarGraph *myBar;
	CXYLineGraph *myXYLine;
	CScatterGraph *myScatter;
	CBoxWhiskerGraph *myBoxWhisker;
	CStackedBarGraph *myStackedBar;
	CPieGraph *myPie;
	CBarGraph *my3DBar;
	CXYLineGraph *my3DXYLine;
	CStackedBarGraph *my3DStackedBar;
	CPieGraph *my3DPie;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGraphDraw4View)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CGraphDraw4View();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CGraphDraw4View)
	afx_msg void OnDrawBar();
	afx_msg void OnDrawXyLine();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnAppExit();
	afx_msg void OnDrawScatter();
	afx_msg void OnDrawWhisker();
	afx_msg void OnDrawPie();
	afx_msg void OnDrawStackedBar();
	afx_msg void OnDraw3DBar();
	afx_msg void OnDraw3DXyLine();
	afx_msg void OnDraw3DPie();
	afx_msg void OnDraw3DStackedBar();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:

};

#ifndef _DEBUG  // debug version in graphDraw4View.cpp
inline CGraphDraw4Doc* CGraphDraw4View::GetDocument()
   { return (CGraphDraw4Doc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GRAPHDRAW4VIEW_H__7D7557BE_600A_46B5_864B_7D669214FB6E__INCLUDED_)
