// graphDraw4View.cpp : implementation of the CGraphDraw4View class
//

#include "stdafx.h"
#include "graphDraw4.h"

#include "graphDraw4Doc.h"
#include "graphDraw4View.h"
#include "TestCaseDlg.h"

#include <math.h>
#include "BarGraph.h"
#include "XYLineGraph.h"
#include "ScatterGraph.h"
#include "BoxWhiskerGraph.h"
#include "StackedBarGraph.h"
#include ".\graphdraw4view.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGraphDraw4View

IMPLEMENT_DYNCREATE(CGraphDraw4View, CView)

BEGIN_MESSAGE_MAP(CGraphDraw4View, CView)
	//{{AFX_MSG_MAP(CGraphDraw4View)
	ON_COMMAND(ID_DRAW_BAR, OnDrawBar)
	ON_COMMAND(ID_DRAW_XY_LINE, OnDrawXyLine)
	ON_WM_ERASEBKGND()
	ON_WM_TIMER()
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	ON_COMMAND(ID_DRAW_SCATTER, OnDrawScatter)
	ON_COMMAND(ID_DRAW_WHISKER, OnDrawWhisker)
	ON_COMMAND(ID_DRAW_STACKED_BAR, OnDrawStackedBar)
	ON_COMMAND(ID_DRAW_PIE, OnDrawPie)
	ON_COMMAND(ID_DRAW_3D_BAR, OnDraw3DBar)
	ON_COMMAND(ID_DRAW_3D_LINE, OnDraw3DXyLine)
	ON_COMMAND(ID_DRAW_3D_PIE, OnDraw3DPie)
	ON_COMMAND(ID_DRAW_3D_STACKED_BAR, OnDraw3DStackedBar)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphDraw4View construction/destruction

CGraphDraw4View::CGraphDraw4View()
{
	// TODO: add construction code here
	myBar = NULL;
	myXYLine = NULL;
	myScatter = NULL;
	myBoxWhisker = NULL;
	myStackedBar = NULL;
	my3DBar = NULL;
	my3DXYLine = NULL;
	myPie = NULL;
	my3DPie = NULL;
	my3DStackedBar = NULL;
	okToDraw = FALSE;
	graphToDisplay = 0;
}

CGraphDraw4View::~CGraphDraw4View()
{
	if(myBar != NULL)
		delete myBar;
	if(myXYLine != NULL)
		delete myXYLine;
	if(myScatter != NULL)
		delete myScatter;
	if(myBoxWhisker != NULL)
		delete myBoxWhisker;
	if(myPie != NULL)
		delete myPie;
	if(myStackedBar != NULL)
		delete myStackedBar;
	if(my3DXYLine != NULL)
		delete my3DXYLine;
	if(my3DPie != NULL)
		delete my3DPie;
	if(my3DStackedBar != NULL)
		delete my3DStackedBar;
}

BOOL CGraphDraw4View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CGraphDraw4View drawing

void CGraphDraw4View::OnDraw(CDC* pDC)
{
	CGraphDraw4Doc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
	if(okToDraw)
	{
		switch(graphToDisplay)
		{
			case 1 : myBar->Draw(pDC);
					 break;
			case 2 : myXYLine->Draw(pDC);
					 break;
			case 3 : myPie->Draw(pDC);
					 break;
			case 4 : myScatter->Draw(pDC);
					 break;
			case 5 : myBoxWhisker->Draw(pDC);
					 break;
			case 6 : myStackedBar->Draw(pDC);
					 break;
			case 7 : my3DBar->Draw(pDC);
					 break;
			case 8 : my3DXYLine->Draw(pDC);
					 break;
			case 9 : my3DStackedBar->Draw(pDC);
					 break;
			case 10 : my3DPie->Draw(pDC);
					  break;
		}
	}
	UpdateWindow();
}

/////////////////////////////////////////////////////////////////////////////
// CGraphDraw4View printing

BOOL CGraphDraw4View::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	pInfo->SetMaxPage(1);
	return DoPreparePrinting(pInfo);
}

void CGraphDraw4View::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// TODO: add extra initialization before printing
}

void CGraphDraw4View::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CGraphDraw4View diagnostics

#ifdef _DEBUG
void CGraphDraw4View::AssertValid() const
{
	CView::AssertValid();
}

void CGraphDraw4View::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CGraphDraw4Doc* CGraphDraw4View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGraphDraw4Doc)));
	return (CGraphDraw4Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGraphDraw4View message handlers

void CGraphDraw4View::OnDrawBar() 
{
	// TODO: Add your command handler code here
	int testcase;	//for testing purposes only...
	CTestCaseDlg tc;

	tc.DoModal();
	testcase = tc.m_nTestCase;

	KillTimer(0x1234);
	if(myBar != NULL)
		delete myBar;
	myBar = new CBarGraph(FALSE);
	myBar->SetGraphTitle("Test Bar Graph");
	myBar->SetLegendTitle("Legend");
	myBar->EnableGridLines(TRUE);
	myBar->SetXAxisLabel("Day-by-Day Comparison");
	myBar->SetYAxisLabel("PH Level");
	myBar->EnableDoubleBuffering(TRUE);

	switch(testcase)
	{
		case 1 :
				 myBar->SetTickLimits(0, 4, 5, 10);
				 myBar->SetTickStep(1,1);
				 myBar->EnableGridLines(TRUE);
				 myBar->SetXAxisLabel("X axis");
				 myBar->SetYAxisLabel("Y axis");
				 myBar->SetXTickLabel(0, " ");
				 myBar->SetXTickLabel(1, "t1");
				 myBar->SetXTickLabel(2, "t2");
				 myBar->SetXTickLabel(3, "t3");
				 myBar->SetXTickLabel(4, "t4");

				 myBar->OpenDataSet();
				 myBar->SetData(1, 6);
				 myBar->SetData(2, 7);
				 myBar->SetData(3, 8);
				 myBar->SetColor(RED);
				 myBar->SetDataLegend("data 1");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(1, 6);
				 myBar->SetData(2, 8);
				 myBar->SetData(3, 9);
				 myBar->SetColor(BLUE);
				 myBar->SetDataLegend("data 2");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(1, 5.5);
				 myBar->SetData(2, 7.5);
				 myBar->SetData(3, 9.5);
				 myBar->SetColor(GREEN);
				 myBar->SetDataLegend("data 3");
				 myBar->CloseDataSet();
			break;
		case 2 :
				 myBar->SetTickLimits(0, 4, -10, 0);
				 myBar->SetTickStep(1,1);
				 myBar->EnableGridLines(TRUE);
				 myBar->SetXAxisLabel("X axis");
				 myBar->SetYAxisLabel("Y axis");
				 myBar->SetXTickLabel(0, " ");
				 myBar->SetXTickLabel(1, "t1");
				 myBar->SetXTickLabel(2, "t2");
				 myBar->SetXTickLabel(3, "t3");
				 myBar->SetXTickLabel(4, "t4");

				 myBar->OpenDataSet();
				 myBar->SetData(1, -2);
				 myBar->SetData(2, -4);
				 myBar->SetData(3, -6);
				 myBar->SetColor(RED);
				 myBar->SetDataLegend("data 1");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(1, -3);
				 myBar->SetData(2, -6);
				 myBar->SetData(3, -9);
				 myBar->SetColor(BLUE);
				 myBar->SetDataLegend("data 2");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(1, -1.5);
				 myBar->SetData(2, -4.5);
				 myBar->SetData(3, -7.5);
				 myBar->SetColor(GREEN);
				 myBar->SetDataLegend("data 3");
				 myBar->CloseDataSet();
			break;
		case 3 :
				 myBar->SetTickLimits(-4, 0, 0, 10);
				 myBar->SetTickStep(1,1);
				 myBar->EnableGridLines(TRUE);
				 myBar->SetXAxisLabel("X axis");
				 myBar->SetYAxisLabel("Y axis");
				 myBar->SetXTickLabel(0, " ");
				 myBar->SetXTickLabel(1, "t1");
				 myBar->SetXTickLabel(2, "t2");
				 myBar->SetXTickLabel(3, "t3");
				 myBar->SetXTickLabel(4, "t4");

				 myBar->OpenDataSet();
				 myBar->SetData(-1, 2);
				 myBar->SetData(-2, 4);
				 myBar->SetData(-3, 6);
				 myBar->SetColor(RED);
				 myBar->SetDataLegend("data 1");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, 3);
				 myBar->SetData(-2, 6);
				 myBar->SetData(-3, 9);
				 myBar->SetColor(BLUE);
				 myBar->SetDataLegend("data 2");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, 1.5);
				 myBar->SetData(-2, 4.5);
				 myBar->SetData(-3, 7.5);
				 myBar->SetColor(GREEN);
				 myBar->SetDataLegend("data 3");
				 myBar->CloseDataSet();
			break;
		case 4 :
				 myBar->SetTickLimits(-4, 0, -10, 0);
				 myBar->SetTickStep(1,1);
				 myBar->EnableGridLines(TRUE);
				 myBar->SetXAxisLabel("X axis");
				 myBar->SetYAxisLabel("Y axis");

				 myBar->OpenDataSet();
				 myBar->SetData(-1, -2);
				 myBar->SetData(-2, -4);
				 myBar->SetData(-3, -6);
				 myBar->SetColor(RED);
				 myBar->SetDataLegend("data 1");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, -3);
				 myBar->SetData(-2, -6);
				 myBar->SetData(-3, -9);
				 myBar->SetColor(BLUE);
				 myBar->SetDataLegend("data 2");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, -1.5);
				 myBar->SetData(-2, -4.5);
				 myBar->SetData(-3, -7.5);
				 myBar->SetColor(GREEN);
				 myBar->SetDataLegend("data 3");
				 myBar->CloseDataSet();
			break;
		case 5 : 
				 myBar->SetTickLimits(-2, 2, 0, 10);
				 myBar->SetTickStep(1,1);
				 myBar->EnableGridLines(TRUE);
				 myBar->SetXAxisLabel("X axis");
				 myBar->SetYAxisLabel("Y axis");

				 myBar->OpenDataSet();
				 myBar->SetData(-1, 2);
				 myBar->SetData(-2, 4);
				 myBar->SetData(3, 6);
				 myBar->SetColor(RED);
				 myBar->SetDataLegend("data 1");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, 3);
				 myBar->SetData(-2, 6);
				 myBar->SetData(3, 9);
				 myBar->SetColor(BLUE);
				 myBar->SetDataLegend("data 2");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, 1.5);
				 myBar->SetData(-2, 4.5);
				 myBar->SetData(3, 7.5);
				 myBar->SetColor(GREEN);
				 myBar->SetDataLegend("data 3");
				 myBar->CloseDataSet();
			break;
		case 6 :
				 myBar->SetTickLimits(-2, 2, -10, 0);
				 myBar->SetTickStep(1,1);
				 myBar->EnableGridLines(TRUE);
				 myBar->SetXAxisLabel("X axis");
				 myBar->SetYAxisLabel("Y axis");

				 myBar->OpenDataSet();
				 myBar->SetData(-1, -2);
				 myBar->SetData(-2, -4);
				 myBar->SetData(3, -6);
				 myBar->SetColor(RED);
				 myBar->SetDataLegend("data 1");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, -3);
				 myBar->SetData(-2, -6);
				 myBar->SetData(3, -9);
				 myBar->SetColor(BLUE);
				 myBar->SetDataLegend("data 2");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, -1.5);
				 myBar->SetData(-2, -4.5);
				 myBar->SetData(3, -7.5);
				 myBar->SetColor(GREEN);
				 myBar->SetDataLegend("data 3");
				 myBar->CloseDataSet();
			break;
		case 7 :
				 myBar->SetTickLimits(0, 4, -10, 10);
				 myBar->SetTickStep(1,1);
				 myBar->EnableGridLines(TRUE);
				 myBar->SetXAxisLabel("X axis");
				 myBar->SetYAxisLabel("Y axis");

				 myBar->OpenDataSet();
				 myBar->SetData(1, -2);
				 myBar->SetData(2, -4);
				 myBar->SetData(3, 6);
				 myBar->SetColor(RED);
				 myBar->SetDataLegend("data 1");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(1, -3);
				 myBar->SetData(2, -6);
				 myBar->SetData(3, 9);
				 myBar->SetColor(BLUE);
				 myBar->SetDataLegend("data 2");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(1, -1.5);
				 myBar->SetData(2, -4.5);
				 myBar->SetData(3, 7.5);
				 myBar->SetColor(GREEN);
				 myBar->SetDataLegend("data 3");
				 myBar->CloseDataSet();
			break;
		case 8 :
				 myBar->SetTickLimits(-4, 0, -10, 10);
				 myBar->SetTickStep(1,1);
				 myBar->EnableGridLines(TRUE);
				 myBar->SetXAxisLabel("X axis");
				 myBar->SetYAxisLabel("Y axis");

				 myBar->OpenDataSet();
				 myBar->SetData(-1, -2);
				 myBar->SetData(-2, -4);
				 myBar->SetData(-3, 6);
				 myBar->SetColor(RED);
				 myBar->SetDataLegend("data 1");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, -3);
				 myBar->SetData(-2, -6);
				 myBar->SetData(-3, 9);
				 myBar->SetColor(BLUE);
				 myBar->SetDataLegend("data 2");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(-1, -1.5);
				 myBar->SetData(-2, -4.5);
				 myBar->SetData(-3, 7.5);
				 myBar->SetColor(GREEN);
				 myBar->SetDataLegend("data 3");
				 myBar->CloseDataSet();
			break;
		case 9 :
				 myBar->SetTickLimits(-2, 2, -10, 10);
				 myBar->SetTickStep(1,1);
				 myBar->EnableGridLines(TRUE);
				 myBar->SetXAxisLabel("X axis");
				 myBar->SetYAxisLabel("Y axis");

				 myBar->OpenDataSet();
				 myBar->SetData(1, -2);
				 myBar->SetData(2, -4);
				 myBar->SetData(3, 6);
				 myBar->SetColor(RED);
				 myBar->SetDataLegend("data 1");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(1, -3);
				 myBar->SetData(2, -6);
				 myBar->SetData(3, 9);
				 myBar->SetColor(BLUE);
				 myBar->SetDataLegend("data 2");
				 myBar->CloseDataSet();

				 myBar->OpenDataSet();
				 myBar->SetData(1, -1.5);
				 myBar->SetData(2, -4.5);
				 myBar->SetData(3, 7.5);
				 myBar->SetColor(GREEN);
				 myBar->SetDataLegend("data 3");
				 myBar->CloseDataSet();
			break;
		case 10 :	//	Andy's test
				SetTimer(0x1234, 50, NULL);	//	calculate data in a timer!

				myBar->SetTickLimits(0, 360, 0, 50);
				myBar->SetTickStep(20,3);
				myBar->EnableGridLines(TRUE);
				myBar->SetXAxisLabel("angle");
				myBar->SetYAxisLabel("intensity");

				//	only a filler to prevent 0x000000 err message
				//	the real data is initializated in WM_TIMER
				{
					myBar->OpenDataSet();
					myBar->SetDataLegend("phase 1");
					myBar->SetColor(RED);
					myBar->SetData(0,0);
					myBar->CloseDataSet();

					myBar->OpenDataSet();
					myBar->SetDataLegend("phase 2");
					myBar->SetColor(BLUE);
					myBar->SetData(0,0);
					myBar->CloseDataSet();

					myBar->OpenDataSet();
					myBar->SetDataLegend("phase 3");
					myBar->SetColor(GREEN);
					myBar->SetData(0,0);
					myBar->CloseDataSet();
				}
			break;
	}

	graphToDisplay = 1;
	okToDraw = TRUE;
	Invalidate(TRUE);
	
}

void CGraphDraw4View::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	int	nPos;		//where on page to start drawing the graph...
	nPos = -720;  // 1/2 inch top margin

	if(okToDraw)
	{
		switch(graphToDisplay)
		{
			case 1 :
					 myBar->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					 myBar->Print(pDC);
					 break;
			case 2 :
					 myXYLine->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					 myXYLine->Print(pDC);
					 break;
			case 3 :
					 myPie->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					 myPie->Print(pDC);
					 break;
			case 4 : 
					 myScatter->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					 myScatter->Print(pDC);
					 break;
			case 5 :
					 myBoxWhisker->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					 myBoxWhisker->Print(pDC);
					 break;
			case 6 :
					 myStackedBar->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					 myStackedBar->Print(pDC);
					 break;
			case 7 : 
					 my3DBar->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					 my3DBar->Print(pDC);
					 break;
			case 8 : 
					 my3DXYLine->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					 my3DXYLine->Print(pDC);
					 break;
			case 9 : 
					 my3DStackedBar->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					 my3DStackedBar->Print(pDC);
					 break;
			case 10 : 
					  my3DPie->SetPrintMargins(-720, -15120, 720, 10800, nPos); //portrait page
					  my3DPie->Print(pDC);
					  break;
		}

	}

//	CView::OnPrint(pDC, pInfo);
}


void CGraphDraw4View::OnDrawXyLine() 
{
	// TODO: Add your command handler code here
	// TODO: Add your command handler code here
	int testcase;	//for testing purposes only...
	CTestCaseDlg tc;

	tc.DoModal();
	testcase = tc.m_nTestCase;

	KillTimer(0x1234);
	if(myXYLine != NULL)
		delete myXYLine;
	myXYLine = new CXYLineGraph(FALSE);
	myXYLine->SetGraphTitle("Test XY Line Graph");
	myXYLine->SetLegendTitle("Legend");

	switch(testcase)
	{
		case 1 :
				 myXYLine->SetTickLimits(0, 4, 0, 10);
				 myXYLine->SetTickStep(1,1);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, 2);
				 myXYLine->SetData(2, 4);
				 myXYLine->SetData(3, 6);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, 3);
				 myXYLine->SetData(2, 6);
				 myXYLine->SetData(3, 9);
				 myXYLine->SetColor(BLUE);
				 myXYLine->SetDataLegend("data 2");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, 1.5);
				 myXYLine->SetData(2, 4.5);
				 myXYLine->SetData(3, 7.5);
				 myXYLine->SetColor(GREEN);
				 myXYLine->SetDataLegend("data 3");
				 myXYLine->CloseDataSet();
			break;
		case 2 :
				 myXYLine->SetTickLimits(0, 4, -10, 0);
				 myXYLine->SetTickStep(1,1);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, -2);
				 myXYLine->SetData(2, -4);
				 myXYLine->SetData(3, -6);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, -3);
				 myXYLine->SetData(2, -6);
				 myXYLine->SetData(3, -9);
				 myXYLine->SetColor(BLUE);
				 myXYLine->SetDataLegend("data 2");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, -1.5);
				 myXYLine->SetData(2, -4.5);
				 myXYLine->SetData(3, -7.5);
				 myXYLine->SetColor(GREEN);
				 myXYLine->SetDataLegend("data 3");
				 myXYLine->CloseDataSet();
			break;
		case 3 :
				 myXYLine->SetTickLimits(-4, 0, 0, 10);
				 myXYLine->SetTickStep(1,1);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, 2);
				 myXYLine->SetData(-2, 4);
				 myXYLine->SetData(-3, 6);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, 3);
				 myXYLine->SetData(-2, 6);
				 myXYLine->SetData(-3, 9);
				 myXYLine->SetColor(BLUE);
				 myXYLine->SetDataLegend("data 2");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, 1.5);
				 myXYLine->SetData(-2, 4.5);
				 myXYLine->SetData(-3, 7.5);
				 myXYLine->SetColor(GREEN);
				 myXYLine->SetDataLegend("data 3");
				 myXYLine->CloseDataSet();
			break;
		case 4 :
				 myXYLine->SetTickLimits(-4, 0, -10, 0);
				 myXYLine->SetTickStep(1,1);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -2);
				 myXYLine->SetData(-2, -4);
				 myXYLine->SetData(-3, -6);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -3);
				 myXYLine->SetData(-2, -6);
				 myXYLine->SetData(-3, -9);
				 myXYLine->SetColor(BLUE);
				 myXYLine->SetDataLegend("data 2");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -1.5);
				 myXYLine->SetData(-2, -4.5);
				 myXYLine->SetData(-3, -7.5);
				 myXYLine->SetColor(GREEN);
				 myXYLine->SetDataLegend("data 3");
				 myXYLine->CloseDataSet();
			break;
		case 5 : 
				 myXYLine->SetTickLimits(-2, 2, 0, 10);
				 myXYLine->SetTickStep(1,1);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, 2);
				 myXYLine->SetData(-2, 4);
				 myXYLine->SetData(1, 6);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, 3);
				 myXYLine->SetData(-2, 6);
				 myXYLine->SetData(2, 9);
				 myXYLine->SetColor(BLUE);
				 myXYLine->SetDataLegend("data 2");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, 1.5);
				 myXYLine->SetData(-2, 4.5);
				 myXYLine->SetData(1.5, 7.5);
				 myXYLine->SetColor(GREEN);
				 myXYLine->SetDataLegend("data 3");
				 myXYLine->CloseDataSet();
			break;
		case 6 :
				 myXYLine->SetTickLimits(-2, 2, -10, 0);
				 myXYLine->SetTickStep(1,1);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -2);
				 myXYLine->SetData(-2, -4);
				 myXYLine->SetData(1, -6);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -3);
				 myXYLine->SetData(-2, -6);
				 myXYLine->SetData(2, -9);
				 myXYLine->SetColor(BLUE);
				 myXYLine->SetDataLegend("data 2");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -1.5);
				 myXYLine->SetData(-2, -4.5);
				 myXYLine->SetData(1.5, -7.5);
				 myXYLine->SetColor(GREEN);
				 myXYLine->SetDataLegend("data 3");
				 myXYLine->CloseDataSet();
			break;
		case 7 :
				 myXYLine->SetTickLimits(0, 4, -10, 10);
				 myXYLine->SetTickStep(1,1);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, -2);
				 myXYLine->SetData(2, -4);
				 myXYLine->SetData(3, 6);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, -3);
				 myXYLine->SetData(2, -6);
				 myXYLine->SetData(3, 9);
				 myXYLine->SetColor(BLUE);
				 myXYLine->SetDataLegend("data 2");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, -1.5);
				 myXYLine->SetData(2, -4.5);
				 myXYLine->SetData(3, 7.5);
				 myXYLine->SetColor(GREEN);
				 myXYLine->SetDataLegend("data 3");
				 myXYLine->CloseDataSet();
			break;
		case 8 :
				 myXYLine->SetTickLimits(-4, 0, -10, 10);
				 myXYLine->SetTickStep(1,1);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -2);
				 myXYLine->SetData(-2, -4);
				 myXYLine->SetData(-3, 6);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -3);
				 myXYLine->SetData(-2, -6);
				 myXYLine->SetData(-3, 9);
				 myXYLine->SetColor(BLUE);
				 myXYLine->SetDataLegend("data 2");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -1.5);
				 myXYLine->SetData(-2, -4.5);
				 myXYLine->SetData(-3, 7.5);
				 myXYLine->SetColor(GREEN);
				 myXYLine->SetDataLegend("data 3");
				 myXYLine->CloseDataSet();
			break;
		case 9 :
				 myXYLine->SetTickLimits(-2, 2, -10, 10);
				 myXYLine->SetTickStep(1,1);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -2);
				 myXYLine->SetData(-2, -4);
				 myXYLine->SetData(1, 6);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -3);
				 myXYLine->SetData(-2, -6);
				 myXYLine->SetData(2, 9);
				 myXYLine->SetColor(BLUE);
				 myXYLine->SetDataLegend("data 2");
				 myXYLine->CloseDataSet();

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(-1, -1.5);
				 myXYLine->SetData(-2, -4.5);
				 myXYLine->SetData(1, 7.5);
				 myXYLine->SetColor(GREEN);
				 myXYLine->SetDataLegend("data 3");
				 myXYLine->CloseDataSet();
			break;
		case 10 :
				AfxMessageBox("Not implemented");
				 myXYLine->SetTickLimits(0, 100, -100, 100);
				 myXYLine->SetTickStep(10,10);
				 myXYLine->EnableGridLines(TRUE);
				 myXYLine->SetXAxisLabel("X axis");
				 myXYLine->SetYAxisLabel("Y axis");

				 myXYLine->OpenDataSet();
				 myXYLine->SetData(0, 0);
				 myXYLine->SetData(1, -100);
				 myXYLine->SetData(2, 100);
				 myXYLine->SetData(3, 100);
				 myXYLine->SetData(4, 100);
				 myXYLine->SetData(5, 100);
				 myXYLine->SetData(6, 100);
				 myXYLine->SetData(7, 100);
				 myXYLine->SetData(8, 100);
				 myXYLine->SetData(9, 100);
				 myXYLine->SetColor(RED);
				 myXYLine->SetDataLegend("data 1");
				 myXYLine->CloseDataSet();
			break;
	}

//	if(testcase != 10)
	{
		graphToDisplay = 2;
		okToDraw = TRUE;
		Invalidate(TRUE);
	}
}

BOOL CGraphDraw4View::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	if(okToDraw  &&  graphToDisplay)
		return TRUE;
		
	return CView::OnEraseBkgnd(pDC);
}

void CGraphDraw4View::OnTimer(UINT nIDEvent) 
{
	if(nIDEvent == 0x1234  &&  myBar  &&  okToDraw)
	{
		if (graphToDisplay == 1)
		{
			static int nPhase = 0;

			myBar->RemoveAllData();

			myBar->OpenDataSet();
			myBar->SetDataLegend("phase 1");
			myBar->SetColor(RED);

			for(int x=0; x<360; x+=20)
			{
				myBar->SetData(
					x,
					15.0 * sin( (double)(x + nPhase) * 3.14 / 180.0) + 25);
			}

			myBar->CloseDataSet();

			myBar->OpenDataSet();
			myBar->SetDataLegend("phase 2");
			myBar->SetColor(BLUE);

			for(x=0; x<360; x+=20)
			{
				myBar->SetData(
					x,
					20.0 * sin( (double)(x * 2 + nPhase + 10) * 3.14 / 180.0) + 25);
			}

			myBar->CloseDataSet();

			myBar->OpenDataSet();
			myBar->SetDataLegend("phase 3");
			myBar->SetColor(GREEN);

			for(x=0; x<360; x+=20)
			{
				myBar->SetData(
					x,
					18.0 * sin( (double)(x * 3 + nPhase + 30) * 3.14 / 180.0) + 25);
			}

			myBar->CloseDataSet();

			nPhase ++;
			if (nPhase == 360)
				nPhase  = 0;

			InvalidateRect(NULL,FALSE);
		}
	}
		
	CView::OnTimer(nIDEvent);
}

void CGraphDraw4View::OnAppExit() 
{
	// TODO: Add your command handler code here
	KillTimer(0x1234);
}

void CGraphDraw4View::OnDrawScatter() 
{
	// TODO: Add your command handler code here
	int testcase;	//for testing purposes only...
	CTestCaseDlg tc;

	tc.DoModal();
	testcase = tc.m_nTestCase;

	if(testcase > 9)
		AfxMessageBox("Only 1 - 9 implemented for scatter graphs");

	KillTimer(0x1234);
	if(myScatter != NULL)
		delete myScatter;
	myScatter = new CScatterGraph(FALSE);
	myScatter->SetGraphTitle("Test Scatter Graph");
	myScatter->SetLegendTitle("Legend");
	myScatter->EnableGridLines(TRUE);
//	myScatter->EnableDoubleBuffering(TRUE);

	switch(testcase)
	{
		case 1 :
				 myScatter->SetTickLimits(0, 10, 0, 10);
				 myScatter->SetTickStep(1,1);
				 myScatter->EnableGridLines(TRUE);
				 myScatter->SetXAxisLabel("X axis");
				 myScatter->SetYAxisLabel("Y axis");

				 myScatter->OpenDataSet();
				 myScatter->SetData(1, 2);
				 myScatter->SetData(2, 4);
				 myScatter->SetData(3, 6);
				 myScatter->SetData(1.5, 2);
				 myScatter->SetData(7, 4.5);
				 myScatter->SetData(4, 9);
				 myScatter->SetData(9, 3);
				 myScatter->SetData(9.5, 5);
				 myScatter->SetData(3.2, 2.8);
				 myScatter->SetData(1.1, 9.3);
				 myScatter->SetData(0.2, 4);
				 myScatter->SetData(6, 6.6);
				 myScatter->SetColor(BLACK);
				 myScatter->SetDataLegend("data 1");
				 myScatter->CloseDataSet();
			break;
		case 2 :
				 myScatter->SetTickLimits(0, 10, -10, 0);
				 myScatter->SetTickStep(1,1);
				 myScatter->EnableGridLines(TRUE);
				 myScatter->SetXAxisLabel("X axis");
				 myScatter->SetYAxisLabel("Y axis");

				 myScatter->OpenDataSet();
				 myScatter->SetData(1, -2);
				 myScatter->SetData(2, -4);
				 myScatter->SetData(3, -6);
				 myScatter->SetData(1.5, -2);
				 myScatter->SetData(7, -4.5);
				 myScatter->SetData(4, -9);
				 myScatter->SetData(9, -3);
				 myScatter->SetData(9.5, -5);
				 myScatter->SetData(3.2, -2.8);
				 myScatter->SetData(1.1, -9.3);
				 myScatter->SetData(0.2, -4);
				 myScatter->SetData(6, -6.6);
				 myScatter->SetColor(BLACK);
				 myScatter->SetDataLegend("data 1");
				 myScatter->CloseDataSet();
			break;
		case 3 :
				 myScatter->SetTickLimits(-10, 0, 0, 10);
				 myScatter->SetTickStep(1,1);
				 myScatter->EnableGridLines(TRUE);
				 myScatter->SetXAxisLabel("X axis");
				 myScatter->SetYAxisLabel("Y axis");

				 myScatter->OpenDataSet();
				 myScatter->SetData(-1, 2);
				 myScatter->SetData(-2, 4);
				 myScatter->SetData(-3, 6);
				 myScatter->SetData(-1.5, 2);
				 myScatter->SetData(-7, 4.5);
				 myScatter->SetData(-4, 9);
				 myScatter->SetData(-9, 3);
				 myScatter->SetData(-9.5, 5);
				 myScatter->SetData(-3.2, 2.8);
				 myScatter->SetData(-1.1, 9.3);
				 myScatter->SetData(-0.2, 4);
				 myScatter->SetData(-6, 6.6);
				 myScatter->SetColor(BLACK);
				 myScatter->SetDataLegend("data 1");
				 myScatter->CloseDataSet();
			break;
		case 4 :
				 myScatter->SetTickLimits(-10, 0, -10, 0);
				 myScatter->SetTickStep(1,1);
				 myScatter->EnableGridLines(TRUE);
				 myScatter->SetXAxisLabel("X axis");
				 myScatter->SetYAxisLabel("Y axis");

				 myScatter->OpenDataSet();
				 myScatter->SetData(-1, -2);
				 myScatter->SetData(-2, -4);
				 myScatter->SetData(-3, -6);
				 myScatter->SetData(-1.5, -2);
				 myScatter->SetData(-7, -4.5);
				 myScatter->SetData(-4, -9);
				 myScatter->SetData(-9, -3);
				 myScatter->SetData(-9.5, -5);
				 myScatter->SetData(-3.2, -2.8);
				 myScatter->SetData(-1.1, -9.3);
				 myScatter->SetData(-0.2, -4);
				 myScatter->SetData(-6, -6.6);
				 myScatter->SetColor(BLACK);
				 myScatter->SetDataLegend("data 1");
				 myScatter->CloseDataSet();
			break;
		case 5 : 
				 myScatter->SetTickLimits(-10, 10, 0, 10);
				 myScatter->SetTickStep(1,1);
				 myScatter->EnableGridLines(TRUE);
				 myScatter->SetXAxisLabel("X axis");
				 myScatter->SetYAxisLabel("Y axis");

				 myScatter->OpenDataSet();
				 myScatter->SetData(1, 2);
				 myScatter->SetData(-2, 4);
				 myScatter->SetData(3, 6);
				 myScatter->SetData(1.5, 2);
				 myScatter->SetData(-7, 4.5);
				 myScatter->SetData(4, 9);
				 myScatter->SetData(-9, 3);
				 myScatter->SetData(9.5, 5);
				 myScatter->SetData(-3.2, 2.8);
				 myScatter->SetData(-1.1, 9.3);
				 myScatter->SetData(0.2, 4);
				 myScatter->SetData(6, 6.6);
				 myScatter->SetColor(BLACK);
				 myScatter->SetDataLegend("data 1");
				 myScatter->CloseDataSet();
			break;
		case 6 :
				 myScatter->SetTickLimits(-10, 10, -10, 0);
				 myScatter->SetTickStep(1,1);
				 myScatter->EnableGridLines(TRUE);
				 myScatter->SetXAxisLabel("X axis");
				 myScatter->SetYAxisLabel("Y axis");

				 myScatter->OpenDataSet();
				 myScatter->SetData(1, -2);
				 myScatter->SetData(2, -4);
				 myScatter->SetData(3, -6);
				 myScatter->SetData(1.5, -2);
				 myScatter->SetData(-7, -4.5);
				 myScatter->SetData(4, -9);
				 myScatter->SetData(9, -3);
				 myScatter->SetData(-9.5, -5);
				 myScatter->SetData(3.2, -2.8);
				 myScatter->SetData(-1.1, -9.3);
				 myScatter->SetData(0.2, -4);
				 myScatter->SetData(6, -6.6);
				 myScatter->SetColor(BLACK);
				 myScatter->SetDataLegend("data 1");
				 myScatter->CloseDataSet();
			break;
		case 7 :
				 myScatter->SetTickLimits(0, 10, -10, 10);
				 myScatter->SetTickStep(1,1);
				 myScatter->EnableGridLines(TRUE);
				 myScatter->SetXAxisLabel("X axis");
				 myScatter->SetYAxisLabel("Y axis");

				 myScatter->OpenDataSet();
				 myScatter->SetData(1, 2);
				 myScatter->SetData(2, -4);
				 myScatter->SetData(3, 6);
				 myScatter->SetData(1.5, -2);
				 myScatter->SetData(7, 4.5);
				 myScatter->SetData(4, -9);
				 myScatter->SetData(9, -3);
				 myScatter->SetData(9.5, 5);
				 myScatter->SetData(3.2, 2.8);
				 myScatter->SetData(1.1, -9.3);
				 myScatter->SetData(0.2, 4);
				 myScatter->SetData(6, 6.6);
				 myScatter->SetColor(BLACK);
				 myScatter->SetDataLegend("data 1");
				 myScatter->CloseDataSet();
			break;
		case 8 :
				 myScatter->SetTickLimits(-10, 0, -10, 10);
				 myScatter->SetTickStep(1,1);
				 myScatter->EnableGridLines(TRUE);
				 myScatter->SetXAxisLabel("X axis");
				 myScatter->SetYAxisLabel("Y axis");

				 myScatter->OpenDataSet();
				 myScatter->SetData(-1, -2);
				 myScatter->SetData(-2, 4);
				 myScatter->SetData(-3, 6);
				 myScatter->SetData(-1.5, 2);
				 myScatter->SetData(-7, 4.5);
				 myScatter->SetData(-4, -9);
				 myScatter->SetData(-9, 3);
				 myScatter->SetData(-9.5, 5);
				 myScatter->SetData(-3.2, 2.8);
				 myScatter->SetData(-1.1, 9.3);
				 myScatter->SetData(-0.2, -4);
				 myScatter->SetData(-6, 6.6);
				 myScatter->SetColor(BLACK);
				 myScatter->SetDataLegend("data 1");
				 myScatter->CloseDataSet();
			break;
		case 9 :
				 myScatter->SetTickLimits(-10, 10, -10, 10);
				 myScatter->SetTickStep(1,1);
				 myScatter->EnableGridLines(TRUE);
				 myScatter->SetXAxisLabel("X axis");
				 myScatter->SetYAxisLabel("Y axis");

				 myScatter->OpenDataSet();
				 myScatter->SetData(1, 2);
				 myScatter->SetData(-2, 4);
				 myScatter->SetData(3, -6);
				 myScatter->SetData(1.5, 2);
				 myScatter->SetData(-7, 4.5);
				 myScatter->SetData(4, 9);
				 myScatter->SetData(-9, -3);
				 myScatter->SetData(9.5, 5);
				 myScatter->SetData(3.2, 2.8);
				 myScatter->SetData(1.1, 9.3);
				 myScatter->SetData(-0.2, 4);
				 myScatter->SetData(6, -6.6);
				 myScatter->SetColor(BLACK);
				 myScatter->SetDataLegend("data 1");
				 myScatter->CloseDataSet();
			break;
	}

	graphToDisplay = 4;
	okToDraw = TRUE;
	Invalidate(TRUE);
	
}

void CGraphDraw4View::OnDrawWhisker() 
{
	// TODO: Add your command handler code here
	int testcase;	//for testing purposes only...
	CTestCaseDlg tc;

	tc.DoModal();
	testcase = tc.m_nTestCase;

	if(testcase > 1)
		AfxMessageBox("Only 1 implemented for box-whisker graphs");

	KillTimer(0x1234);
	if(myBoxWhisker != NULL)
		delete myBoxWhisker;
	myBoxWhisker = new CBoxWhiskerGraph();
	myBoxWhisker->SetGraphTitle("Test Box-Whisker Graph");
	myBoxWhisker->SetLegendTitle("Legend");
	myBoxWhisker->EnableGridLines(TRUE);
//	myBoxWhisker->EnableDoubleBuffering(TRUE);

	switch(testcase)
	{
		case 1 :
				 myBoxWhisker->SetTickLimits(0, 2, 0, 10);
				 myBoxWhisker->SetTickStep(1,1);
				 myBoxWhisker->EnableGridLines(TRUE);
				 myBoxWhisker->SetXAxisLabel("X axis");
				 myBoxWhisker->SetYAxisLabel("Y axis");

				 myBoxWhisker->OpenDataSet();
				 myBoxWhisker->SetData(1, 2);
				 myBoxWhisker->SetData(2, 4);
				 myBoxWhisker->SetData(3, 6);
				 myBoxWhisker->SetData(4, 2);
				 myBoxWhisker->SetData(5, 4);
				 myBoxWhisker->SetData(6, 9);
				 myBoxWhisker->SetData(7, 1);
				 myBoxWhisker->SetData(8, 5);
				 myBoxWhisker->SetData(9, 8);
				 myBoxWhisker->SetData(10, 3);
				 myBoxWhisker->SetData(11, 4);
				 myBoxWhisker->SetData(12, 6);
				 myBoxWhisker->SetColor(BLACK);
				 myBoxWhisker->SetDataLegend("data 1");
				 myBoxWhisker->CloseDataSet();
			break;
	}

	if(testcase == 1)
	{
		graphToDisplay = 5;
		okToDraw = TRUE;
		Invalidate(TRUE);
	}
}


void CGraphDraw4View::OnDrawStackedBar()
{
	// TODO: Add your command handler code here
	int testcase;	//for testing purposes only...
	CTestCaseDlg tc;

	tc.DoModal();
	testcase = tc.m_nTestCase;

	KillTimer(0x1234);
	if(myStackedBar != NULL)
		delete myStackedBar;
	myStackedBar = new CStackedBarGraph(FALSE);
	myStackedBar->SetGraphTitle("Test Stacked Bar Graph");
	myStackedBar->SetLegendTitle("Legend");
	myStackedBar->EnableGridLines(TRUE);
//	myStackedBar->EnableDoubleBuffering(TRUE);

	switch(testcase)
	{
		case 1 :
				 myStackedBar->SetTickLimits(0, 4, 0, 30);
				 myStackedBar->SetTickStep(1,5);
				 myStackedBar->EnableGridLines(TRUE);
				 myStackedBar->SetXAxisLabel("X axis");
				 myStackedBar->SetYAxisLabel("Y axis");

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(1, 2);
				 myStackedBar->SetData(2, 4);
				 myStackedBar->SetData(3, 6);
				 myStackedBar->SetColor(RED);
				 myStackedBar->SetDataLegend("data 1");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(1, 3);
				 myStackedBar->SetData(2, 6);
				 myStackedBar->SetData(3, 9);
				 myStackedBar->SetColor(BLUE);
				 myStackedBar->SetDataLegend("data 2");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(1, 1.5);
				 myStackedBar->SetData(2, 4.5);
				 myStackedBar->SetData(3, 7.5);
				 myStackedBar->SetColor(GREEN);
				 myStackedBar->SetDataLegend("data 3");
				 myStackedBar->CloseDataSet();
			break;
		case 2 :
				 myStackedBar->SetTickLimits(0, 4, -30, 0);
				 myStackedBar->SetTickStep(1,5);
				 myStackedBar->EnableGridLines(TRUE);
				 myStackedBar->SetXAxisLabel("X axis");
				 myStackedBar->SetYAxisLabel("Y axis");

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(1, -2);
				 myStackedBar->SetData(2, -4);
				 myStackedBar->SetData(3, -6);
				 myStackedBar->SetColor(RED);
				 myStackedBar->SetDataLegend("data 1");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(1, -3);
				 myStackedBar->SetData(2, -6);
				 myStackedBar->SetData(3, -9);
				 myStackedBar->SetColor(BLUE);
				 myStackedBar->SetDataLegend("data 2");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(1, -1.5);
				 myStackedBar->SetData(2, -4.5);
				 myStackedBar->SetData(3, -7.5);
				 myStackedBar->SetColor(GREEN);
				 myStackedBar->SetDataLegend("data 3");
				 myStackedBar->CloseDataSet();
			break;
		case 3 :
				 myStackedBar->SetTickLimits(-4, 0, 0, 30);
				 myStackedBar->SetTickStep(1,5);
				 myStackedBar->EnableGridLines(TRUE);
				 myStackedBar->SetXAxisLabel("X axis");
				 myStackedBar->SetYAxisLabel("Y axis");

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, 2);
				 myStackedBar->SetData(-2, 4);
				 myStackedBar->SetData(-3, 6);
				 myStackedBar->SetColor(RED);
				 myStackedBar->SetDataLegend("data 1");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, 3);
				 myStackedBar->SetData(-2, 6);
				 myStackedBar->SetData(-3, 9);
				 myStackedBar->SetColor(BLUE);
				 myStackedBar->SetDataLegend("data 2");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, 1.5);
				 myStackedBar->SetData(-2, 4.5);
				 myStackedBar->SetData(-3, 7.5);
				 myStackedBar->SetColor(GREEN);
				 myStackedBar->SetDataLegend("data 3");
				 myStackedBar->CloseDataSet();
			break;
		case 4 :
				 myStackedBar->SetTickLimits(-4, 0, -30, 0);
				 myStackedBar->SetTickStep(1,5);
				 myStackedBar->EnableGridLines(TRUE);
				 myStackedBar->SetXAxisLabel("X axis");
				 myStackedBar->SetYAxisLabel("Y axis");

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -2);
				 myStackedBar->SetData(-2, -4);
				 myStackedBar->SetData(-3, -6);
				 myStackedBar->SetColor(RED);
				 myStackedBar->SetDataLegend("data 1");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -3);
				 myStackedBar->SetData(-2, -6);
				 myStackedBar->SetData(-3, -9);
				 myStackedBar->SetColor(BLUE);
				 myStackedBar->SetDataLegend("data 2");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -1.5);
				 myStackedBar->SetData(-2, -4.5);
				 myStackedBar->SetData(-3, -7.5);
				 myStackedBar->SetColor(GREEN);
				 myStackedBar->SetDataLegend("data 3");
				 myStackedBar->CloseDataSet();
			break;
		case 5 : 
				 myStackedBar->SetTickLimits(-2, 2, 0, 30);
				 myStackedBar->SetTickStep(1,5);
				 myStackedBar->EnableGridLines(TRUE);
				 myStackedBar->SetXAxisLabel("X axis");
				 myStackedBar->SetYAxisLabel("Y axis");

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, 2);
				 myStackedBar->SetData(-2, 4);
				 myStackedBar->SetData(3, 6);
				 myStackedBar->SetColor(RED);
				 myStackedBar->SetDataLegend("data 1");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, 3);
				 myStackedBar->SetData(-2, 6);
				 myStackedBar->SetData(3, 9);
				 myStackedBar->SetColor(BLUE);
				 myStackedBar->SetDataLegend("data 2");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, 1.5);
				 myStackedBar->SetData(-2, 4.5);
				 myStackedBar->SetData(3, 7.5);
				 myStackedBar->SetColor(GREEN);
				 myStackedBar->SetDataLegend("data 3");
				 myStackedBar->CloseDataSet();
			break;
		case 6 :
				 myStackedBar->SetTickLimits(-2, 2, -30, 0);
				 myStackedBar->SetTickStep(1,5);
				 myStackedBar->EnableGridLines(TRUE);
				 myStackedBar->SetXAxisLabel("X axis");
				 myStackedBar->SetYAxisLabel("Y axis");

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -2);
				 myStackedBar->SetData(-2, -4);
				 myStackedBar->SetData(3, -6);
				 myStackedBar->SetColor(RED);
				 myStackedBar->SetDataLegend("data 1");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -3);
				 myStackedBar->SetData(-2, -6);
				 myStackedBar->SetData(3, -9);
				 myStackedBar->SetColor(BLUE);
				 myStackedBar->SetDataLegend("data 2");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -1.5);
				 myStackedBar->SetData(-2, -4.5);
				 myStackedBar->SetData(3, -7.5);
				 myStackedBar->SetColor(GREEN);
				 myStackedBar->SetDataLegend("data 3");
				 myStackedBar->CloseDataSet();
			break;
		case 7 :
				 myStackedBar->SetTickLimits(0, 4, -30, 30);
				 myStackedBar->SetTickStep(1,5);
				 myStackedBar->EnableGridLines(TRUE);
				 myStackedBar->SetXAxisLabel("X axis");
				 myStackedBar->SetYAxisLabel("Y axis");

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(1, -2);
				 myStackedBar->SetData(2, -4);
				 myStackedBar->SetData(3, 6);
				 myStackedBar->SetColor(RED);
				 myStackedBar->SetDataLegend("data 1");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(1, -3);
				 myStackedBar->SetData(2, -6);
				 myStackedBar->SetData(3, 9);
				 myStackedBar->SetColor(BLUE);
				 myStackedBar->SetDataLegend("data 2");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(1, -1.5);
				 myStackedBar->SetData(2, -4.5);
				 myStackedBar->SetData(3, 7.5);
				 myStackedBar->SetColor(GREEN);
				 myStackedBar->SetDataLegend("data 3");
				 myStackedBar->CloseDataSet();
			break;
		case 8 :
				 myStackedBar->SetTickLimits(-4, 0, -30, 30);
				 myStackedBar->SetTickStep(1,5);
				 myStackedBar->EnableGridLines(TRUE);
				 myStackedBar->SetXAxisLabel("X axis");
				 myStackedBar->SetYAxisLabel("Y axis");

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -2);
				 myStackedBar->SetData(-2, -4);
				 myStackedBar->SetData(-3, 6);
				 myStackedBar->SetColor(RED);
				 myStackedBar->SetDataLegend("data 1");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -3);
				 myStackedBar->SetData(-2, -6);
				 myStackedBar->SetData(-3, 9);
				 myStackedBar->SetColor(BLUE);
				 myStackedBar->SetDataLegend("data 2");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -1.5);
				 myStackedBar->SetData(-2, -4.5);
				 myStackedBar->SetData(-3, 7.5);
				 myStackedBar->SetColor(GREEN);
				 myStackedBar->SetDataLegend("data 3");
				 myStackedBar->CloseDataSet();
			break;
		case 9 :
				 myStackedBar->SetTickLimits(-2, 2, -30, 30);
				 myStackedBar->SetTickStep(1,5);
				 myStackedBar->EnableGridLines(TRUE);
				 myStackedBar->SetXAxisLabel("X axis");
				 myStackedBar->SetYAxisLabel("Y axis");

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -2);
				 myStackedBar->SetData(0, -4);
				 myStackedBar->SetData(1, 6);
				 myStackedBar->SetColor(RED);
				 myStackedBar->SetDataLegend("data 1");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -3);
				 myStackedBar->SetData(0, -6);
				 myStackedBar->SetData(1, 9);
				 myStackedBar->SetColor(BLUE);
				 myStackedBar->SetDataLegend("data 2");
				 myStackedBar->CloseDataSet();

				 myStackedBar->OpenDataSet();
				 myStackedBar->SetData(-1, -1.5);
				 myStackedBar->SetData(0, -4.5);
				 myStackedBar->SetData(1, 7.5);
				 myStackedBar->SetColor(GREEN);
				 myStackedBar->SetDataLegend("data 3");
				 myStackedBar->CloseDataSet();
			break;
	}
	graphToDisplay = 6;
	okToDraw = TRUE;
	Invalidate(TRUE);
}


void CGraphDraw4View::OnDrawPie()
{
	// TODO: Add your command handler code here
	KillTimer(0x1234);
	if(myPie != NULL)
		delete myPie;
	myPie = new CPieGraph(FALSE);
	myPie->SetGraphTitle("Test Pie Graph");
	myPie->SetLegendTitle("Legend");
	myPie->EnableGridLines(TRUE);
	myPie->DisplayLabels(TRUE);

	myPie->OpenDataSet();
	myPie->SetData(1, 2);
	myPie->SetData(2, 4);
	myPie->SetData(3, 6);
	myPie->SetColor(1, RED);
	myPie->SetColor(2, BLUE);
	myPie->SetColor(3, GREEN);
	myPie->SetLegendText(1, "data 1");
	myPie->SetLegendText(2, "data 2");
	myPie->SetLegendText(3, "data 3");
	myPie->CloseDataSet();

	graphToDisplay = 3;
	okToDraw = TRUE;
	Invalidate(TRUE);
}

void CGraphDraw4View::OnDraw3DBar() 
{
	// TODO: Add your command handler code here
	int testcase;	//for testing purposes only...
	CTestCaseDlg tc;

	tc.DoModal();
	testcase = tc.m_nTestCase;

	KillTimer(0x1234);
	if(my3DBar != NULL)
		delete my3DBar;
	my3DBar = new CBarGraph(TRUE);
	my3DBar->SetGraphTitle("Test Bar Graph");
	my3DBar->SetLegendTitle("Legend");
	my3DBar->EnableGridLines(TRUE);
	my3DBar->SetXAxisLabel("Day-by-Day Comparison");
	my3DBar->SetYAxisLabel("PH Level");
	my3DBar->EnableDoubleBuffering(TRUE);

	switch(testcase)
	{
		case 1 :
				 my3DBar->SetTickLimits(0, 4, 0, 10);
				 my3DBar->SetTickStep(1,1);
				 my3DBar->EnableGridLines(TRUE);
				 my3DBar->SetXAxisLabel("X axis");
				 my3DBar->SetYAxisLabel("Y axis");

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(1, 2);
				 my3DBar->SetData(2, 4);
				 my3DBar->SetData(3, 6);
				 my3DBar->SetColor(RED);
				 my3DBar->SetDataLegend("data 1");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(1, 3);
				 my3DBar->SetData(2, 6);
				 my3DBar->SetData(3, 9);
				 my3DBar->SetColor(BLUE);
				 my3DBar->SetDataLegend("data 2");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(1, 1.5);
				 my3DBar->SetData(2, 4.5);
				 my3DBar->SetData(3, 7.5);
				 my3DBar->SetColor(GREEN);
				 my3DBar->SetDataLegend("data 3");
				 my3DBar->CloseDataSet();
			break;
		case 2 :
				 my3DBar->SetTickLimits(0, 4, -10, 0);
				 my3DBar->SetTickStep(1,1);
				 my3DBar->EnableGridLines(TRUE);
				 my3DBar->SetXAxisLabel("X axis");
				 my3DBar->SetYAxisLabel("Y axis");

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(1, -2);
				 my3DBar->SetData(2, -4);
				 my3DBar->SetData(3, -6);
				 my3DBar->SetColor(RED);
				 my3DBar->SetDataLegend("data 1");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(1, -3);
				 my3DBar->SetData(2, -6);
				 my3DBar->SetData(3, -9);
				 my3DBar->SetColor(BLUE);
				 my3DBar->SetDataLegend("data 2");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(1, -1.5);
				 my3DBar->SetData(2, -4.5);
				 my3DBar->SetData(3, -7.5);
				 my3DBar->SetColor(GREEN);
				 my3DBar->SetDataLegend("data 3");
				 my3DBar->CloseDataSet();
			break;
		case 3 :
				 my3DBar->SetTickLimits(-4, 0, 0, 10);
				 my3DBar->SetTickStep(1,1);
				 my3DBar->EnableGridLines(TRUE);
				 my3DBar->SetXAxisLabel("X axis");
				 my3DBar->SetYAxisLabel("Y axis");

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, 2);
				 my3DBar->SetData(-2, 4);
				 my3DBar->SetData(-3, 6);
				 my3DBar->SetColor(RED);
				 my3DBar->SetDataLegend("data 1");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, 3);
				 my3DBar->SetData(-2, 6);
				 my3DBar->SetData(-3, 9);
				 my3DBar->SetColor(BLUE);
				 my3DBar->SetDataLegend("data 2");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, 1.5);
				 my3DBar->SetData(-2, 4.5);
				 my3DBar->SetData(-3, 7.5);
				 my3DBar->SetColor(GREEN);
				 my3DBar->SetDataLegend("data 3");
				 my3DBar->CloseDataSet();
			break;
		case 4 :
				 my3DBar->SetTickLimits(-4, 0, -10, 0);
				 my3DBar->SetTickStep(1,1);
				 my3DBar->EnableGridLines(TRUE);
				 my3DBar->SetXAxisLabel("X axis");
				 my3DBar->SetYAxisLabel("Y axis");

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -2);
				 my3DBar->SetData(-2, -4);
				 my3DBar->SetData(-3, -6);
				 my3DBar->SetColor(RED);
				 my3DBar->SetDataLegend("data 1");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -3);
				 my3DBar->SetData(-2, -6);
				 my3DBar->SetData(-3, -9);
				 my3DBar->SetColor(BLUE);
				 my3DBar->SetDataLegend("data 2");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -1.5);
				 my3DBar->SetData(-2, -4.5);
				 my3DBar->SetData(-3, -7.5);
				 my3DBar->SetColor(GREEN);
				 my3DBar->SetDataLegend("data 3");
				 my3DBar->CloseDataSet();
			break;
		case 5 : 
				 my3DBar->SetTickLimits(-2, 2, 0, 10);
				 my3DBar->SetTickStep(1,1);
				 my3DBar->EnableGridLines(TRUE);
				 my3DBar->SetXAxisLabel("X axis");
				 my3DBar->SetYAxisLabel("Y axis");

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, 2);
				 my3DBar->SetData(-2, 4);
				 my3DBar->SetData(3, 6);
				 my3DBar->SetColor(RED);
				 my3DBar->SetDataLegend("data 1");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, 3);
				 my3DBar->SetData(-2, 6);
				 my3DBar->SetData(3, 9);
				 my3DBar->SetColor(BLUE);
				 my3DBar->SetDataLegend("data 2");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, 1.5);
				 my3DBar->SetData(-2, 4.5);
				 my3DBar->SetData(3, 7.5);
				 my3DBar->SetColor(GREEN);
				 my3DBar->SetDataLegend("data 3");
				 my3DBar->CloseDataSet();
			break;
		case 6 :
				 my3DBar->SetTickLimits(-2, 2, -10, 0);
				 my3DBar->SetTickStep(1,1);
				 my3DBar->EnableGridLines(TRUE);
				 my3DBar->SetXAxisLabel("X axis");
				 my3DBar->SetYAxisLabel("Y axis");

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -2);
				 my3DBar->SetData(-2, -4);
				 my3DBar->SetData(3, -6);
				 my3DBar->SetColor(RED);
				 my3DBar->SetDataLegend("data 1");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -3);
				 my3DBar->SetData(-2, -6);
				 my3DBar->SetData(3, -9);
				 my3DBar->SetColor(BLUE);
				 my3DBar->SetDataLegend("data 2");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -1.5);
				 my3DBar->SetData(-2, -4.5);
				 my3DBar->SetData(3, -7.5);
				 my3DBar->SetColor(GREEN);
				 my3DBar->SetDataLegend("data 3");
				 my3DBar->CloseDataSet();
			break;
		case 7 :
				 my3DBar->SetTickLimits(0, 4, -10, 10);
				 my3DBar->SetTickStep(1,1);
				 my3DBar->EnableGridLines(TRUE);
				 my3DBar->SetXAxisLabel("X axis");
				 my3DBar->SetYAxisLabel("Y axis");

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(1, -2);
				 my3DBar->SetData(2, -4);
				 my3DBar->SetData(3, 6);
				 my3DBar->SetColor(RED);
				 my3DBar->SetDataLegend("data 1");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(1, -3);
				 my3DBar->SetData(2, -6);
				 my3DBar->SetData(3, 9);
				 my3DBar->SetColor(BLUE);
				 my3DBar->SetDataLegend("data 2");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(1, -1.5);
				 my3DBar->SetData(2, -4.5);
				 my3DBar->SetData(3, 7.5);
				 my3DBar->SetColor(GREEN);
				 my3DBar->SetDataLegend("data 3");
				 my3DBar->CloseDataSet();
			break;
		case 8 :
				 my3DBar->SetTickLimits(-4, 0, -10, 10);
				 my3DBar->SetTickStep(1,1);
				 my3DBar->EnableGridLines(TRUE);
				 my3DBar->SetXAxisLabel("X axis");
				 my3DBar->SetYAxisLabel("Y axis");

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -2);
				 my3DBar->SetData(-2, -4);
				 my3DBar->SetData(-3, 6);
				 my3DBar->SetColor(RED);
				 my3DBar->SetDataLegend("data 1");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -3);
				 my3DBar->SetData(-2, -6);
				 my3DBar->SetData(-3, 9);
				 my3DBar->SetColor(BLUE);
				 my3DBar->SetDataLegend("data 2");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -1.5);
				 my3DBar->SetData(-2, -4.5);
				 my3DBar->SetData(-3, 7.5);
				 my3DBar->SetColor(GREEN);
				 my3DBar->SetDataLegend("data 3");
				 my3DBar->CloseDataSet();
			break;
		case 9 :
				 my3DBar->SetTickLimits(-2, 2, -10, 10);
				 my3DBar->SetTickStep(1,1);
				 my3DBar->EnableGridLines(TRUE);
				 my3DBar->SetXAxisLabel("X axis");
				 my3DBar->SetYAxisLabel("Y axis");

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -2);
				 my3DBar->SetData(-2, -4);
				 my3DBar->SetData(3, 6);
				 my3DBar->SetColor(RED);
				 my3DBar->SetDataLegend("data 1");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -3);
				 my3DBar->SetData(-2, -6);
				 my3DBar->SetData(3, 9);
				 my3DBar->SetColor(BLUE);
				 my3DBar->SetDataLegend("data 2");
				 my3DBar->CloseDataSet();

				 my3DBar->OpenDataSet();
				 my3DBar->SetData(-1, -1.5);
				 my3DBar->SetData(-2, -4.5);
				 my3DBar->SetData(3, 7.5);
				 my3DBar->SetColor(GREEN);
				 my3DBar->SetDataLegend("data 3");
				 my3DBar->CloseDataSet();
			break;
	}

	graphToDisplay = 7;
	okToDraw = TRUE;
	Invalidate(TRUE);
	
}

void CGraphDraw4View::OnDraw3DXyLine() 
{
	// TODO: Add your command handler code here
	// TODO: Add your command handler code here
	int testcase;	//for testing purposes only...
	CTestCaseDlg tc;

	tc.DoModal();
	testcase = tc.m_nTestCase;

	KillTimer(0x1234);
	if(my3DXYLine != NULL)
		delete my3DXYLine;
	my3DXYLine = new CXYLineGraph(TRUE);
	my3DXYLine->SetGraphTitle("Test 3D XY Line Graph");
	my3DXYLine->SetLegendTitle("Legend");

	switch(testcase)
	{
		case 1 :
				 my3DXYLine->SetTickLimits(0, 4, 0, 10);
				 my3DXYLine->SetTickStep(1,1);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, 1);
				 my3DXYLine->SetData(2, 5);
				 my3DXYLine->SetData(3, 4);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();

				 /*
				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, 3);
				 my3DXYLine->SetData(2, 6);
				 my3DXYLine->SetData(3, 9);
				 my3DXYLine->SetColor(BLUE);
				 my3DXYLine->SetDataLegend("data 2");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, 1.5);
				 my3DXYLine->SetData(2, 4.5);
				 my3DXYLine->SetData(3, 7.5);
				 my3DXYLine->SetColor(GREEN);
				 my3DXYLine->SetDataLegend("data 3");
				 my3DXYLine->CloseDataSet();
				 */
			break;
		case 2 :
				 my3DXYLine->SetTickLimits(0, 4, -10, 0);
				 my3DXYLine->SetTickStep(1,1);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, -2);
				 my3DXYLine->SetData(2, -4);
				 my3DXYLine->SetData(3, -6);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, -3);
				 my3DXYLine->SetData(2, -6);
				 my3DXYLine->SetData(3, -9);
				 my3DXYLine->SetColor(BLUE);
				 my3DXYLine->SetDataLegend("data 2");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, -1.5);
				 my3DXYLine->SetData(2, -4.5);
				 my3DXYLine->SetData(3, -7.5);
				 my3DXYLine->SetColor(GREEN);
				 my3DXYLine->SetDataLegend("data 3");
				 my3DXYLine->CloseDataSet();
			break;
		case 3 :
				 my3DXYLine->SetTickLimits(-4, 0, 0, 10);
				 my3DXYLine->SetTickStep(1,1);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, 2);
				 my3DXYLine->SetData(-2, 4);
				 my3DXYLine->SetData(-3, 6);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, 3);
				 my3DXYLine->SetData(-2, 6);
				 my3DXYLine->SetData(-3, 9);
				 my3DXYLine->SetColor(BLUE);
				 my3DXYLine->SetDataLegend("data 2");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, 1.5);
				 my3DXYLine->SetData(-2, 4.5);
				 my3DXYLine->SetData(-3, 7.5);
				 my3DXYLine->SetColor(GREEN);
				 my3DXYLine->SetDataLegend("data 3");
				 my3DXYLine->CloseDataSet();
			break;
		case 4 :
				 my3DXYLine->SetTickLimits(-4, 0, -10, 0);
				 my3DXYLine->SetTickStep(1,1);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -2);
				 my3DXYLine->SetData(-2, -4);
				 my3DXYLine->SetData(-3, -6);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -3);
				 my3DXYLine->SetData(-2, -6);
				 my3DXYLine->SetData(-3, -9);
				 my3DXYLine->SetColor(BLUE);
				 my3DXYLine->SetDataLegend("data 2");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -1.5);
				 my3DXYLine->SetData(-2, -4.5);
				 my3DXYLine->SetData(-3, -7.5);
				 my3DXYLine->SetColor(GREEN);
				 my3DXYLine->SetDataLegend("data 3");
				 my3DXYLine->CloseDataSet();
			break;
		case 5 : 
				 my3DXYLine->SetTickLimits(-2, 2, 0, 10);
				 my3DXYLine->SetTickStep(1,1);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, 2);
				 my3DXYLine->SetData(-2, 4);
				 my3DXYLine->SetData(1, 6);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, 3);
				 my3DXYLine->SetData(-2, 6);
				 my3DXYLine->SetData(2, 9);
				 my3DXYLine->SetColor(BLUE);
				 my3DXYLine->SetDataLegend("data 2");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, 1.5);
				 my3DXYLine->SetData(-2, 4.5);
				 my3DXYLine->SetData(1.5, 7.5);
				 my3DXYLine->SetColor(GREEN);
				 my3DXYLine->SetDataLegend("data 3");
				 my3DXYLine->CloseDataSet();
			break;
		case 6 :
				 my3DXYLine->SetTickLimits(-2, 2, -10, 0);
				 my3DXYLine->SetTickStep(1,1);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -2);
				 my3DXYLine->SetData(-2, -4);
				 my3DXYLine->SetData(1, -6);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -3);
				 my3DXYLine->SetData(-2, -6);
				 my3DXYLine->SetData(2, -9);
				 my3DXYLine->SetColor(BLUE);
				 my3DXYLine->SetDataLegend("data 2");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -1.5);
				 my3DXYLine->SetData(-2, -4.5);
				 my3DXYLine->SetData(1.5, -7.5);
				 my3DXYLine->SetColor(GREEN);
				 my3DXYLine->SetDataLegend("data 3");
				 my3DXYLine->CloseDataSet();
			break;
		case 7 :
				 my3DXYLine->SetTickLimits(0, 4, -10, 10);
				 my3DXYLine->SetTickStep(1,1);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, -2);
				 my3DXYLine->SetData(2, -4);
				 my3DXYLine->SetData(3, 6);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, -3);
				 my3DXYLine->SetData(2, -6);
				 my3DXYLine->SetData(3, 9);
				 my3DXYLine->SetColor(BLUE);
				 my3DXYLine->SetDataLegend("data 2");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, -1.5);
				 my3DXYLine->SetData(2, -4.5);
				 my3DXYLine->SetData(3, 7.5);
				 my3DXYLine->SetColor(GREEN);
				 my3DXYLine->SetDataLegend("data 3");
				 my3DXYLine->CloseDataSet();
			break;
		case 8 :
				 my3DXYLine->SetTickLimits(-4, 0, -10, 10);
				 my3DXYLine->SetTickStep(1,1);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -2);
				 my3DXYLine->SetData(-2, -4);
				 my3DXYLine->SetData(-3, 6);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -3);
				 my3DXYLine->SetData(-2, -6);
				 my3DXYLine->SetData(-3, 9);
				 my3DXYLine->SetColor(BLUE);
				 my3DXYLine->SetDataLegend("data 2");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -1.5);
				 my3DXYLine->SetData(-2, -4.5);
				 my3DXYLine->SetData(-3, 7.5);
				 my3DXYLine->SetColor(GREEN);
				 my3DXYLine->SetDataLegend("data 3");
				 my3DXYLine->CloseDataSet();
			break;
		case 9 :
				 my3DXYLine->SetTickLimits(-2, 2, -10, 10);
				 my3DXYLine->SetTickStep(1,1);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -2);
				 my3DXYLine->SetData(-2, -4);
				 my3DXYLine->SetData(1, 6);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -3);
				 my3DXYLine->SetData(-2, -6);
				 my3DXYLine->SetData(2, 9);
				 my3DXYLine->SetColor(BLUE);
				 my3DXYLine->SetDataLegend("data 2");
				 my3DXYLine->CloseDataSet();

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(-1, -1.5);
				 my3DXYLine->SetData(-2, -4.5);
				 my3DXYLine->SetData(1, 7.5);
				 my3DXYLine->SetColor(GREEN);
				 my3DXYLine->SetDataLegend("data 3");
				 my3DXYLine->CloseDataSet();
			break;
		case 10 :
				AfxMessageBox("Not implemented");
				 my3DXYLine->SetTickLimits(0, 100, -100, 100);
				 my3DXYLine->SetTickStep(10,10);
				 my3DXYLine->EnableGridLines(TRUE);
				 my3DXYLine->SetXAxisLabel("X axis");
				 my3DXYLine->SetYAxisLabel("Y axis");

				 my3DXYLine->OpenDataSet();
				 my3DXYLine->SetData(0, 0);
				 my3DXYLine->SetData(1, -100);
				 my3DXYLine->SetData(2, 100);
				 my3DXYLine->SetData(3, 100);
				 my3DXYLine->SetData(4, 100);
				 my3DXYLine->SetData(5, 100);
				 my3DXYLine->SetData(6, 100);
				 my3DXYLine->SetData(7, 100);
				 my3DXYLine->SetData(8, 100);
				 my3DXYLine->SetData(9, 100);
				 my3DXYLine->SetColor(RED);
				 my3DXYLine->SetDataLegend("data 1");
				 my3DXYLine->CloseDataSet();
			break;
	}

	graphToDisplay = 8;
	okToDraw = TRUE;
	Invalidate(TRUE);
}

void CGraphDraw4View::OnDraw3DPie()
{
	// TODO: Add your command handler code here
	KillTimer(0x1234);
	if(my3DPie != NULL)
		delete my3DPie;
	my3DPie = new CPieGraph(TRUE);
	my3DPie->SetGraphTitle("Test 3D Pie Graph");
	my3DPie->SetLegendTitle("Legend");
	my3DPie->EnableGridLines(TRUE);
	my3DPie->DisplayLabels(TRUE);
	my3DPie->Set3DDepthRatio(10);

	my3DPie->OpenDataSet();
	my3DPie->SetData(1, 2);
	my3DPie->SetData(2, 1.5);
	my3DPie->SetData(3, 3);
	my3DPie->SetColor(1, RED);
	my3DPie->SetColor(2, BLUE);
	my3DPie->SetColor(3, GREEN);
	my3DPie->SetLegendText(1, "data 1");
	my3DPie->SetLegendText(2, "data 2");
	my3DPie->SetLegendText(3, "data 3");
	my3DPie->CloseDataSet();

	graphToDisplay = 10;
	okToDraw = TRUE;
	Invalidate(TRUE);
}

void CGraphDraw4View::OnDraw3DStackedBar()
{
	// TODO: Add your command handler code here
	int testcase;	//for testing purposes only...
	CTestCaseDlg tc;

	tc.DoModal();
	testcase = tc.m_nTestCase;

	KillTimer(0x1234);
	if(my3DStackedBar != NULL)
		delete my3DStackedBar;
	my3DStackedBar = new CStackedBarGraph(TRUE);
	my3DStackedBar->SetGraphTitle("Test Stacked Bar Graph");
	my3DStackedBar->SetLegendTitle("Legend");
	my3DStackedBar->EnableGridLines(TRUE);
//	my3DStackedBar->EnableDoubleBuffering(TRUE);

	switch(testcase)
	{
		case 1 :
				 my3DStackedBar->SetTickLimits(0, 4, 0, 30);
				 my3DStackedBar->SetTickStep(1,5);
				 my3DStackedBar->EnableGridLines(TRUE);
				 my3DStackedBar->SetXAxisLabel("X axis");
				 my3DStackedBar->SetYAxisLabel("Y axis");

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(1, 2);
				 my3DStackedBar->SetData(2, 4);
				 my3DStackedBar->SetData(3, 6);
				 my3DStackedBar->SetColor(RED);
				 my3DStackedBar->SetDataLegend("data 1");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(1, 3);
				 my3DStackedBar->SetData(2, 6);
				 my3DStackedBar->SetData(3, 9);
				 my3DStackedBar->SetColor(BLUE);
				 my3DStackedBar->SetDataLegend("data 2");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(1, 1.5);
				 my3DStackedBar->SetData(2, 4.5);
				 my3DStackedBar->SetData(3, 7.5);
				 my3DStackedBar->SetColor(GREEN);
				 my3DStackedBar->SetDataLegend("data 3");
				 my3DStackedBar->CloseDataSet();
			break;
		case 2 :
				 my3DStackedBar->SetTickLimits(0, 4, -30, 0);
				 my3DStackedBar->SetTickStep(1,5);
				 my3DStackedBar->EnableGridLines(TRUE);
				 my3DStackedBar->SetXAxisLabel("X axis");
				 my3DStackedBar->SetYAxisLabel("Y axis");

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(1, -2);
				 my3DStackedBar->SetData(2, -4);
				 my3DStackedBar->SetData(3, -6);
				 my3DStackedBar->SetColor(RED);
				 my3DStackedBar->SetDataLegend("data 1");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(1, -3);
				 my3DStackedBar->SetData(2, -6);
				 my3DStackedBar->SetData(3, -9);
				 my3DStackedBar->SetColor(BLUE);
				 my3DStackedBar->SetDataLegend("data 2");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(1, -1.5);
				 my3DStackedBar->SetData(2, -4.5);
				 my3DStackedBar->SetData(3, -7.5);
				 my3DStackedBar->SetColor(GREEN);
				 my3DStackedBar->SetDataLegend("data 3");
				 my3DStackedBar->CloseDataSet();
			break;
		case 3 :
				 my3DStackedBar->SetTickLimits(-4, 0, 0, 30);
				 my3DStackedBar->SetTickStep(1,5);
				 my3DStackedBar->EnableGridLines(TRUE);
				 my3DStackedBar->SetXAxisLabel("X axis");
				 my3DStackedBar->SetYAxisLabel("Y axis");

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, 2);
				 my3DStackedBar->SetData(-2, 4);
				 my3DStackedBar->SetData(-3, 6);
				 my3DStackedBar->SetColor(RED);
				 my3DStackedBar->SetDataLegend("data 1");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, 3);
				 my3DStackedBar->SetData(-2, 6);
				 my3DStackedBar->SetData(-3, 9);
				 my3DStackedBar->SetColor(BLUE);
				 my3DStackedBar->SetDataLegend("data 2");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, 1.5);
				 my3DStackedBar->SetData(-2, 4.5);
				 my3DStackedBar->SetData(-3, 7.5);
				 my3DStackedBar->SetColor(GREEN);
				 my3DStackedBar->SetDataLegend("data 3");
				 my3DStackedBar->CloseDataSet();
			break;
		case 4 :
				 my3DStackedBar->SetTickLimits(-4, 0, -30, 0);
				 my3DStackedBar->SetTickStep(1,5);
				 my3DStackedBar->EnableGridLines(TRUE);
				 my3DStackedBar->SetXAxisLabel("X axis");
				 my3DStackedBar->SetYAxisLabel("Y axis");

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -2);
				 my3DStackedBar->SetData(-2, -4);
				 my3DStackedBar->SetData(-3, -6);
				 my3DStackedBar->SetColor(RED);
				 my3DStackedBar->SetDataLegend("data 1");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -3);
				 my3DStackedBar->SetData(-2, -6);
				 my3DStackedBar->SetData(-3, -9);
				 my3DStackedBar->SetColor(BLUE);
				 my3DStackedBar->SetDataLegend("data 2");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -1.5);
				 my3DStackedBar->SetData(-2, -4.5);
				 my3DStackedBar->SetData(-3, -7.5);
				 my3DStackedBar->SetColor(GREEN);
				 my3DStackedBar->SetDataLegend("data 3");
				 my3DStackedBar->CloseDataSet();
			break;
		case 5 : 
				 my3DStackedBar->SetTickLimits(-2, 2, 0, 30);
				 my3DStackedBar->SetTickStep(1,5);
				 my3DStackedBar->EnableGridLines(TRUE);
				 my3DStackedBar->SetXAxisLabel("X axis");
				 my3DStackedBar->SetYAxisLabel("Y axis");

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, 2);
				 my3DStackedBar->SetData(-2, 4);
				 my3DStackedBar->SetData(3, 6);
				 my3DStackedBar->SetColor(RED);
				 my3DStackedBar->SetDataLegend("data 1");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, 3);
				 my3DStackedBar->SetData(-2, 6);
				 my3DStackedBar->SetData(3, 9);
				 my3DStackedBar->SetColor(BLUE);
				 my3DStackedBar->SetDataLegend("data 2");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, 1.5);
				 my3DStackedBar->SetData(-2, 4.5);
				 my3DStackedBar->SetData(3, 7.5);
				 my3DStackedBar->SetColor(GREEN);
				 my3DStackedBar->SetDataLegend("data 3");
				 my3DStackedBar->CloseDataSet();
			break;
		case 6 :
				 my3DStackedBar->SetTickLimits(-2, 2, -30, 0);
				 my3DStackedBar->SetTickStep(1,5);
				 my3DStackedBar->EnableGridLines(TRUE);
				 my3DStackedBar->SetXAxisLabel("X axis");
				 my3DStackedBar->SetYAxisLabel("Y axis");

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -2);
				 my3DStackedBar->SetData(-2, -4);
				 my3DStackedBar->SetData(3, -6);
				 my3DStackedBar->SetColor(RED);
				 my3DStackedBar->SetDataLegend("data 1");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -3);
				 my3DStackedBar->SetData(-2, -6);
				 my3DStackedBar->SetData(3, -9);
				 my3DStackedBar->SetColor(BLUE);
				 my3DStackedBar->SetDataLegend("data 2");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -1.5);
				 my3DStackedBar->SetData(-2, -4.5);
				 my3DStackedBar->SetData(3, -7.5);
				 my3DStackedBar->SetColor(GREEN);
				 my3DStackedBar->SetDataLegend("data 3");
				 my3DStackedBar->CloseDataSet();
			break;
		case 7 :
				 my3DStackedBar->SetTickLimits(0, 4, -30, 30);
				 my3DStackedBar->SetTickStep(1,5);
				 my3DStackedBar->EnableGridLines(TRUE);
				 my3DStackedBar->SetXAxisLabel("X axis");
				 my3DStackedBar->SetYAxisLabel("Y axis");

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(1, -2);
				 my3DStackedBar->SetData(2, -4);
				 my3DStackedBar->SetData(3, 6);
				 my3DStackedBar->SetColor(RED);
				 my3DStackedBar->SetDataLegend("data 1");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(1, -3);
				 my3DStackedBar->SetData(2, -6);
				 my3DStackedBar->SetData(3, 9);
				 my3DStackedBar->SetColor(BLUE);
				 my3DStackedBar->SetDataLegend("data 2");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(1, -1.5);
				 my3DStackedBar->SetData(2, -4.5);
				 my3DStackedBar->SetData(3, 7.5);
				 my3DStackedBar->SetColor(GREEN);
				 my3DStackedBar->SetDataLegend("data 3");
				 my3DStackedBar->CloseDataSet();
			break;
		case 8 :
				 my3DStackedBar->SetTickLimits(-4, 0, -30, 30);
				 my3DStackedBar->SetTickStep(1,5);
				 my3DStackedBar->EnableGridLines(TRUE);
				 my3DStackedBar->SetXAxisLabel("X axis");
				 my3DStackedBar->SetYAxisLabel("Y axis");

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -2);
				 my3DStackedBar->SetData(-2, -4);
				 my3DStackedBar->SetData(-3, 6);
				 my3DStackedBar->SetColor(RED);
				 my3DStackedBar->SetDataLegend("data 1");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -3);
				 my3DStackedBar->SetData(-2, -6);
				 my3DStackedBar->SetData(-3, 9);
				 my3DStackedBar->SetColor(BLUE);
				 my3DStackedBar->SetDataLegend("data 2");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -1.5);
				 my3DStackedBar->SetData(-2, -4.5);
				 my3DStackedBar->SetData(-3, 7.5);
				 my3DStackedBar->SetColor(GREEN);
				 my3DStackedBar->SetDataLegend("data 3");
				 my3DStackedBar->CloseDataSet();
			break;
		case 9 :
				 my3DStackedBar->SetTickLimits(-2, 2, -30, 30);
				 my3DStackedBar->SetTickStep(1,5);
				 my3DStackedBar->EnableGridLines(TRUE);
				 my3DStackedBar->SetXAxisLabel("X axis");
				 my3DStackedBar->SetYAxisLabel("Y axis");

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -2);
				 my3DStackedBar->SetData(0, -4);
				 my3DStackedBar->SetData(1, 6);
				 my3DStackedBar->SetColor(RED);
				 my3DStackedBar->SetDataLegend("data 1");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -3);
				 my3DStackedBar->SetData(0, -6);
				 my3DStackedBar->SetData(1, 9);
				 my3DStackedBar->SetColor(BLUE);
				 my3DStackedBar->SetDataLegend("data 2");
				 my3DStackedBar->CloseDataSet();

				 my3DStackedBar->OpenDataSet();
				 my3DStackedBar->SetData(-1, -1.5);
				 my3DStackedBar->SetData(0, -4.5);
				 my3DStackedBar->SetData(1, 7.5);
				 my3DStackedBar->SetColor(GREEN);
				 my3DStackedBar->SetDataLegend("data 3");
				 my3DStackedBar->CloseDataSet();
			break;
	}
	graphToDisplay = 9;
	okToDraw = TRUE;
	Invalidate(TRUE);
}