//XYLineGraph.cpp - Version 4.0 (Brian Convery, February, 2003)

#include "stdafx.h"
#include "afxtempl.h"
#include "math.h"
#include "XYLineGraph.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CXYLineGraph

CXYLineGraph::CXYLineGraph(BOOL display3D = FALSE):CGraph(display3D)
{
}

CXYLineGraph::~CXYLineGraph()
{
}

void CXYLineGraph::Draw(CDC* pDC)
{
	CMemDC* pMemDC = NULL;
	if(doubleBufferingEnabled)
		pDC = pMemDC = new CMemDC(pDC);
	DrawGraphBase(pDC);
	DrawLegend(pDC);
	DrawAxis(pDC);

	//for 3D graphs...
	int red, blue, green;

	//now, draw the data in XY Line format...

	int xDataLocation, yDataLocation;
	int lastXDataLocation, lastYDataLocation;
	int deltaX, deltaY;
	CGraphDataSet *tmpDataSet;
	POSITION pos;
	pos = dataSeries->GetHeadPosition();

	for(int x = 1; x <= dataSeries->GetCount(); x++)
	{
		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
		//first data element is just a place holder
		lastXDataLocation = yAxisLocation + (int)((tmpDataSet->GetXData(1)/* - minXTick*/) * pixelsPerXTick / xTickStep);
		lastYDataLocation = xAxisLocation - (int)((tmpDataSet->GetYData(1)/* - minYTick*/) * pixelsPerYTick / yTickStep);
		
		COLORREF lineColor;
		lineColor = tmpDataSet->GetColor();
		CBrush brush (lineColor);
		CBrush* pOldBrush;
		CPen rectPen(PS_SOLID, 1, lineColor);
		CPen* pOldPen;
		pOldPen = pDC->SelectObject(&rectPen);
		pOldBrush = pDC->SelectObject(&brush);

		for(int s = 2; s <= tmpDataSet->GetSize(); s++)
		{
			double dat1 = tmpDataSet->GetXData(s);
			double dat2 = tmpDataSet->GetYData(s);
			xDataLocation = yAxisLocation + (int)((tmpDataSet->GetXData(s)/* - minXTick*/) * pixelsPerXTick / xTickStep);
			yDataLocation = xAxisLocation - (int)((tmpDataSet->GetYData(s)/* - minYTick*/) * pixelsPerYTick / yTickStep);
			
			pDC->MoveTo(lastXDataLocation, lastYDataLocation);
			pDC->LineTo(xDataLocation, yDataLocation);

			if(is3D)
			{
				deltaX = xDataLocation - lastXDataLocation;
				deltaY = yDataLocation - lastYDataLocation;

				//the bottom side - darker than front
				red = GetRValue(lineColor);
				green = GetGValue(lineColor);
				blue = GetBValue(lineColor);

				int topRed = red + 35;
				int topGreen = green + 35;
				int topBlue = blue + 35;
				if(topRed > 255) topRed = 255;
				if(topGreen > 255) topGreen = 255;
				if(topBlue > 255) topBlue = 255;
				COLORREF topColor;
				topColor = RGB(topRed, topGreen, topBlue);

				int bottomRed = red - 35;
				int bottomGreen = green - 35;
				int bottomBlue = blue - 35;
				if(bottomRed < 0) bottomRed = 0;
				if(bottomGreen < 0) bottomGreen = 0;
				if(bottomBlue < 0) bottomBlue = 0;
				COLORREF bottomColor;
				bottomColor = RGB(bottomRed, bottomGreen, bottomBlue);
				
				if(deltaX != deltaY)
				{
					if(((deltaX > deltaY) && (deltaX < 0)) ||
					   ((deltaX < deltaY) && (deltaX > 0)))
					{
						CBrush bottomBrush (bottomColor);
						CPen bottomPen (PS_SOLID, 1, bottomColor);
						pDC->SelectObject(&bottomBrush);
						pDC->SelectObject(&bottomPen);
						CPoint bottomPolyArray[4];
						CPoint p1, p2, p3, p4;
						p1 = CPoint(lastXDataLocation, lastYDataLocation);
						p2 = CPoint(lastXDataLocation + axis3DDepth, lastYDataLocation - axis3DDepth - 1);
						p3 = CPoint(xDataLocation + axis3DDepth, yDataLocation - axis3DDepth - 1);
						p4 = CPoint(xDataLocation, yDataLocation);

						bottomPolyArray[0] = p1;
						bottomPolyArray[1] = p2;
						bottomPolyArray[2] = p3;
						bottomPolyArray[3] = p4;
						pDC->Polygon(bottomPolyArray, 4);
					}
					else
					{
						CBrush topBrush (topColor);
						CPen topPen (PS_SOLID, 1, topColor);
						pDC->SelectObject(&topBrush);
						pDC->SelectObject(&topPen);
						CPoint topPolyArray[4];
						CPoint p1, p2, p3, p4;
						p1 = CPoint(lastXDataLocation, lastYDataLocation);
						p2 = CPoint(lastXDataLocation + axis3DDepth, lastYDataLocation - axis3DDepth - 1);
						p3 = CPoint(xDataLocation + axis3DDepth, yDataLocation - axis3DDepth - 1);
						p4 = CPoint(xDataLocation, yDataLocation);

						topPolyArray[0] = p1;
						topPolyArray[1] = p2;
						topPolyArray[2] = p3;
						topPolyArray[3] = p4;
						pDC->Polygon(topPolyArray, 4);
					}
				}

			}
			lastXDataLocation = xDataLocation;
			lastYDataLocation = yDataLocation;
		}

		pDC->SelectObject(pOldPen);
		pDC->SelectObject(pOldBrush);
	}

	if(pMemDC != NULL)
		delete pMemDC;
}

int CXYLineGraph::Print(CDC *pDC)
{
	PrintGraphBase(pDC);
	PrintLegend(pDC);
	PrintAxis(pDC);

	//now, draw the data in XY Line format...

	int xDataLocation, yDataLocation;
	int lastXDataLocation, lastYDataLocation;
	CGraphDataSet *tmpDataSet;
	POSITION pos;
	pos = dataSeries->GetHeadPosition();

	for(int x = 1; x <= dataSeries->GetCount(); x++)
	{
		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
		//first data element is just a place holder
		lastXDataLocation = yAxisLocation + (int)(tmpDataSet->GetXData(1) * pixelsPerXTick);
		lastYDataLocation = xAxisLocation - (int)(tmpDataSet->GetYData(1) * pixelsPerYTick);
		
		COLORREF lineColor;
		lineColor = tmpDataSet->GetColor();
		CBrush brush (lineColor);
		CBrush* pOldBrush;
		CPen rectPen(PS_SOLID, 1, lineColor);
		CPen* pOldPen;
		pOldPen = pDC->SelectObject(&rectPen);
		pOldBrush = pDC->SelectObject(&brush);

		for(int s = 2; s <= tmpDataSet->GetSize(); s++)
		{
			xDataLocation = yAxisLocation + (int)(tmpDataSet->GetXData(s) * pixelsPerXTick);
			yDataLocation = xAxisLocation - (int)(tmpDataSet->GetYData(s) * pixelsPerYTick);
			
			pDC->MoveTo(lastXDataLocation, lastYDataLocation);
			pDC->LineTo(xDataLocation, yDataLocation);

			lastXDataLocation = xDataLocation;
			lastYDataLocation = yDataLocation;
		}

		pDC->SelectObject(pOldPen);
		pDC->SelectObject(pOldBrush);
	}

	return 1;
}
