//StackedBarGraph.cpp - Version 4.0 (Brian Convery, October, 2003)

#include "stdafx.h"
#include "afxtempl.h"
#include "math.h"
#include "StackedBarGraph.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStackedBarGraph

CStackedBarGraph::CStackedBarGraph(BOOL display3D):CGraph(display3D)
{
}

CStackedBarGraph::~CStackedBarGraph()
{
}

void CStackedBarGraph::Draw(CDC* pDC)
{
	CMemDC* pMemDC = NULL;
	if(doubleBufferingEnabled)
		pDC = pMemDC = new CMemDC(pDC);
	DrawGraphBase(pDC);
	DrawLegend(pDC);
	DrawAxis(pDC);

	//now, draw the data in stacked bar format...

	CGraphDataSet *tmpDataSet;
	POSITION pos;
	pos = dataSeries->GetHeadPosition();

	int maxDataSetSize = 0;
	for(int x = 1; x <= dataSeries->GetCount(); x++)
	{
		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
		if(tmpDataSet->GetSize() > maxDataSetSize)
			maxDataSetSize = tmpDataSet->GetSize();
	}

	int barWidth;
	int barL, barR, barT, barB;

	//for 3D graphs...
	int red, blue, green;

	if(!horizontalAlign)
		if(xTicksEnabled)
			barWidth = (int)(pixelsPerXTick * .75);
		else
			barWidth = (int)(xAxisWidth * .75);
	else
		if(xTicksEnabled)
			barWidth = (int)(pixelsPerYTick * .75);
		else
			barWidth = (int)(yAxisHeight * .75);

	int tickXLocation;
	int tickYLocation;
	for(int s = 1; s <= maxDataSetSize; s++)
	{
		if(!horizontalAlign) //set accumulative values
			barT = xAxisLocation;
		else
			barR = yAxisLocation;
		pos = dataSeries->GetHeadPosition();
		for(x = 1; x <= dataSeries->GetCount(); x++)
		{
			tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);

			if(!xTicksEnabled)
			{
				//special instance...need to manually draw the dataset label
				tickXLocation = yAxisLocation + (x * (xAxisWidth / dataSeries->GetCount())) - ((xAxisWidth / dataSeries->GetCount()) / 2);
				CFont* pOldFont;
				CFont xFont;
				TEXTMETRIC	tm;
				xFont.CreateFont(xTickFontSize, 0, 0, 0, 700, FALSE, FALSE, 0,
					ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
					DEFAULT_QUALITY, DEFAULT_PITCH | FF_ROMAN,"Arial");
				
				pOldFont = (CFont*)pDC->SelectObject(&xFont);
				pDC->GetTextMetrics(&tm);
				int charWidth = tm.tmAveCharWidth;
				pDC->TextOut(tickXLocation - ((tmpDataSet->GetLabel().GetLength() * charWidth) / 2), xAxisLocation + 10, tmpDataSet->GetLabel());
				pDC->SelectObject(&pOldFont);		
			}

			double dataXValue = 0;	//in case of no data value
			double dataYValue = 0;	//in case of no data value
			if(!horizontalAlign)
			{
				if(xTicksEnabled)
					tickXLocation = yAxisLocation + (int)(minXTick * pixelsPerXTick) + (s * pixelsPerXTick);
				else
					tickXLocation = yAxisLocation + (x * (xAxisWidth / dataSeries->GetCount())) - ((xAxisWidth / dataSeries->GetCount()) / 2);

				if(xTicksEnabled)
				{
					dataXValue += tmpDataSet->GetXData(s);

					dataYValue += tmpDataSet->GetYData(s);

					barL = tickXLocation - (barWidth / 2);
					barR = barL + barWidth;
					barB = barT;
					if(barB == xAxisLocation)
					{
						if(dataYValue > 0)
							barB--;
						else
							barB++;
					}
					barT -= (int)(dataYValue * pixelsPerYTick / yTickStep);

					COLORREF barColor;
					barColor = tmpDataSet->GetColor();
					CBrush brush (barColor);
					CBrush* pOldBrush;
					CPen rectPen(PS_SOLID, 1, barColor);
					CPen* pOldPen;
					pOldPen = pDC->SelectObject(&rectPen);
					pOldBrush = pDC->SelectObject(&brush);
					pDC->Rectangle(barL, barT, barR, barB);

					if(is3D)
					{
						//the side - darker than front
						red = GetRValue(barColor);
						green = GetGValue(barColor);
						blue = GetBValue(barColor);
						int sideRed = red - 35;
						int sideGreen = green - 35;
						int sideBlue = blue - 35;
						if(sideRed < 0) sideRed = 0;
						if(sideGreen < 0) sideGreen = 0;
						if(sideBlue < 0) sideBlue = 0;
						COLORREF sideColor;
						sideColor = RGB(sideRed, sideGreen, sideBlue);
						CBrush sideBrush (sideColor);
						CPen sidePen (PS_SOLID, 1, sideColor);
						pDC->SelectObject(&sideBrush);
						pDC->SelectObject(&sidePen);
						CPoint sidePolyArray[4];
						CPoint sp1(barR, barT);
						CPoint sp2(barR, barB);
						CPoint sp3(barR + axis3DDepth, barB - axis3DDepth);
						CPoint sp4(barR + axis3DDepth, barT - axis3DDepth);
						sidePolyArray[0] = sp1;
						sidePolyArray[1] = sp2;
						sidePolyArray[2] = sp3;
						sidePolyArray[3] = sp4;

						pDC->Polygon(sidePolyArray, 4);
						
						//the top - lighter than front
						int topRed = red + 35;
						int topGreen = green + 35;
						int topBlue = blue + 35;
						if(topRed > 255) topRed = 255;
						if(topGreen > 255) topGreen = 255;
						if(topBlue > 255) topBlue = 255;
						COLORREF topColor;
						topColor = RGB(topRed, topGreen, topBlue);
						CBrush topBrush (topColor);
						CPen topPen (PS_SOLID, 1, topColor);
						pDC->SelectObject(&topBrush);
						pDC->SelectObject(&topPen);
						CPoint topPolyArray[4];
						CPoint tp1(barL, barT);
						CPoint tp2(barR, barT);
						CPoint tp3(barR + axis3DDepth, barT - axis3DDepth);
						CPoint tp4(barL + axis3DDepth, barT - axis3DDepth);
						topPolyArray[0] = tp1;
						topPolyArray[1] = tp2;
						topPolyArray[2] = tp3;
						topPolyArray[3] = tp4;

						pDC->Polygon(topPolyArray, 4);
						pDC->SelectObject(pOldPen);
					}

					pDC->SelectObject(pOldPen);
					pDC->SelectObject(pOldBrush);
				}
				else
				{
					dataYValue += tmpDataSet->GetYData(s);

					barL = tickXLocation - (barWidth / 2);
					barR = barL + barWidth;
					barB = barT;
					if(barB == xAxisLocation)
					{
						if(dataYValue > 0)
							barB--;
						else
							barB++;
					}
					barT -= (int)(dataYValue * pixelsPerYTick / yTickStep);

					COLORREF barColor;
					barColor = tmpDataSet->GetColor();

					CBrush brush (barColor);
					CBrush* pOldBrush;
					CPen rectPen(PS_SOLID, 1, barColor);
					CPen* pOldPen;
					pOldPen = pDC->SelectObject(&rectPen);
					pOldBrush = pDC->SelectObject(&brush);
					pDC->Rectangle(barL, barT, barR, barB);

					if(is3D)
					{
						//the side - darker than front
						red = GetRValue(barColor);
						green = GetGValue(barColor);
						blue = GetBValue(barColor);
						int sideRed = red - 35;
						int sideGreen = green - 35;
						int sideBlue = blue - 35;
						if(sideRed < 0) sideRed = 0;
						if(sideGreen < 0) sideGreen = 0;
						if(sideBlue < 0) sideBlue = 0;
						COLORREF sideColor;
						sideColor = RGB(sideRed, sideGreen, sideBlue);
						CBrush sideBrush (sideColor);
						CPen sidePen (PS_SOLID, 1, sideColor);
						pDC->SelectObject(&sideBrush);
						pDC->SelectObject(&sidePen);
						CPoint sidePolyArray[4];
						CPoint sp1(barL, barT);
						CPoint sp2(barR, barT);
						CPoint sp3(barR + axis3DDepth, barT - axis3DDepth);
						CPoint sp4(barL + axis3DDepth, barT - axis3DDepth);
						sidePolyArray[0] = sp1;
						sidePolyArray[1] = sp2;
						sidePolyArray[2] = sp3;
						sidePolyArray[3] = sp4;

						pDC->Polygon(sidePolyArray, 4);
						
						//the top - lighter than front
						int topRed = red + 35;
						int topGreen = green + 35;
						int topBlue = blue + 35;
						if(topRed > 255) topRed = 255;
						if(topGreen > 255) topGreen = 255;
						if(topBlue > 255) topBlue = 255;
						COLORREF topColor;
						topColor = RGB(topRed, topGreen, topBlue);
						CBrush topBrush (topColor);
						CPen topPen (PS_SOLID, 1, topColor);
						pDC->SelectObject(&topBrush);
						pDC->SelectObject(&topPen);
						CPoint topPolyArray[4];
						CPoint tp1(barR, barT);
						CPoint tp2(barR, barB);
						CPoint tp3(barR + axis3DDepth, barB - axis3DDepth);
						CPoint tp4(barR + axis3DDepth, barT - axis3DDepth);
						topPolyArray[0] = tp1;
						topPolyArray[1] = tp2;
						topPolyArray[2] = tp3;
						topPolyArray[3] = tp4;

						pDC->Polygon(topPolyArray, 4);
						pDC->SelectObject(pOldPen);
					}

					pDC->SelectObject(pOldPen);
					pDC->SelectObject(pOldBrush);
				}
			}
			else
			{
				tickYLocation = xAxisLocation - (s * pixelsPerYTick);

				dataYValue += tmpDataSet->GetYData(s);
				if(dataYValue == s)
				{
					dataXValue += tmpDataSet->GetXData(s);

					barL = barR;
					if(barL == yAxisLocation)
					{
						if(dataYValue > 0)
							barB++;
						else
							barB--;
					}
					barR += (int)(dataXValue * pixelsPerXTick / xTickStep);
					barT = tickYLocation - (barWidth / 2);
					barB = barT + barWidth;

					COLORREF barColor;
					barColor = tmpDataSet->GetColor();
					CBrush brush (barColor);
					CBrush* pOldBrush;
					CPen rectPen(PS_SOLID, 1, barColor);
					CPen* pOldPen;
					pOldPen = pDC->SelectObject(&rectPen);
					pOldBrush = pDC->SelectObject(&brush);
					pDC->Rectangle(barL, barT, barR, barB);

					if(is3D)
					{
						//the side - darker than front
						red = GetRValue(barColor);
						green = GetGValue(barColor);
						blue = GetBValue(barColor);
						int sideRed = red - 35;
						int sideGreen = green - 35;
						int sideBlue = blue - 35;
						if(sideRed < 0) sideRed = 0;
						if(sideGreen < 0) sideGreen = 0;
						if(sideBlue < 0) sideBlue = 0;
						COLORREF sideColor;
						sideColor = RGB(sideRed, sideGreen, sideBlue);
						CBrush sideBrush (sideColor);
						CPen sidePen (PS_SOLID, 1, sideColor);
						pDC->SelectObject(&sideBrush);
						pDC->SelectObject(&sidePen);
						CPoint sidePolyArray[4];
						CPoint sp1(barR, barT);
						CPoint sp2(barR, barB);
						CPoint sp3(barR + axis3DDepth, barB - axis3DDepth);
						CPoint sp4(barR + axis3DDepth, barT - axis3DDepth);
						sidePolyArray[0] = sp1;
						sidePolyArray[1] = sp2;
						sidePolyArray[2] = sp3;
						sidePolyArray[3] = sp4;

						pDC->Polygon(sidePolyArray, 4);
						
						//the top - lighter than front
						int topRed = red + 35;
						int topGreen = green + 35;
						int topBlue = blue + 35;
						if(topRed > 255) topRed = 255;
						if(topGreen > 255) topGreen = 255;
						if(topBlue > 255) topBlue = 255;
						COLORREF topColor;
						topColor = RGB(topRed, topGreen, topBlue);
						CBrush topBrush (topColor);
						CPen topPen (PS_SOLID, 1, topColor);
						pDC->SelectObject(&topBrush);
						pDC->SelectObject(&topPen);
						CPoint topPolyArray[4];
						CPoint tp1(barL, barT);
						CPoint tp2(barR, barT);
						CPoint tp3(barR + axis3DDepth, barT - axis3DDepth);
						CPoint tp4(barL + axis3DDepth, barT - axis3DDepth);
						topPolyArray[0] = tp1;
						topPolyArray[1] = tp2;
						topPolyArray[2] = tp3;
						topPolyArray[3] = tp4;

						pDC->Polygon(topPolyArray, 4);
						pDC->SelectObject(pOldPen);
					}

					pDC->SelectObject(pOldPen);
					pDC->SelectObject(pOldBrush);
				}
			}
		}
	}
	if(pMemDC != NULL)
		delete pMemDC;
}

int CStackedBarGraph::Print(CDC *pDC)
{
	PrintGraphBase(pDC);
	PrintLegend(pDC);
	PrintAxis(pDC);

	CGraphDataSet *tmpDataSet;
	POSITION pos;
	pos = dataSeries->GetHeadPosition();

	int maxDataSetSize = 0;
	for(int x = 1; x <= dataSeries->GetCount(); x++)
	{
		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
		if(tmpDataSet->GetSize() > maxDataSetSize)
			maxDataSetSize = tmpDataSet->GetSize();
	}

	int barWidth;
	int barL, barR, barT, barB;

	//for 3D graphs...
	int red, blue, green;

	if(!horizontalAlign)
		if(xTicksEnabled)
			barWidth = (int)(pixelsPerXTick * .75);
		else
			barWidth = (int)(xAxisWidth * .75);
	else
		if(xTicksEnabled)
			barWidth = (int)(pixelsPerYTick * .75);
		else
			barWidth = (int)(yAxisHeight * .75);

	int tickXLocation;
	int tickYLocation;
	for(int s = 1; s <= maxDataSetSize; s++)
	{
		if(!horizontalAlign) //set accumulative values
			barT = xAxisLocation + 20;
		else
			barR = yAxisLocation;
		pos = dataSeries->GetHeadPosition();
		for(x = 1; x <= dataSeries->GetCount(); x++)
		{
			tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);

			if(!xTicksEnabled)
			{
				//special instance...need to manually draw the dataset label
				tickXLocation = yAxisLocation + (x * (xAxisWidth / dataSeries->GetCount())) - ((xAxisWidth / dataSeries->GetCount()) / 2);
				CFont* pOldFont;
				CFont xFont;
				TEXTMETRIC	tm;
				xFont.CreateFont(xTickFontSize, 0, 0, 0, 700, FALSE, FALSE, 0,
					ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
					DEFAULT_QUALITY, DEFAULT_PITCH | FF_ROMAN,"Arial");
				
				pOldFont = (CFont*)pDC->SelectObject(&xFont);
				pDC->GetTextMetrics(&tm);
				int charWidth = tm.tmAveCharWidth;
				pDC->TextOut(tickXLocation - ((tmpDataSet->GetLabel().GetLength() * charWidth) / 2), xAxisLocation + 10, tmpDataSet->GetLabel());
				pDC->SelectObject(&pOldFont);		
			}

			double dataXValue = 0;	//in case of no data value
			double dataYValue = 0;	//in case of no data value
			if(!horizontalAlign)
			{
				if(xTicksEnabled)
					tickXLocation = yAxisLocation + (int)(minXTick * pixelsPerXTick) + (s * pixelsPerXTick);
				else
					tickXLocation = yAxisLocation + (x * (xAxisWidth / dataSeries->GetCount())) - ((xAxisWidth / dataSeries->GetCount()) / 2);

				if(xTicksEnabled)
				{
					dataXValue += tmpDataSet->GetXData(s);

					dataYValue += tmpDataSet->GetYData(s);

					barL = tickXLocation - (barWidth / 2);
					barR = barL + barWidth;
					barB = barT;
					if(barB == xAxisLocation)
					{
						if(dataYValue > 0)
							barB--;
						else
							barB++;
					}
					barT -= (int)(dataYValue * pixelsPerYTick / yTickStep);

					COLORREF barColor;
					barColor = tmpDataSet->GetColor();
					CBrush brush (barColor);
					CBrush* pOldBrush;
					CPen rectPen(PS_SOLID, 1, barColor);
					CPen* pOldPen;
					pOldPen = pDC->SelectObject(&rectPen);
					pOldBrush = pDC->SelectObject(&brush);
					pDC->Rectangle(barL, barT, barR, barB);

					if(is3D)
					{
						//the side - darker than front
						red = GetRValue(barColor);
						green = GetGValue(barColor);
						blue = GetBValue(barColor);
						int sideRed = red - 35;
						int sideGreen = green - 35;
						int sideBlue = blue - 35;
						if(sideRed < 0) sideRed = 0;
						if(sideGreen < 0) sideGreen = 0;
						if(sideBlue < 0) sideBlue = 0;
						COLORREF sideColor;
						sideColor = RGB(sideRed, sideGreen, sideBlue);
						CBrush sideBrush (sideColor);
						CPen sidePen (PS_SOLID, 1, sideColor);
						pDC->SelectObject(&sideBrush);
						pDC->SelectObject(&sidePen);
						CPoint sidePolyArray[4];
						CPoint sp1(barR, barT);
						CPoint sp2(barR, barB);
						CPoint sp3(barR + axis3DDepth, barB - axis3DDepth);
						CPoint sp4(barR + axis3DDepth, barT - axis3DDepth);
						sidePolyArray[0] = sp1;
						sidePolyArray[1] = sp2;
						sidePolyArray[2] = sp3;
						sidePolyArray[3] = sp4;

						pDC->Polygon(sidePolyArray, 4);
						
						//the top - lighter than front
						int topRed = red + 35;
						int topGreen = green + 35;
						int topBlue = blue + 35;
						if(topRed > 255) topRed = 255;
						if(topGreen > 255) topGreen = 255;
						if(topBlue > 255) topBlue = 255;
						COLORREF topColor;
						topColor = RGB(topRed, topGreen, topBlue);
						CBrush topBrush (topColor);
						CPen topPen (PS_SOLID, 1, topColor);
						pDC->SelectObject(&topBrush);
						pDC->SelectObject(&topPen);
						CPoint topPolyArray[4];
						CPoint tp1(barL, barT);
						CPoint tp2(barR, barT);
						CPoint tp3(barR + axis3DDepth, barT - axis3DDepth);
						CPoint tp4(barL + axis3DDepth, barT - axis3DDepth);
						topPolyArray[0] = tp1;
						topPolyArray[1] = tp2;
						topPolyArray[2] = tp3;
						topPolyArray[3] = tp4;

						pDC->Polygon(topPolyArray, 4);
						pDC->SelectObject(pOldPen);
					}

					pDC->SelectObject(pOldPen);
					pDC->SelectObject(pOldBrush);
				}
				else
				{
					dataYValue += tmpDataSet->GetYData(s);

					barL = tickXLocation - (barWidth / 2);
					barR = barL + barWidth;
					barB = barT;
					if(barB == xAxisLocation)
					{
						if(dataYValue > 0)
							barB--;
						else
							barB++;
					}
					barT -= (int)(dataYValue * pixelsPerYTick / yTickStep);

					COLORREF barColor;
					barColor = tmpDataSet->GetColor();

					CBrush brush (barColor);
					CBrush* pOldBrush;
					CPen rectPen(PS_SOLID, 1, barColor);
					CPen* pOldPen;
					pOldPen = pDC->SelectObject(&rectPen);
					pOldBrush = pDC->SelectObject(&brush);
					pDC->Rectangle(barL, barT, barR, barB);

					if(is3D)
					{
						//the side - darker than front
						red = GetRValue(barColor);
						green = GetGValue(barColor);
						blue = GetBValue(barColor);
						int sideRed = red - 35;
						int sideGreen = green - 35;
						int sideBlue = blue - 35;
						if(sideRed < 0) sideRed = 0;
						if(sideGreen < 0) sideGreen = 0;
						if(sideBlue < 0) sideBlue = 0;
						COLORREF sideColor;
						sideColor = RGB(sideRed, sideGreen, sideBlue);
						CBrush sideBrush (sideColor);
						CPen sidePen (PS_SOLID, 1, sideColor);
						pDC->SelectObject(&sideBrush);
						pDC->SelectObject(&sidePen);
						CPoint sidePolyArray[4];
						CPoint sp1(barL, barT);
						CPoint sp2(barR, barT);
						CPoint sp3(barR + axis3DDepth, barT - axis3DDepth);
						CPoint sp4(barL + axis3DDepth, barT - axis3DDepth);
						sidePolyArray[0] = sp1;
						sidePolyArray[1] = sp2;
						sidePolyArray[2] = sp3;
						sidePolyArray[3] = sp4;

						pDC->Polygon(sidePolyArray, 4);
						
						//the top - lighter than front
						int topRed = red + 35;
						int topGreen = green + 35;
						int topBlue = blue + 35;
						if(topRed > 255) topRed = 255;
						if(topGreen > 255) topGreen = 255;
						if(topBlue > 255) topBlue = 255;
						COLORREF topColor;
						topColor = RGB(topRed, topGreen, topBlue);
						CBrush topBrush (topColor);
						CPen topPen (PS_SOLID, 1, topColor);
						pDC->SelectObject(&topBrush);
						pDC->SelectObject(&topPen);
						CPoint topPolyArray[4];
						CPoint tp1(barR, barT);
						CPoint tp2(barR, barB);
						CPoint tp3(barR + axis3DDepth, barB - axis3DDepth);
						CPoint tp4(barR + axis3DDepth, barT - axis3DDepth);
						topPolyArray[0] = tp1;
						topPolyArray[1] = tp2;
						topPolyArray[2] = tp3;
						topPolyArray[3] = tp4;

						pDC->Polygon(topPolyArray, 4);
						pDC->SelectObject(pOldPen);
					}

					pDC->SelectObject(pOldPen);
					pDC->SelectObject(pOldBrush);
				}
			}
			else
			{
				tickYLocation = xAxisLocation - (s * pixelsPerYTick);

				dataYValue += tmpDataSet->GetYData(s);
				if(dataYValue == s)
				{
					dataXValue += tmpDataSet->GetXData(s);

					barL = barR;
					if(barL == yAxisLocation)
					{
						if(dataYValue > 0)
							barB++;
						else
							barB--;
					}
					barR += (int)(dataXValue * pixelsPerXTick / xTickStep);
					barT = tickYLocation - (barWidth / 2);
					barB = barT + barWidth;

					COLORREF barColor;
					barColor = tmpDataSet->GetColor();
					CBrush brush (barColor);
					CBrush* pOldBrush;
					CPen rectPen(PS_SOLID, 1, barColor);
					CPen* pOldPen;
					pOldPen = pDC->SelectObject(&rectPen);
					pOldBrush = pDC->SelectObject(&brush);
					pDC->Rectangle(barL, barT, barR, barB);

					if(is3D)
					{
						//the side - darker than front
						red = GetRValue(barColor);
						green = GetGValue(barColor);
						blue = GetBValue(barColor);
						int sideRed = red - 35;
						int sideGreen = green - 35;
						int sideBlue = blue - 35;
						if(sideRed < 0) sideRed = 0;
						if(sideGreen < 0) sideGreen = 0;
						if(sideBlue < 0) sideBlue = 0;
						COLORREF sideColor;
						sideColor = RGB(sideRed, sideGreen, sideBlue);
						CBrush sideBrush (sideColor);
						CPen sidePen (PS_SOLID, 1, sideColor);
						pDC->SelectObject(&sideBrush);
						pDC->SelectObject(&sidePen);
						CPoint sidePolyArray[4];
						CPoint sp1(barR, barT);
						CPoint sp2(barR, barB);
						CPoint sp3(barR + axis3DDepth, barB - axis3DDepth);
						CPoint sp4(barR + axis3DDepth, barT - axis3DDepth);
						sidePolyArray[0] = sp1;
						sidePolyArray[1] = sp2;
						sidePolyArray[2] = sp3;
						sidePolyArray[3] = sp4;

						pDC->Polygon(sidePolyArray, 4);
						
						//the top - lighter than front
						int topRed = red + 35;
						int topGreen = green + 35;
						int topBlue = blue + 35;
						if(topRed > 255) topRed = 255;
						if(topGreen > 255) topGreen = 255;
						if(topBlue > 255) topBlue = 255;
						COLORREF topColor;
						topColor = RGB(topRed, topGreen, topBlue);
						CBrush topBrush (topColor);
						CPen topPen (PS_SOLID, 1, topColor);
						pDC->SelectObject(&topBrush);
						pDC->SelectObject(&topPen);
						CPoint topPolyArray[4];
						CPoint tp1(barL, barT);
						CPoint tp2(barR, barT);
						CPoint tp3(barR + axis3DDepth, barT - axis3DDepth);
						CPoint tp4(barL + axis3DDepth, barT - axis3DDepth);
						topPolyArray[0] = tp1;
						topPolyArray[1] = tp2;
						topPolyArray[2] = tp3;
						topPolyArray[3] = tp4;

						pDC->Polygon(topPolyArray, 4);
						pDC->SelectObject(pOldPen);
					}

					pDC->SelectObject(pOldPen);
					pDC->SelectObject(pOldBrush);
				}
			}
		}
	}

	return 1;
}
