//ScatterGraph.cpp - Version 4.0 (Brian Convery, March, 2003)

#include "stdafx.h"
#include "afxtempl.h"
#include "math.h"
#include "ScatterGraph.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScatterGraph

CScatterGraph::CScatterGraph(BOOL display3D = FALSE):CGraph(display3D)
{
	plotPointSize = 3;
}

CScatterGraph::~CScatterGraph()
{
}

void CScatterGraph::SetPlotPointSize(int size)
{
	plotPointSize = size;
}

void CScatterGraph::Draw(CDC* pDC)
{
	CMemDC* pMemDC = NULL;
	if(doubleBufferingEnabled)
		pDC = pMemDC = new CMemDC(pDC);
	DrawGraphBase(pDC);
	DrawLegend(pDC);
	DrawAxis(pDC);

	//now, draw the data in Scatter format...
	int xDataLocation, yDataLocation;
	CGraphDataSet *tmpDataSet;
	POSITION pos;
	pos = dataSeries->GetHeadPosition();

	for(int x = 1; x <= dataSeries->GetCount(); x++)
	{
		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
		
		COLORREF lineColor;
		lineColor = tmpDataSet->GetColor();
		CBrush brush (lineColor);
		CBrush* pOldBrush;
		CPen rectPen(PS_SOLID, 1, lineColor);
		CPen* pOldPen;
		pOldPen = pDC->SelectObject(&rectPen);
		pOldBrush = pDC->SelectObject(&brush);

		for(int s = 1; s <= tmpDataSet->GetSize(); s++)
		{
			xDataLocation = yAxisLocation + (int)(tmpDataSet->GetXData(s) * pixelsPerXTick / xTickStep);
			yDataLocation = xAxisLocation - (int)(tmpDataSet->GetYData(s) * pixelsPerYTick / yTickStep);
			
			pDC->Ellipse(xDataLocation - plotPointSize, 
					yDataLocation - plotPointSize,
					xDataLocation + plotPointSize, 
					yDataLocation + plotPointSize);
		}

		pDC->SelectObject(pOldPen);
		pDC->SelectObject(pOldBrush);
	}

	if(pMemDC != NULL)
		delete pMemDC;
}

int CScatterGraph::Print(CDC *pDC)
{
	PrintGraphBase(pDC);
	PrintLegend(pDC);
	PrintAxis(pDC);

	int xDataLocation, yDataLocation;
	CGraphDataSet *tmpDataSet;
	POSITION pos;
	pos = dataSeries->GetHeadPosition();

	for(int x = 1; x <= dataSeries->GetCount(); x++)
	{
		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
		
		COLORREF lineColor;
		lineColor = tmpDataSet->GetColor();
		CBrush brush (lineColor);
		CBrush* pOldBrush;
		CPen rectPen(PS_SOLID, 1, lineColor);
		CPen* pOldPen;
		pOldPen = pDC->SelectObject(&rectPen);
		pOldBrush = pDC->SelectObject(&brush);

		for(int s = 1; s <= tmpDataSet->GetSize(); s++)
		{
			xDataLocation = yAxisLocation + (int)(tmpDataSet->GetXData(s) * pixelsPerXTick / xTickStep);
			yDataLocation = xAxisLocation - (int)(tmpDataSet->GetYData(s) * pixelsPerYTick / yTickStep);
			
			pDC->Ellipse(xDataLocation - (plotPointSize * 20), 
					yDataLocation - (plotPointSize * 20),
					xDataLocation + (plotPointSize * 20), 
					yDataLocation + (plotPointSize * 20));
		}

		pDC->SelectObject(pOldPen);
		pDC->SelectObject(pOldBrush);
	}

	return 1;
}
