//PieGraph.h - Version 4.0 (Brian Convery, February, 2003)

#if !defined(_PIEGRAPH_H_)
#define _PIEGRAPH_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// PieGraph.h : header file
//

#include "Graph.h"

class CPieGraph : public CGraph
{
// Construction
public:
	CPieGraph(BOOL display3D);

// Attributes
public:


private:
	BOOL displayPieLabels;
	CObList *colors;
	int centerXPie, centerYPie;

// Operations
public:
	void Draw(CDC* pDC);
	int Print(CDC *pDC);
	void DisplayLabels(BOOL displayTF);
	void SetColor(int element, COLORREF color);
	COLORREF GetColor(int element);
	void DrawLegend(CDC *pDC);
	void PrintLegend(CDC *pDC);
	void SetLegendText(int element, CString legendText);

private:
	void DrawShadowPie(int depth, CDC* pDC);
	void PrintShadowPie(int depth, CDC* pDC);

// Implementation
public:
	virtual ~CPieGraph();

};

class CPieGraphLabel
{
	//this class is for storing offsets for pie labels as they display around the pie
// Construction & Destruction
public:
	CPieGraphLabel();
	~CPieGraphLabel();

// Attributes
public:
	int lineXStart;
	int lineYStart;
	int lineXEnd;
	int lineYEnd;
	int topLeftX;
	int topLeftY;
	int labelQuadrant;
	CString pieLabel;	//i.e.  30% - actual percentile

// Operations
public:

};

class CPieColorLeg
{
	//this class is a data combo class for color data and legend text data
// Construction & Destruction
public:
	CPieColorLeg();
	~CPieColorLeg();

// Attributes
private:
	int element;
	COLORREF color;
	CString legendText;

// Operations
public:
	void SetElement(int inElement);
	void SetColor(COLORREF cinColor);
	int GetElement();
	COLORREF GetColor();
	void SetLegendText(CString lText);
	CString GetLegendText();
};
/////////////////////////////////////////////////////////////////////////////

#endif // !defined(_PIEGRAPH_H_)
