//PieGraph.cpp - Version 4.0 (Brian Convery, February, 2003)

#include "stdafx.h"
#include "afxtempl.h"
#include "math.h"
#include "PieGraph.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPieGraph

CPieGraph::CPieGraph(BOOL display3D = FALSE):CGraph(display3D)
{
	displayPieLabels = FALSE;
	colors = new CObList();
}

CPieGraph::~CPieGraph()
{
	POSITION pos;
 	pos = colors->GetHeadPosition();
 	while(pos!=NULL)
 	{
  		CPieColorLeg *curData = (CPieColorLeg*)colors->GetNext(pos);
  		delete curData;
 	}
 	colors->RemoveAll();
 	delete colors;
}

void CPieGraph::DisplayLabels(BOOL displayTF)
{
	displayPieLabels = displayTF;
}

void CPieGraph::SetColor(int element, COLORREF color)
{
	CPieColorLeg *curColor;
	POSITION pos;
	pos = colors->GetHeadPosition();
	BOOL found = FALSE;
	while(pos != NULL)
	{
		curColor = (CPieColorLeg*)colors->GetNext(pos);
		if(curColor->GetElement() == element)
		{
			curColor->SetColor(color);
			found = TRUE;
			break;
		}
	}
	if(!found)
	{
		curColor = new CPieColorLeg();
		curColor->SetElement(element);
		curColor->SetColor(color);
		colors->AddTail((CObject*)curColor);
	}
}

COLORREF CPieGraph::GetColor(int element)
{
	POSITION pos;
	pos = colors->GetHeadPosition();
	CPieColorLeg *curColor;
	while(pos != NULL)
	{
		curColor = (CPieColorLeg*)colors->GetNext(pos);
		if(curColor->GetElement() == element)
			return curColor->GetColor();
	}
	return NULL;
}


void CPieGraph::Draw(CDC* pDC)
{
	CMemDC* pMemDC = NULL;
	if(doubleBufferingEnabled)
		pDC = pMemDC = new CMemDC(pDC);
	DrawGraphBase(pDC);
	DrawLegend(pDC);

	double dataSum = 0.00;  //for storing cumulative sum
	double labelData = 0.00;
	int lastXLocation, lastYLocation;
	int newXLocation, newYLocation;
	int labelXLocation, labelYLocation;
	double percent = 0.00;
	double labelPercent = 0.00;
	int degrees;
	int labelDegrees;
	double totalSum = 0.00;
	int radius;
	POSITION pos;
	int seriesSpace;
	int labelLineXStart, labelLineYStart;
	int labelLineXEnd, labelLineYEnd;
	int maxLabelWidth;
	int maxLabelHeight;
	TEXTMETRIC tm;
	CPen* pOldPen;
	CBrush* pOldBrush;
		
	CPen tmpPen(PS_SOLID, 1, BLACK);
	CBrush tmpBrush(WHITE);
	pOldPen = pDC->SelectObject(&tmpPen);
	pOldBrush = pDC->SelectObject(&tmpBrush);

	//deltaX and deltaY will be based on distance from x and y
	//axis for the new endpoint of the pie.  These values can 
	//then be used to find the true distance between starting 
	//line and ending line of pie boundary.
	double deltaX, deltaY;
	double degreeRadians, degreeRadians2;
	double labelDeltaX, labelDeltaY;
	double labelDegreeRadians, labelDegreeRadians2;

	lastXLocation = 0;
	lastYLocation = 0;

	pDC->GetTextMetrics(&tm);
	maxLabelWidth = tm.tmMaxCharWidth + 10;
	maxLabelHeight = tm.tmHeight + 6;
	
	//pie labels will be stored in a list and drawn after entire pie
	//is completed.
	CObList *pieLabels;
	CPieGraphLabel *pieLabel;

	//determine width of pie display area
	if(xAxisWidth > yAxisHeight)
		seriesSpace = yAxisHeight;
	else
		seriesSpace = xAxisWidth;
	if(displayPieLabels)
		seriesSpace -= (3 * maxLabelWidth);  //allows text like 25%  (3 chars)

	//to plot a pie plus labels inside of series space, use the following :
	//(3 * radius) + (2 * label width) = series space 
	//so, 3*radius = series space - (2 * label width)
	// 1 radius = (series space - (2 * label width)) / 3
	radius = seriesSpace / 3;  //pie needs 2 radius, + 1 extra for line to labels = 3 for my divisor
	int depth = (int)(radius * (depthRatio / 100.0));	//for shadow pie

	centerYPie = (yAxisHeight + 60) / 2;

	CGraphDataSet *tmpDataSet;
	pos = dataSeries->GetHeadPosition();
	pDC->SelectObject(pOldBrush);
	pDC->SelectObject(pOldPen);
	if(displayPieLabels)
		pieLabels = new CObList();

	tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
	totalSum = 0;
	for(int s = 1; s <= tmpDataSet->GetSize(); s++)
		totalSum += tmpDataSet->GetYData(s);
	int pieLeft, pieRight;
	pieLeft = yAxisLocation + (xAxisWidth / 2) - radius;
	pieRight = pieLeft + (2 * radius);
	CRect pieRect (pieLeft, 
			centerYPie - radius,
			pieRight, 
			centerYPie + radius);
	CRect shadowRect (pieLeft + depth,
			centerYPie - radius + depth,
			pieRight + depth,
			centerYPie + radius + depth);
	centerXPie = pieLeft + radius;

	//plot series label
	if(displayPieLabels)
	{
		pDC->TextOut(centerXPie - ((tmpDataSet->GetLabel().GetLength() * 8) / 2),
			centerYPie + (int)(radius * 1.5) + maxLabelHeight + 15, tmpDataSet->GetLabel());
	}
	else
	{
		pDC->TextOut(centerXPie - ((tmpDataSet->GetLabel().GetLength() * 8) / 2),
			centerYPie + radius + maxLabelHeight + 15, tmpDataSet->GetLabel());
	}

	if(is3D)
	{
		for(int d = depth; d >= 1; d--)
		{
			// I've had problems with doing the shadow for the upper
			//right quadrant.  Therefore, the way I'll draw the 3d shadow
			//will be to draw a shadow pie for every pixel of number depth.
			//So, if depth is 10, it'll draw 10 shadow pies, each offset
			//from the previous by 1 pixel X and Y
			DrawShadowPie(d, pDC);
		}
	}

	//draw normal pie
	lastXLocation = pieLeft;
	lastYLocation = centerYPie;

	dataSum = 0;
	for(s = 1; s <= tmpDataSet->GetSize(); s++)
	{
		if(tmpDataSet->GetYData(s) > 0)
		{
			double seriesDataValue;
			seriesDataValue = tmpDataSet->GetYData(s);
			labelData = seriesDataValue / 2;
			dataSum += seriesDataValue;
			percent = (dataSum / totalSum) * 100;
			labelPercent = ((dataSum - labelData) / totalSum) * 100;
			degrees = (int)((360 * percent) / 100);
			labelDegrees = (int)((360 * labelPercent) / 100);

			//determine destination quadrant...
				//and set newXLocation and newYLocation values...
				//degress / 90 will never exceed 4.
				//this can tell us the quadrant of destination
			int quadrant = degrees / 90;  //truncates decimal
			int labelQuadrant = labelDegrees / 90;

			//using the law of sines to determine the deltas :
			//deltaX = radius * sin(90 - degrees)
			//deltaY = radius * sin(degrees)
			//we convert degrees into radians so sin() function works right
			//note :  in quad 1 and 3, we reverse the angle used to compute
			//			the deltas, since the triangle plots reversed.
			switch(quadrant)
			{
				case 0 : //this is the base quadrant, so no manipulation needed
						degreeRadians = degrees * (3.14159 / 180);
						degreeRadians2 = (90 - degrees) * (3.14159 / 180);
						deltaX = radius * sin(degreeRadians2);
						deltaY = radius * sin(degreeRadians);
						newXLocation = (int)(centerXPie - deltaX);
						newYLocation = (int)(centerYPie + deltaY);
						break;
				case 1 : //bottom right quadrant, subtract 90 from angle
						degreeRadians = (degrees - 90) * (3.14159 / 180);
						degreeRadians2 = (90 - (degrees - 90)) * (3.14159 / 180);
						deltaX = radius * sin(degreeRadians);
						deltaY = radius * sin(degreeRadians2);
						newXLocation = (int)(centerXPie + deltaX);
						newYLocation = (int)(centerYPie + deltaY);
						break;
				case 2 : //top right quadrant, subtract 180 from angle
						degreeRadians = (degrees - 180) * (3.14159 / 180);
						degreeRadians2 = (90 - (degrees - 180)) * (3.14159 / 180);
						deltaX = radius * sin(degreeRadians2);
						deltaY = radius * sin(degreeRadians);
						newXLocation = (int)(centerXPie + deltaX);
						newYLocation = (int)(centerYPie - deltaY);
						break;
				case 3 : //upper left quadrant, subtract 270 from angle
						degreeRadians = (degrees - 270) * (3.14159 / 180);
						degreeRadians2 = (90 - (degrees - 270)) * (3.14159 / 180);
						deltaX = radius * sin(degreeRadians);
						deltaY = radius * sin(degreeRadians2);
						newXLocation = (int)(centerXPie - deltaX);
						newYLocation = (int)(centerYPie - deltaY);
						break;
				case 4 : //straight line to left of center
						deltaX = radius;
						deltaY = 1;
						newXLocation = (int)(centerXPie - deltaX);
						newYLocation = (int)(centerYPie - deltaY);
						break;
			}
			
			if(displayPieLabels)
			{
				switch(labelQuadrant)
				{
					//after getting X & Y location for label, we take
					//1/2 the delta between x y locations and center pie
					case 0 : 
							labelDegreeRadians = labelDegrees * (3.14159 / 180);
							labelDegreeRadians2 = (90 - labelDegrees) * (3.14159 / 180);
							labelDeltaX = radius * sin(labelDegreeRadians2);
							labelDeltaY = radius * sin(labelDegreeRadians);
							labelXLocation = (int)(centerXPie - labelDeltaX);
							labelYLocation = (int)(centerYPie + labelDeltaY);
							labelLineXStart = labelXLocation + ((centerXPie - labelXLocation) / 2);
							labelLineYStart = labelYLocation - ((labelYLocation - centerYPie) / 2);
							labelLineXEnd = labelXLocation - (radius / 2);
							labelLineYEnd = labelYLocation + (radius / 2);
							break;
					case 1 : 
							labelDegreeRadians = (labelDegrees - 90) * (3.14159 / 180);
							labelDegreeRadians2 = (90 - (labelDegrees - 90)) * (3.14159 / 180);
							labelDeltaX = radius * sin(labelDegreeRadians);
							labelDeltaY = radius * sin(labelDegreeRadians2);
							labelXLocation = (int)(centerXPie + labelDeltaX);
							labelYLocation = (int)(centerYPie + labelDeltaY);
							labelLineXStart = labelXLocation - ((labelXLocation - centerXPie) / 2);
							labelLineYStart = labelYLocation - ((labelYLocation - centerYPie) / 2);
							labelLineXEnd = labelXLocation + (radius / 2);
							labelLineYEnd = labelYLocation + (radius / 2);
							break;
					case 2 : 
							labelDegreeRadians = (labelDegrees - 180) * (3.14159 / 180);
							labelDegreeRadians2 = (90 - (labelDegrees - 180)) * (3.14159 / 180);
							labelDeltaX = radius * sin(labelDegreeRadians2);
							labelDeltaY = radius * sin(labelDegreeRadians);
							labelXLocation = (int)(centerXPie + labelDeltaX);
							labelYLocation = (int)(centerYPie - labelDeltaY);
							labelLineXStart = labelXLocation - ((labelXLocation - centerXPie) / 2);
							labelLineYStart = labelYLocation + ((centerYPie - labelYLocation) / 2);
							labelLineXEnd = labelXLocation + (radius / 2);
							labelLineYEnd = labelYLocation - (radius / 2);
							break;
					case 3 : 
							labelDegreeRadians = (labelDegrees - 270) * (3.14159 / 180);
							labelDegreeRadians2 = (90 - (labelDegrees - 270)) * (3.14159 / 180);
							labelDeltaX = radius * sin(labelDegreeRadians);
							labelDeltaY = radius * sin(labelDegreeRadians2);
							labelXLocation = (int)(centerXPie - labelDeltaX);
							labelYLocation = (int)(centerYPie - labelDeltaY);
							labelLineXStart = labelXLocation + ((centerXPie - labelXLocation) / 2);
							labelLineYStart = labelYLocation + ((centerYPie - labelYLocation) / 2);
							labelLineXEnd = labelXLocation - (radius / 2);
							labelLineYEnd = labelYLocation - (radius / 2);
							break;
//there should never be a half point ending on 4, so leave it out
				}

				pieLabel = new CPieGraphLabel();

				pieLabel->lineXStart = labelLineXStart;
				pieLabel->lineYStart = labelLineYStart;
				pieLabel->lineXEnd = labelLineXEnd;
				pieLabel->lineYEnd = labelLineYEnd;
				switch(labelQuadrant)
				{
					case 0 : //label to left of line
							pieLabel->topLeftX = labelLineXEnd - maxLabelWidth;
							pieLabel->topLeftY = labelLineYEnd;
							break;
					case 1 : //label to right of line
							pieLabel->topLeftX = labelLineXEnd + 5;
							pieLabel->topLeftY = labelLineYEnd;
							break;
					case 2 : //label to right of line
							pieLabel->topLeftX = labelLineXEnd + 5;
							pieLabel->topLeftY = labelLineYEnd - maxLabelHeight;
							break;
					case 3 : //label to left of line
							pieLabel->topLeftX = labelLineXEnd - maxLabelWidth;
							pieLabel->topLeftY = labelLineYEnd - maxLabelHeight;
							break;
				}
				pieLabel->labelQuadrant = labelQuadrant;
				int roundPercent;
				roundPercent = (int)((seriesDataValue * 100) / totalSum);
				pieLabel->pieLabel.Format("%d%%", roundPercent);
				pieLabels->AddTail((CObject*)pieLabel);
			}

			if(s == 1)
				lastYLocation -= 1;

			COLORREF barColor;
			barColor = GetColor((int)tmpDataSet->GetXData(s));
			CPoint p1 (lastXLocation, lastYLocation);
			CPoint p2 (newXLocation, newYLocation);
			CBrush brush (barColor);
			CPen piePen (PS_SOLID, 1, barColor);
			pDC->SelectObject(&piePen);
			pDC->SelectObject(&brush);
			pDC->Pie(pieRect, p1, p2); 

			lastXLocation = newXLocation;
			lastYLocation = newYLocation;
		}
		pDC->SelectObject(pOldBrush);
		pDC->SelectObject(pOldPen);
	}

	if(displayPieLabels)
	{
		//draw lines and labels for pies slices
		POSITION labelPos;

		CBrush lineBrush (BLACK);
		CPen linePen (PS_SOLID, 1, BLACK);
		pDC->SelectObject(&lineBrush);
		pDC->SelectObject(&linePen);
		POSITION mainLinePos, checkLinePos;
		mainLinePos = pieLabels->GetHeadPosition();
		int numLinesDrawn = 0;
		CPieGraphLabel* currentLabel;
		CPieGraphLabel* tmpLabel;
		while(mainLinePos != NULL)
		{
			currentLabel = (CPieGraphLabel*)pieLabels->GetNext(mainLinePos);
			int r = 0;
			checkLinePos = pieLabels->GetHeadPosition();
			while(r < numLinesDrawn)
			{
				//check if any overlap in label areas
				tmpLabel = (CPieGraphLabel*)pieLabels->GetAt(checkLinePos);
				if((currentLabel->topLeftX > tmpLabel->topLeftX) &&
					(currentLabel->topLeftX < (tmpLabel->topLeftX + maxLabelWidth)) &&
					(currentLabel->topLeftY > tmpLabel->topLeftY) &&
					(currentLabel->topLeftY < (tmpLabel->topLeftY + maxLabelHeight)))
				{
					//OVERLAP !!!
					//move current label top left position up or down
					//depending on its quadrant
					if(currentLabel->labelQuadrant < 2)
					{
						//move label down to tmplabel topleft + height
						currentLabel->topLeftY = tmpLabel->topLeftY + maxLabelHeight;
						currentLabel->lineYEnd = tmpLabel->lineYEnd + maxLabelHeight;
					}
					else
					{
						//move label up to tmpLabel topleft - height
						currentLabel->topLeftY = tmpLabel->topLeftY - maxLabelHeight;
						currentLabel->lineYEnd = tmpLabel->lineYEnd - maxLabelHeight;
					}
					//reset r value to 0 so it starts over, just in
					//case we moved the label and it overlaps another
					r = 0;
					checkLinePos = pieLabels->GetHeadPosition();
				}
				else
				{
					r++;
					pieLabels->GetNext(checkLinePos);
				}

			}
			//draw the line and label
			pDC->MoveTo(currentLabel->lineXStart, currentLabel->lineYStart);
			pDC->LineTo(currentLabel->lineXEnd, currentLabel->lineYEnd);

			//write the label
			pDC->TextOut(currentLabel->topLeftX, currentLabel->topLeftY,
					currentLabel->pieLabel);
			numLinesDrawn++;
		}

		//now done, remove everything inside the label list
		labelPos = pieLabels->GetHeadPosition();
		while(labelPos != NULL)
		{
			pieLabel = (CPieGraphLabel*)pieLabels->GetNext(labelPos);
			delete pieLabel;
		}
		delete pieLabels;
	}
	pDC->SelectObject(pOldBrush);
	pDC->SelectObject(pOldPen);

	if(pMemDC != NULL)
		delete pMemDC;
}

int CPieGraph::Print(CDC *pDC)
{
	PrintGraphBase(pDC);
	PrintLegend(pDC);


	return 1;
}

void CPieGraph::SetLegendText(int element, CString legendText)
{
	CPieColorLeg *curColor;
	POSITION pos;
	pos = colors->GetHeadPosition();
	BOOL found = FALSE;
	while(pos != NULL)
	{
		curColor = (CPieColorLeg*)colors->GetNext(pos);
		if(curColor->GetElement() == element)
		{
			curColor->SetLegendText(legendText);
			if(legendText.GetLength() > legendMaxText)
				legendMaxText = legendText.GetLength();
			found = TRUE;
			break;
		}
	}
	if(!found)
	{
		curColor = new CPieColorLeg();
		curColor->SetElement(element);
		curColor->SetLegendText(legendText);
		if(legendText.GetLength() > legendMaxText)
			legendMaxText = legendText.GetLength();
		colors->AddTail((CObject*)curColor);
	}
}

void CPieGraph::DrawLegend(CDC *pDC)
{
	//determine size of legend
	//12 chars per seriesSize + 6 for spacing (3 top and bottom) 
	//+ 1 set for label title(3+12+6) + rectangle (2 chars) + 3 for final bottom buffer
	int legendL, legendT, legendR, legendB, legendWidth;
	int barL, barT, barR, barB;
	int legendHeight;
	TEXTMETRIC tm;

	POSITION pos;
	CPieColorLeg *curDataSet;
	pos = colors->GetHeadPosition();
	curDataSet = (CPieColorLeg*) colors->GetAt(pos);
	legendHeight = 23 + (colors->GetSize() * 18) + 3;

	CFont legendFont;
	CFont* pOldFont;
	legendFont.CreateFont(legendFontSize, 0, 0, 0, 700, FALSE, FALSE, 0,
		ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY, DEFAULT_PITCH | FF_ROMAN, fontType);
	pOldFont = (CFont*) pDC->SelectObject(&legendFont);
	pDC->GetTextMetrics(&tm);
	int charWidth = tm.tmAveCharWidth;
	pDC->SelectObject(pOldFont);

	legendT = (yAxisHeight / 2) - (legendHeight / 2);
	legendB = legendT + legendHeight;
	legendR = xAxisWidth - 5;
	legendL = legendR - ((legendMaxText * charWidth) + 50);
	legendWidth = legendR - legendL;

	pDC->Rectangle(legendL, legendT, legendR, legendB);
	CFont legendTitleFont;
	legendTitleFont.CreateFont(legendFontSize + 6, 0, 0, 0, 700, FALSE, FALSE, 0,
		ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY, DEFAULT_PITCH | FF_ROMAN, fontType);
	pOldFont = (CFont*) pDC->SelectObject(&legendTitleFont);
	pDC->GetTextMetrics(&tm);
	charWidth = tm.tmAveCharWidth;
	pDC->TextOut(legendL + (legendWidth / 2) - ((legendTitle.GetLength() / 2) * charWidth), 
					legendT + 3, legendTitle);
	pDC->SelectObject(pOldFont);
	pos = colors->GetHeadPosition();
	for(int i = 0; i < colors->GetSize(); i++)
	{
		//top "Legend" text will use 12 + 3 top + 6 bottom (21 total)
		//each legend label will need 3 chars on top, so the 24 in the offset
		//each label than uses 12 + 3 below + 3 above next label, so 18
		// in the i * offset.
		curDataSet = (CPieColorLeg*) colors->GetAt(pos);
		if(legendMaxText > 0)
		{
			pOldFont = (CFont*) pDC->SelectObject(&legendFont);

			pDC->TextOut(legendL + 5, legendT + 24 + (i * 18) + 1, curDataSet->GetLegendText());

			pDC->SelectObject(pOldFont);

			//draw bar
			COLORREF barColor;
			barColor = curDataSet->GetColor();
			CBrush brush (barColor);
			CBrush* pOldBrush;
			pOldBrush = pDC->SelectObject(&brush);

			barL = legendL + 10 + (legendMaxText * charWidth);
			barT = legendT + 24 + (i * 18) + 1;
			barR = legendR - 5;
			barB = barT + 12;
			pDC->Rectangle(barL, barT, barR, barB);

			pDC->SelectObject(pOldBrush);
		}
		colors->GetNext(pos);
	}
	xAxisWidth -= (legendWidth + 20);
}

void CPieGraph::PrintLegend(CDC *pDC)
{
	//determine size of legend
	//12 chars per seriesSize + 6 for spacing (3 top and bottom) 
	//+ 1 set for label title(3+12+6) + rectangle (2 chars) + 3 for final bottom buffer
	int legendL, legendT, legendR, legendB, legendWidth;
	int barL, barT, barR, barB;
	int legendHeight;
	TEXTMETRIC tm;

	POSITION pos;
	CGraphDataSet *curDataSet;
	pos = dataSeries->GetHeadPosition();
	curDataSet = (CGraphDataSet*) dataSeries->GetAt(pos);
	legendHeight = -500 + (dataSeries->GetCount() * -360) - 60;

	CFont legendFont;
	CFont* pOldFont;
	legendFont.CreateFont(legendFontSize * 20, 0, 0, 0, 700, FALSE, FALSE, 0,
		ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY, DEFAULT_PITCH | FF_ROMAN, fontType);
	pOldFont = (CFont*) pDC->SelectObject(&legendFont);
	pDC->GetTextMetrics(&tm);
	int charWidth = tm.tmAveCharWidth;
	pDC->SelectObject(pOldFont);

	legendT = pGraphT - 500 + ((pGraphB - pGraphT) / 2) - (legendHeight / 2);
	legendB = legendT + legendHeight;
	legendR = pGraphR - 100;
	legendL = legendR - (((legendMaxText + 1) * charWidth) + 1000);
	legendWidth = legendR - legendL;

	pDC->Rectangle(legendL, legendT, legendR, legendB);
	CFont legendTitleFont;
	legendTitleFont.CreateFont((legendFontSize + 2) * 20, 0, 0, 0, 700, FALSE, FALSE, 0,
		ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY, DEFAULT_PITCH | FF_ROMAN, fontType);
	pOldFont = (CFont*) pDC->SelectObject(&legendTitleFont);
	pDC->GetTextMetrics(&tm);
	charWidth = tm.tmAveCharWidth;
	pDC->TextOut(legendL + (legendWidth / 2) - ((legendTitle.GetLength() / 2) * charWidth), 
					legendT - 60, legendTitle);
	pDC->SelectObject(pOldFont);
	pos = dataSeries->GetHeadPosition();
	for(int i = 0; i < dataSeries->GetCount(); i++)
	{
		//top "Legend" text will use 12 + 3 top + 6 bottom (21 total)
		//each legend label will need 3 chars on top, so the 24 in the offset
		//each label than uses 12 + 3 below + 3 above next label, so 18
		// in the i * offset.
		curDataSet = (CGraphDataSet*) dataSeries->GetAt(pos);
		pOldFont = (CFont*) pDC->SelectObject(&legendFont);

		pDC->TextOut(legendL + 100, legendT - 480 - (i * 360), curDataSet->GetLegend());

		pDC->SelectObject(pOldFont);

		//draw bar
		COLORREF barColor;
		barColor = curDataSet->GetColor();
		CBrush brush (barColor);
		CBrush* pOldBrush;
		pOldBrush = pDC->SelectObject(&brush);

		barL = legendL + 200 + (legendMaxText * charWidth);
		barT = legendT - 500 - (i * 360), curDataSet->GetLegend().GetLength();
		barR = legendR - 100;
		barB = barT - 240;
		pDC->Rectangle(barL, barT, barR, barB);

		pDC->SelectObject(pOldBrush);

		dataSeries->GetNext(pos);
		i = dataSeries->GetCount();
	}
	xAxisWidth -= legendWidth;

}

CPieGraphLabel::CPieGraphLabel()
{
	lineXStart = 0;
	lineYStart = 0;
	lineXEnd = 0;
	lineYEnd = 0;
	topLeftX = 0;
	topLeftY = 0;
}

CPieGraphLabel::~CPieGraphLabel()
{
}

CPieColorLeg::CPieColorLeg()
{
	color = BLACK;
	legendText = "";
}

CPieColorLeg::~CPieColorLeg()
{
}

void CPieColorLeg::SetElement(int inElement)
{
	element = inElement;
}

void CPieColorLeg::SetColor(COLORREF inColor)
{
	color = inColor;
}

int CPieColorLeg::GetElement()
{
	return element;
}

COLORREF CPieColorLeg::GetColor()
{
	return color;
}

void CPieColorLeg::SetLegendText(CString lText)
{
	legendText = lText;
}

CString CPieColorLeg::GetLegendText()
{
	return legendText;
}

void CPieGraph::DrawShadowPie(int depth, CDC* pDC)
{
	double dataSum = 0.00;  //for storing cumulative sum
	double labelData = 0.00;
	int lastXLocation, lastYLocation;
	int newXLocation, newYLocation;
	int labelXLocation, labelYLocation;
	double percent = 0.00;
	double labelPercent = 0.00;
	int degrees;
	int labelDegrees;
	double totalSum = 0.00;
	int radius;
	POSITION pos;
	int seriesSpace;
	int labelLineXStart, labelLineYStart;
	int labelLineXEnd, labelLineYEnd;
	int maxLabelWidth;
	int maxLabelHeight;
	TEXTMETRIC tm;
	CPen* pOldPen;
	CBrush* pOldBrush;
		
	CPen tmpPen(PS_SOLID, 1, BLACK);
	CBrush tmpBrush(WHITE);
	pOldPen = pDC->SelectObject(&tmpPen);
	pOldBrush = pDC->SelectObject(&tmpBrush);

	//deltaX and deltaY will be based on distance from x and y
	//axis for the new endpoint of the pie.  These values can 
	//then be used to find the true distance between starting 
	//line and ending line of pie boundary.
	double deltaX, deltaY;
	double degreeRadians, degreeRadians2;
	double labelDeltaX, labelDeltaY;
	double labelDegreeRadians, labelDegreeRadians2;

	lastXLocation = 0;
	lastYLocation = 0;

	pDC->GetTextMetrics(&tm);
	maxLabelWidth = tm.tmMaxCharWidth + 10;
	maxLabelHeight = tm.tmHeight + 6;
	
	//pie labels will be stored in a list and drawn after entire pie
	//is completed.
	CObList *pieLabels;
	CPieGraphLabel *pieLabel;

	//determine width of pie display area
	if(xAxisWidth > yAxisHeight)
		seriesSpace = yAxisHeight;
	else
		seriesSpace = xAxisWidth;
	if(displayPieLabels)
		seriesSpace -= (3 * maxLabelWidth);  //allows text like 25%  (3 chars)

	//to plot a pie plus labels inside of series space, use the following :
	//(3 * radius) + (2 * label width) = series space 
	//so, 3*radius = series space - (2 * label width)
	// 1 radius = (series space - (2 * label width)) / 3
	radius = seriesSpace / 3;  //pie needs 2 radius, + 1 extra for line to labels = 3 for my divisor
	//int depth = (int)(radius * (depthRatio / 100.0));	//for shadow pie

	centerYPie = (yAxisHeight + 60) / 2;

	CGraphDataSet *tmpDataSet;
	pos = dataSeries->GetHeadPosition();
	pDC->SelectObject(pOldBrush);
	pDC->SelectObject(pOldPen);
	if(displayPieLabels)
		pieLabels = new CObList();

	tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
	totalSum = 0;
	for(int s = 1; s <= tmpDataSet->GetSize(); s++)
		totalSum += tmpDataSet->GetYData(s);
	int pieLeft, pieRight;
	pieLeft = yAxisLocation + (xAxisWidth / 2) - radius;
	pieRight = pieLeft + (2 * radius);
	CRect pieRect (pieLeft + depth,
			centerYPie - radius + depth,
			pieRight + depth,
			centerYPie + radius + depth);
	centerXPie = pieLeft + radius;

	for(s = 1; s <= tmpDataSet->GetSize(); s++)
	{
		if(tmpDataSet->GetYData(s) > 0)
		{
			double seriesDataValue;
			seriesDataValue = tmpDataSet->GetYData(s);
			labelData = seriesDataValue / 2;
			dataSum += seriesDataValue;
			percent = (dataSum / totalSum) * 100;
			labelPercent = ((dataSum - labelData) / totalSum) * 100;
			degrees = (int)((360 * percent) / 100);
			labelDegrees = (int)((360 * labelPercent) / 100);

			//determine destination quadrant...
				//and set newXLocation and newYLocation values...
				//degress / 90 will never exceed 4.
				//this can tell us the quadrant of destination
			int quadrant = degrees / 90;  //truncates decimal
			int labelQuadrant = labelDegrees / 90;

			//using the law of sines to determine the deltas :
			//deltaX = radius * sin(90 - degrees)
			//deltaY = radius * sin(degrees)
			//we convert degrees into radians so sin() function works right
			//note :  in quad 1 and 3, we reverse the angle used to compute
			//			the deltas, since the triangle plots reversed.
			switch(quadrant)
			{
				case 0 : //this is the base quadrant, so no manipulation needed
						degreeRadians = degrees * (3.14159 / 180);
						degreeRadians2 = (90 - degrees) * (3.14159 / 180);
						deltaX = radius * sin(degreeRadians2);
						deltaY = radius * sin(degreeRadians);
						newXLocation = (int)(centerXPie - deltaX);
						newYLocation = (int)(centerYPie + deltaY);
						break;
				case 1 : //bottom right quadrant, subtract 90 from angle
						degreeRadians = (degrees - 90) * (3.14159 / 180);
						degreeRadians2 = (90 - (degrees - 90)) * (3.14159 / 180);
						deltaX = radius * sin(degreeRadians);
						deltaY = radius * sin(degreeRadians2);
						newXLocation = (int)(centerXPie + deltaX);
						newYLocation = (int)(centerYPie + deltaY);
						break;
				case 2 : //top right quadrant, subtract 180 from angle
						degreeRadians = (degrees - 180) * (3.14159 / 180);
						degreeRadians2 = (90 - (degrees - 180)) * (3.14159 / 180);
						deltaX = radius * sin(degreeRadians2);
						deltaY = radius * sin(degreeRadians);
						newXLocation = (int)(centerXPie + deltaX);
						newYLocation = (int)(centerYPie - deltaY);
						break;
				case 3 : //upper left quadrant, subtract 270 from angle
						degreeRadians = (degrees - 270) * (3.14159 / 180);
						degreeRadians2 = (90 - (degrees - 270)) * (3.14159 / 180);
						deltaX = radius * sin(degreeRadians);
						deltaY = radius * sin(degreeRadians2);
						newXLocation = (int)(centerXPie - deltaX);
						newYLocation = (int)(centerYPie - deltaY);
						break;
				case 4 : //straight line to left of center
						deltaX = radius;
						deltaY = 1;
						newXLocation = (int)(centerXPie - deltaX);
						newYLocation = (int)(centerYPie - deltaY);
						break;
			}
			newXLocation += depth;
			newYLocation += depth;
			
			if(s == 1)
				lastYLocation -= 1;

			COLORREF barColor;
			barColor = GetColor((int)tmpDataSet->GetXData(s));
			int red, green, blue;
			red = GetRValue(barColor) - 35;
			green = GetGValue(barColor) - 35;
			blue = GetBValue(barColor) - 35;
			if(red < 0) red = 0;
			if(green < 0) green = 0;
			if(blue < 0) blue = 0;
			COLORREF shadowColor(RGB(red, green, blue));
			CPen shadowPen (PS_SOLID, 1, shadowColor);
			CBrush shadowBrush(shadowColor);
			CPoint p1 (lastXLocation, lastYLocation);
			CPoint p2 (newXLocation, newYLocation);
			CBrush brush (shadowColor);
			CPen piePen (PS_SOLID, 1, shadowColor);
			pDC->SelectObject(&piePen);
			pDC->SelectObject(&brush);
			pDC->Pie(pieRect, p1, p2); 

			lastXLocation = newXLocation;
			lastYLocation = newYLocation;
		}
		pDC->SelectObject(pOldBrush);
		pDC->SelectObject(pOldPen);
	}
}

void CPieGraph::PrintShadowPie(int depth, CDC* pDC)
{

}
