// GraphDlg.cpp : implementation file
//

#include "stdafx.h"
#include "graphDraw4.h"
#include "GraphDlg.h"
#include "BarGraph.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGraphDlg dialog


CGraphDlg::CGraphDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGraphDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGraphDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CGraphDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGraphDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGraphDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphDlg)
	ON_BN_CLICKED(IDC_DRAW_BTN, OnDrawBtn)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphDlg message handlers

void CGraphDlg::OnDrawBtn() 
{
	// TODO: Add your control notification handler code here
	myBar = new CBarGraph(FALSE);
	myBar->SetGraphTitle("Test Bar Graph");
	myBar->SetLegendTitle("Legend");
	myBar->EnableGridLines(TRUE);
	myBar->SetXAxisLabel("Day-by-Day Comparison");
	myBar->SetYAxisLabel("PH Level");
//	myBar->EnableDoubleBuffering(TRUE);

	myBar->SetTickLimits(0, 4, 0, 10);
	myBar->SetTickStep(1,1);
	myBar->EnableGridLines(TRUE);
	myBar->SetXAxisLabel("X axis");
	myBar->SetYAxisLabel("Y axis");

	myBar->OpenDataSet();
	myBar->SetData(1, 2);
	myBar->SetData(2, 4);
	myBar->SetData(3, 6);
	myBar->SetColor(RED);
	myBar->SetDataLegend("data 1");
	myBar->CloseDataSet();

	myBar->OpenDataSet();
	myBar->SetData(1, 3);
	myBar->SetData(2, 6);
	myBar->SetData(3, 9);
	myBar->SetColor(BLUE);
	myBar->SetDataLegend("data 2");
	myBar->CloseDataSet();

	myBar->OpenDataSet();
	myBar->SetData(1, 1.5);
	myBar->SetData(2, 4.5);
	myBar->SetData(3, 7.5);
	myBar->SetColor(GREEN);
	myBar->SetDataLegend("data 3");
	myBar->CloseDataSet();

	CWnd* graphFrame = (CWnd*)GetDlgItem(IDC_GRAPH_FRAME);
	CDC* pDC = graphFrame->GetDC();

	myBar->Draw(pDC);
	ReleaseDC(pDC);
}
