//BoxWhiskerGraph.cpp - Version 4.0 (Brian Convery, May, 2003)

#include "stdafx.h"
#include "afxtempl.h"
#include "math.h"
#include "BoxWhiskerGraph.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBoxWhiskerGraph

CBoxWhiskerGraph::CBoxWhiskerGraph():CGraph(FALSE)
{
}

CBoxWhiskerGraph::~CBoxWhiskerGraph()
{
}

void CBoxWhiskerGraph::Draw(CDC* pDC)
{
	CMemDC* pMemDC = NULL;
	if(doubleBufferingEnabled)
		pDC = pMemDC = new CMemDC(pDC);
	DrawGraphBase(pDC);
	DrawLegend(pDC);
	DrawAxis(pDC);

	//now, draw the data in BoxWhisker format...
	int upperQuartile;
	int lowerQuartile;
	int median;
	int highValue;
	int lowValue;
	
	COLORREF barColor;
	barColor = BLACK;
	CBrush brush (barColor);
	CBrush* pOldBrush;
	pOldBrush = pDC->SelectObject(&brush);

	int barWidth;
	int barL, barT, barR, barB;
	int tickXLocation;
	POSITION pos;
	CGraphDataSet* tmpDataSet;

	CUIntArray dataArray;
	CUIntArray sortedArray;

	int maxDataSetSize = 0;
	pos = dataSeries->GetHeadPosition();
	for(int x = 1; x <= dataSeries->GetCount(); x++)
	{
		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
		if(tmpDataSet->GetSize() > maxDataSetSize)
			maxDataSetSize = tmpDataSet->GetSize();
	}

	pos = dataSeries->GetHeadPosition();
	for(x = 1; x <= dataSeries->GetCount(); x++)
	{
		dataArray.RemoveAll();
		sortedArray.RemoveAll();

		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);

		int dataValue;
		for(int s = 0; s < tmpDataSet->GetSize(); s++)
		{
			dataValue = 0;
			if(tmpDataSet->GetYData(s) > -1)
				dataValue = (int)tmpDataSet->GetYData(s);
			dataArray.Add(dataValue);
		}

		//sort the array
		dataValue = dataArray.GetAt(0);
		sortedArray.Add(dataValue);
		for(int d = 1; d < dataArray.GetSize(); d++)
		{
			dataValue = dataArray.GetAt(d);
			BOOL placed = FALSE;
			for(int s = 0; s < sortedArray.GetSize(); s++)
			{
				int tmpI = sortedArray.GetAt(s);
				if(dataValue <= tmpI)
				{
					sortedArray.InsertAt(s, dataValue);
					placed = TRUE;
					break;
				}
			}
			if(!placed)	//add at end
				sortedArray.Add(dataValue);
		}
		
		//sortedArray now contains the sorted list of all data in this
		//series.  From here, we derive the other box-whisker data
		
		int medialElement;
		div_t div_result;
		div_result = div(sortedArray.GetSize(), 2);

		if(div_result.rem == 0)	//even number of elements
		{
			//size is not 0 base, so below, I subtract 1 to 0 base it.
			medialElement = (sortedArray.GetSize() / 2) - 1;
			median = sortedArray.GetAt(medialElement) + 
						((sortedArray.GetAt(medialElement + 1) - 
						sortedArray.GetAt(medialElement)) / 2);
			highValue = sortedArray.GetAt(sortedArray.GetSize() - 1);
			lowValue = sortedArray.GetAt(0);
			div_t div2Result;
			div2Result = div(medialElement + 1, 2);
			if(div2Result.rem == 0)	//even again
			{
				upperQuartile = sortedArray.GetAt(medialElement + 1 + (medialElement / 2)) +
						(sortedArray.GetAt(medialElement + (medialElement / 2) + 2) -
						sortedArray.GetAt(medialElement + (medialElement / 2))) / 2;
				lowerQuartile = sortedArray.GetAt(medialElement / 2) +
						((sortedArray.GetAt((medialElement / 2) + 1) -
						sortedArray.GetAt(medialElement / 2)) / 2);
			}
			else	//odd
			{
				upperQuartile = sortedArray.GetAt(medialElement + 1 + (medialElement / 2));
				lowerQuartile = sortedArray.GetAt(medialElement / 2);
			}
		}
		else	//odd number of elements
		{
			//size is not 0 base, so below, I subtract 1 to 0 base it.
			medialElement = sortedArray.GetSize() / 2;
			median = sortedArray.GetAt(medialElement);
			highValue = sortedArray.GetAt(sortedArray.GetSize() - 1);
			lowValue = sortedArray.GetAt(0);
			div_t div2Result;
			div2Result = div(medialElement, 2);
			if(div2Result.rem == 0)	//even 
			{
				upperQuartile = sortedArray.GetAt(medialElement + (medialElement / 2)) +
						(sortedArray.GetAt(medialElement + (medialElement / 2) + 1) -
						sortedArray.GetAt(medialElement + (medialElement / 2))) / 2;
				lowerQuartile = sortedArray.GetAt((medialElement - 1) / 2) +
						((sortedArray.GetAt((medialElement + 1) / 2) -
						sortedArray.GetAt((medialElement - 1) / 2)) / 2);
			}
			else	//odd
			{
				upperQuartile = sortedArray.GetAt(medialElement + 1 + (medialElement / 2));
				lowerQuartile = sortedArray.GetAt(medialElement / 2);
			}
		}

		//data has been computed for median, high, low, and interquartile range
		//now we can draw the series

		if(xTicksEnabled)
			barWidth = (int)((pixelsPerXTick * .8) / dataSeries->GetCount());
		else
			barWidth = (int)((pixelsPerXTick * .8) / (dataSeries->GetCount() * maxDataSetSize));

		tickXLocation = yAxisLocation + (x * (xAxisWidth / dataSeries->GetCount())) - ((xAxisWidth / dataSeries->GetCount()) / 2);

		barL = tickXLocation - (barWidth / 2);
		barR = barL + barWidth;

		//top cross bar (max value)
		barT = xAxisLocation - (int)((highValue * 1.00) * pixelsPerYTick / yTickStep);
		barB = barT + 3;
		pDC->Rectangle(barL, barT, barR, barB);

		//bottom cross bar (min value)
		barT = xAxisLocation - (int)((lowValue * 1.00) * pixelsPerYTick / yTickStep);
		barB = barT - 3;
		pDC->Rectangle(barL, barT, barR, barB);

		//vertical line (whisker)
		barT = xAxisLocation - (int)((highValue * 1.00) * pixelsPerYTick / yTickStep);
		//barB = ?;	//this will be left over from bottom cross bar
		pDC->Rectangle(tickXLocation - 2, barT, tickXLocation + 2, barB);

		//box (interquartile range, from upper quartile to lower quartile)
		barT = xAxisLocation - (int)(upperQuartile * pixelsPerYTick / yTickStep);
		barB = xAxisLocation - (int)(lowerQuartile * pixelsPerYTick / yTickStep);
		pDC->Rectangle(barL, barT, barR, barB);

		//draw median line (in RED)
		CPen* pOldPen;
		CPen linePen (PS_SOLID, 1, RED);
		pOldPen = pDC->SelectObject(&linePen);
		pDC->MoveTo(barL, xAxisLocation - (int)((median * 1.00) * pixelsPerYTick / yTickStep));
		pDC->LineTo(barR, xAxisLocation - (int)((median * 1.00) * pixelsPerYTick / yTickStep));
		pDC->SelectObject(pOldPen);
	}

	pDC->SelectObject(pOldBrush);

	if(pMemDC != NULL)
		delete pMemDC;
}

int CBoxWhiskerGraph::Print(CDC *pDC)
{
	PrintGraphBase(pDC);
	PrintLegend(pDC);
	PrintAxis(pDC);

	//now, draw the data in BoxWhisker format...
	int upperQuartile;
	int lowerQuartile;
	int median;
	int highValue;
	int lowValue;
	
	COLORREF barColor;
	barColor = BLACK;
	CBrush brush (barColor);
	CBrush* pOldBrush;
	pOldBrush = pDC->SelectObject(&brush);

	int barWidth;
	int barL, barT, barR, barB;
	int tickXLocation;
	POSITION pos;
	CGraphDataSet* tmpDataSet;

	CUIntArray dataArray;
	CUIntArray sortedArray;

	int maxDataSetSize = 0;
	pos = dataSeries->GetHeadPosition();
	for(int x = 1; x <= dataSeries->GetCount(); x++)
	{
		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);
		if(tmpDataSet->GetSize() > maxDataSetSize)
			maxDataSetSize = tmpDataSet->GetSize();
	}

	pos = dataSeries->GetHeadPosition();
	for(x = 1; x <= dataSeries->GetCount(); x++)
	{
		dataArray.RemoveAll();
		sortedArray.RemoveAll();

		tmpDataSet = (CGraphDataSet*)dataSeries->GetNext(pos);

		int dataValue;
		for(int s = 0; s < tmpDataSet->GetSize(); s++)
		{
			dataValue = 0;
			if(tmpDataSet->GetYData(s) > -1)
				dataValue = (int)tmpDataSet->GetYData(s);
			dataArray.Add(dataValue);
		}

		//sort the array
		dataValue = dataArray.GetAt(0);
		sortedArray.Add(dataValue);
		for(int d = 1; d < dataArray.GetSize(); d++)
		{
			dataValue = dataArray.GetAt(d);
			BOOL placed = FALSE;
			for(int s = 0; s < sortedArray.GetSize(); s++)
			{
				int tmpI = sortedArray.GetAt(s);
				if(dataValue <= tmpI)
				{
					sortedArray.InsertAt(s, dataValue);
					placed = TRUE;
					break;
				}
			}
			if(!placed)	//add at end
				sortedArray.Add(dataValue);
		}
		
		//sortedArray now contains the sorted list of all data in this
		//series.  From here, we derive the other box-whisker data
		
		int medialElement;
		div_t div_result;
		div_result = div(sortedArray.GetSize(), 2);

		if(div_result.rem == 0)	//even number of elements
		{
			//size is not 0 base, so below, I subtract 1 to 0 base it.
			medialElement = (sortedArray.GetSize() / 2) - 1;
			median = sortedArray.GetAt(medialElement) + 
						((sortedArray.GetAt(medialElement + 1) - 
						sortedArray.GetAt(medialElement)) / 2);
			highValue = sortedArray.GetAt(sortedArray.GetSize() - 1);
			lowValue = sortedArray.GetAt(0);
			div_t div2Result;
			div2Result = div(medialElement + 1, 2);
			if(div2Result.rem == 0)	//even again
			{
				upperQuartile = sortedArray.GetAt(medialElement + 1 + (medialElement / 2)) +
						(sortedArray.GetAt(medialElement + (medialElement / 2) + 2) -
						sortedArray.GetAt(medialElement + (medialElement / 2))) / 2;
				lowerQuartile = sortedArray.GetAt(medialElement / 2) +
						((sortedArray.GetAt((medialElement / 2) + 1) -
						sortedArray.GetAt(medialElement / 2)) / 2);
			}
			else	//odd
			{
				upperQuartile = sortedArray.GetAt(medialElement + 1 + (medialElement / 2));
				lowerQuartile = sortedArray.GetAt(medialElement / 2);
			}
		}
		else	//odd number of elements
		{
			//size is not 0 base, so below, I subtract 1 to 0 base it.
			medialElement = sortedArray.GetSize() / 2;
			median = sortedArray.GetAt(medialElement);
			highValue = sortedArray.GetAt(sortedArray.GetSize() - 1);
			lowValue = sortedArray.GetAt(0);
			div_t div2Result;
			div2Result = div(medialElement, 2);
			if(div2Result.rem == 0)	//even 
			{
				upperQuartile = sortedArray.GetAt(medialElement + (medialElement / 2)) +
						(sortedArray.GetAt(medialElement + (medialElement / 2) + 1) -
						sortedArray.GetAt(medialElement + (medialElement / 2))) / 2;
				lowerQuartile = sortedArray.GetAt((medialElement - 1) / 2) +
						((sortedArray.GetAt((medialElement + 1) / 2) -
						sortedArray.GetAt((medialElement - 1) / 2)) / 2);
			}
			else	//odd
			{
				upperQuartile = sortedArray.GetAt(medialElement + 1 + (medialElement / 2));
				lowerQuartile = sortedArray.GetAt(medialElement / 2);
			}
		}

		//data has been computed for median, high, low, and interquartile range
		//now we can draw the series

		if(xTicksEnabled)
			barWidth = (int)((pixelsPerXTick * .8) / dataSeries->GetCount());
		else
			barWidth = (int)((pixelsPerXTick * .8) / (dataSeries->GetCount() * maxDataSetSize));

		tickXLocation = yAxisLocation + (x * (xAxisWidth / dataSeries->GetCount())) - ((xAxisWidth / dataSeries->GetCount()) / 2);

		barL = tickXLocation - (barWidth / 2);
		barR = barL + barWidth;

		//top cross bar (max value)
		barT = xAxisLocation - (int)((highValue * 1.00) * pixelsPerYTick / yTickStep);
		barB = barT - 60;
		pDC->Rectangle(barL, barT, barR, barB);

		//bottom cross bar (min value)
		barT = xAxisLocation - (int)((lowValue * 1.00) * pixelsPerYTick / yTickStep);
		barB = barT + 60;
		pDC->Rectangle(barL, barT, barR, barB);

		//vertical line (whisker)
		barT = xAxisLocation - (int)((highValue * 1.00) * pixelsPerYTick / yTickStep);
		//barB = ?;	//this will be left over from bottom cross bar
		pDC->Rectangle(tickXLocation - 40, barT, tickXLocation + 40, barB);

		//box (interquartile range, from upper quartile to lower quartile)
		barT = xAxisLocation - (int)(upperQuartile * pixelsPerYTick / yTickStep);
		barB = xAxisLocation - (int)(lowerQuartile * pixelsPerYTick / yTickStep);
		pDC->Rectangle(barL, barT, barR, barB);

		//draw median line (in RED)
		CPen* pOldPen;
		CPen linePen (PS_SOLID, 1, RED);
		pOldPen = pDC->SelectObject(&linePen);
		pDC->MoveTo(barL, xAxisLocation - (int)((median * 1.00) * pixelsPerYTick / yTickStep));
		pDC->LineTo(barR, xAxisLocation - (int)((median * 1.00) * pixelsPerYTick / yTickStep));
		pDC->SelectObject(pOldPen);
	}

	pDC->SelectObject(pOldBrush);

	return 1;
}
