;PWM_application.asm
;author: Arnold & Bott
;Pic 12F675 Processor Microchip
;Developmentsystem for Pic 12F675/629 (created by Arnold & Bott)
;----------------------------------------------------------------
			list	p=12F675
;----------------------------------------------------------------
w			equ	00		;working register
f			equ	01		;file register
status		equ	03		;status register
gpio		equ	05		;general port
trisio		equ	85		;tristate register
RP0			equ	05		;select bank 0-1
GP0			equ	00		;Lamp output
GP2			equ	02		;button input
tmr0		equ	01		;Timer0 register
ansel		equ	9F		;analog select register
intcon		equ	0B		;interrupt control register
cmcon		equ	19		;comparator select register
GIE			equ	07		;general interrupt enable
T0IE		equ	05		;Timer0 interrupt enable
T0IF		equ	02		;Timer0 interrupt flag
INTE		equ	04		;Interrupt on GP2 enable
INTF		equ	01		;Interrupt on GP2 flag
option_reg	equ	81		;Interrupt option register
dim_value	equ	20		;dim value
time1		equ	21		;waitingtime register
time2		equ	22		;waitingtime register
time3		equ	23		;waitingtime register
time4		equ	24		;waitingtime register
dim_status	equ	25		;dimming status register
up_down		equ	00		;dim up or dim down?
;---------------------------------------------------------------

			org	00
			goto	_main
			org	08

			org	04
			btfsc	intcon,INTF			;ext. interrupt flag ?
			goto	_isr2				;Gp2 interrupt routine
			btfsc	intcon,T0IF			;tmr0 interrupt flag ?
			goto	_isr1				;tmr0 interrupt routine
			retfie						;return from interrupt
;---------------------------------------------------------------
_init		clrf	gpio				;clear ports
			bsf		status,RP0			;select bank 1
			movlw	b'001100'
			movwf	trisio				;set GP2 as Input; all others as Output
			movlw	b'10000001'
			movwf	option_reg		
			clrf	ansel				;set gpio as digital
			bcf		status,RP0			;select bank 0
			movlw	b'11011000'			;general interrupts enable; Interrupt on GP2 enable
			movwf	intcon
			movlw	b'0000111'
			movwf	cmcon
_init2		movlw	d'254'
			movwf	dim_value			;load value 254 in register
			clrf	tmr0				;clear register tmr0
			return
;-----------------------------------------------------------------
_isr1		bcf		intcon,T0IE			;disable tmr0 interrupt
			bcf		intcon,T0IF			;clear tmr0 flag
			btfsc	gpio,GP0			;if GP0 is set, it will be reset...
			goto	_clear				
			btfss	gpio,GP0			;...and if it is zero, it will be set.
			bsf		gpio,GP0		
			goto	_comp
_clear		bcf		gpio,GP0
			movf	dim_value,w			;load dim value to w
			movwf	tmr0				;move value in tmr0 register
			
			goto	_end
_comp		movf	dim_value,w			;load dim value to w
			movwf	tmr0				;move value in tmr0 register
			comf	tmr0,f				;build complement of tmro value

_end		bcf		intcon,T0IF			;clear tmr0 flag
			bsf		intcon,T0IE			;enable tmr0 interrupt
			retfie
;------------------------------------------------------------------------
_isr2		btfss	intcon,INTE			;disable ext. interrupt
			goto	_next
			btfsc	intcon,T0IE			;enable tmr0 interrupt..
			goto	_clear1				;..if it was disabled...
			btfss	intcon,T0IE			;..and disable tmr0 interrupt...
			bsf		intcon,T0IE			;..if it was enabled
			bsf		gpio,GP0	
			goto	_next

_clear1		bcf		intcon,T0IE
			bcf		gpio,GP0
			clrf	tmr0
			bcf		intcon,T0IF
			call	_init2			
	
_next		bcf		intcon,INTF			;clear ext. interrupt flag
			bsf		intcon,INTE			;enable ext. interrupt
			bcf		intcon,T0IF			;clear tmr0 interrupt flag
			retfie
;-----------------------------------------------------------------------
_dim		bcf		intcon,INTE			;disable ext. interrupt
			bsf		intcon,T0IE			;enable tmr0 interrupt
			btfsc	dim_status,up_down	;dim up or dim down?
			goto	_inc
_dec		decfsz	dim_value,f			;decrease ON-time
			goto	_dec1
			goto	_inc
_dec1		bsf		dim_status,up_down	;set bit for dim up next time
			call	_10ms				;wait for 10 ms
			btfsc	gpio,GP2			;is GP2 still pressed ?
			goto	_dec			
			bcf		intcon,INTF			;clear ext. interrupt flag
			call	_150ms				;Tastenpreller
			return

_inc		incfsz	dim_value,f			;decrease ON-time
			goto	_inc1
			goto	_dec
_inc1		bcf		dim_status,up_down	;clear bit for dim down next time
			call	_10ms				;wait for 10 ms
			btfsc	gpio,GP2			;is GP2 still pressed ?
			goto	_inc			
			bcf		intcon,INTF			;clear ext. interrupt flag
			call	_150ms				;Tastenpreller
			return
;-----------------------------------------------------------------------
_150ms		movlw	d'150'				;waiting time about 150 ms
			movwf	time1
_wait		movlw	d'250'
			movwf	time2
_wait1		nop
			decfsz	time2,f
			goto	_wait1
			decfsz	time1,f
			goto	_wait
			return	
;----------------------------------------------------------------------
_10ms		movlw	d'10'				;waiting time about 150 ms
			movwf	time3
_wait2		movlw	d'250'
			movwf	time4
_wait3		nop
			decfsz	time4,f
			goto	_wait3
			decfsz	time3,f
			goto	_wait2
			return	
;---------------------main cycle--------------------------------------------------
_main		call	_init
_run		btfss	gpio,GP2			;is GP2 pressed ?
			goto	_run
			bcf		intcon,INTF			;clear ext. interrupt flag
			bsf		intcon,INTE			;enable ext. interrupt(falling edge)
			call	_150ms
			call	_150ms
			call	_150ms
			btfsc	gpio,GP2			;is GP2 still pressed ?
			call	_dim			
			goto	_run		
;----------------------------------------------------------------------
			org	2007
			de	b'10100100'

			end

