;xblinker1.asm
;program switches on and off  leds
;program developed with MPLab6.4
;c 2004 by arnold / bott
;---------------------------------------------------------------
list	p=12f675,f=inhx8m	;controller info f.assembler
;---------------------------------------------------------------
gpio		equ	05						;general port address
trisio		equ	85						;tristate address
status		equ	03						;status register
rp0			equ	05						;bank select bit
cmcon		equ	19						;compatator control register
ansel		equ	9f						;analog select register
w			equ	00						;destination w-register
f			equ	01						;destination f-register
wait_1		equ	20						;delay counter_1
wait_2		equ	21						;delay counter_2
;---------------------------------------------------------------
		org	00							;next instruct.address
		goto	_main					;goto main program
;--------------------------------------------------------------
_init	
			bcf			status,rp0		;select bank0
			clrf		gpio			;init port gpio
			movlw		0x07			;set gp<2:0> to ..
			movwf		cmcon			;.. digital io
			bsf			status,rp0		;select bank1		
			clrf		ansel			;init digital io
			movlw		b'000000'		;set gp<3> as input ..
			movwf		trisio			;..and gp<5:4,2:0> as outp.
			bcf			status,rp0		;select bank0
			return						;go back
;---------------------------------------------------------------
_led_05		movlw		b'110000'		;switch led<0,5> ..
			movwf		gpio			;.. on
			return
;---------------------------------------------------------------
_led_14		movlw		b'001111'		;switch led<1,4> ..
			movwf		gpio			;.. on
			return
;---------------------------------------------------------------
_delay_1	movlw		b'11111111'		;load ..
			movwf		wait_1			;wait_1 register 
_loop1		decfsz		wait_1,f		;decrement wait_1 register..
			goto		_lab1		
			return						;.. to zero
_lab1		call		_delay_2			;call inner loop
			goto		_loop1	
;---------------------------------------------------------------
_delay_2	movlw		b'11111111'		;analog subroutine delay_1
			movwf		wait_2
_loop2		decfsz		wait_2,f
			goto		_loop2
			return
;---------------------------------------------------------------
_main		call 		_init			;init gpio port
loop		call		_led_05			;switch on leds 0 & 5
			call		_delay_1			;delay 256 x 256 cycles
			call		_led_14			;switch on leds 1 & 4
			call		_delay_1			;delay 256 x 256 cycles
			goto		loop			;repeat infinite loop
;---------------------------------------------------------------
			org		2007
			de	b'10100100'
end							;end of programm

