;program:  Analog_4_Bit_Digital_Wandler.asm
;author:   Andreas Arnold und Manuel Bott
;Date:     12.01.05
;processor:Pic 12F275
;--------------processortype-----------------------------------

		list	p=12f675

;--------------constants----------------------------------

status	equ		03		;bank 0/1;
gpio	equ		05		;bank 0	 ;pic-ports
trisio	equ		85		;bank 1  ;pins are out- or inputs
ansel	equ		9F		;bank 1	 ;pins are analog or digital
adresh	equ		1E		;bank 0	 ;result of AD-converting high-byte
adresl	equ		9E		;bank 1	 ;result of AD-converting low-byte
adcon0	equ		1F		;bank 0  ;select analog input pin; starting a conversion
bcd_out	equ		20		;register to store output bits
time1	equ		21		;register to store waiting time
RP0		equ		05 	    ;select bank0/1
GP0		equ		00		;analog input
GP1		equ		01		;digital output bit 0
GP2		equ		02		;digital output bit 1
GP4		equ		04		;digital output bit 2
GP5		equ		05		;digital output bit 3

;----------------------------------------------------------

		org	00
		goto	_main		
		org	08				;start adress

;------------------settings--------------------------------
	
_init	bsf		status,RP0	;switch to bank 1
		movlw	b'001001'
		movwf	trisio		;GPO is input;GP1,GP2,GP4and GP5 are outputs
		movlw	b'01010001'	;settings of conversion clock (2,0s); ANS 1..3 are digital; ANS 0 is analog
		movwf	ansel	
		bcf		status,RP0	;switch to bank 0
		
		movlw	b'00000001'	;result is left justified; Referenzvoltage is VDD; Analog input pin is GP0
		movwf	adcon0

		clrf	gpio		;clear gpio
		clrw				;clear W-register
		return

;-------------read analog value---------------------------

_analog	bsf		adcon0,1	;starting a conversion
_wait1	btfsc	adcon0,1	;wait for end of conversion
		goto	_wait1		
		call 	_40mys		;wait for 40s
		return

;--------------time 40s----------------------------------

_40mys	movlw	d'20'
		movwf	time1
_wait2	nop
		nop
		nop
		nop
		decfsz	time1,1
		goto	_wait2
		return
						

;--------------output-------------------------------------
; copy 4-bit value to output port

_out	btfsc	adresh,4		
		bsf		bcd_out,GP1	
		btfss	adresh,4
		bcf		bcd_out,GP1

		btfsc	adresh,5	
		bsf		bcd_out,GP2	
		btfss	adresh,5
		bcf		bcd_out,GP2

		btfsc	adresh,6
		bsf		bcd_out,GP4	
		btfss	adresh,6
		bcf		bcd_out,GP4

		btfsc	adresh,7
		bsf		bcd_out,GP5	
		btfss	adresh,7
		bcf		bcd_out,GP5
	
		movf	bcd_out,w
		movwf	gpio
		return

;-------------main cycle---------------------------------------
_main	call	_init		;port- and register init
_main1	call	_analog		;read analog value	
		call	_out		;write digital value to port
		goto	_main1

;-------------------------------------------------------------
		org		2007
		de		b'10100100'	;PWRTE=on,WDT=off,MCLR=on,BODDEN=off,CP=off
		
;-------------------------------------------------------------
		end

