/*****************************************************************************

Program: diagnose

Funktion:
Initialisiert die Ports, schaltet die Ports auf Ausgang und setzt die Ausgnge
abwechselnd auf 0 und 1. Die Blinkfrequenz wird ber die Interruptroutine
gesteuert. Wenn ein Taster gedrckt wird, so wird die zum Taster zugehrige
LED eingeschaltet.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

#define TIMER0_STARTWERT 0x64        // Startwert fr Timer-0

volatile uint16_t zaehler;           // Zhler fr Zeitsteuerung
volatile uint16_t blinken;           // Steuerungsflag

volatile uint8_t tasterwert;         // Variable fr Taster

uint8_t taster(void) {               // Tasterabfrage durch kurzes Umschalten
    uint8_t status, ret_val;         // auf Eingang
    
    status=PORTD&0x68;               // Alten Status merken
    DDRD=DDRD&0x97;                  // Bits auf Eingang schalten
    PORTD=PORTD|0x68;

    asm volatile ("nop");
    asm volatile ("nop");
    asm volatile ("nop");
    asm volatile ("nop");
    
    ret_val=PIND&0x68;               // Bits einlesen
    
    PORTD=(PORTD&0x97)|status;       // Alten Status wieder herstellen
    DDRD=DDRD|0x68;                  // Bits wieder auf Ausgang schalten
    
    return ret_val;
}

SIGNAL(SIG_OVERFLOW0) {
    TCNT0 = TIMER0_STARTWERT;        // Timer-0 Startwert setzen
    tasterwert=taster();
    if (tasterwert==0x68) {          // Blinken, wenn kein Taster gedrckt
        if (zaehler>0)               // Zhler herunterzhlen
            zaehler--;
        else {
            zaehler=250;             // Zhlvariable auf Startwert setzen
            if (blinken==0) {        // Alle LEDs an
                blinken=1;
                PORTB=0x00;
                PORTD=0x00;
            }
            else {                   // Alle LEDs aus
                blinken=0;
                PORTB=0xFF;
                PORTD=0xFF;
            }
        }
    }
    else {                           // Taster auswerten
        blinken=0;                   // Alle LEDs aus und Zustand zurcksetzen
        PORTB=0xFF;
        PORTD=0xFF;
        zaehler=0;

        // Taster 1 auswerten
        // (gedrueckt = Bit geht auf 0)
        if (bit_is_clear(tasterwert,6)) {
            cbi(PORTB,7);            // Zugehrige LED an
            cbi(PORTD,6);            // Ausgang nachziehen
		}
        else {
            sbi(PORTB,7);            // Zugehrige LED aus
            sbi(PORTD,6);            // Ausgang nachziehen
		}

        // Taster 2 auswerten
        // (gedrueckt = Bit geht auf 0)
        if (bit_is_clear(tasterwert,3)) {
            cbi(PORTB,0);            // Zugehrige LED an
            cbi(PORTD,3);            // Ausgang nachziehen
		}
        else {
            sbi(PORTB,0);            // Zugehrige LED aus
            sbi(PORTD,3);            // Ausgang nachziehen
		}

        // Taster 3 auswerten
        // (gedrueckt = Bit geht auf 0)
        if (bit_is_clear(tasterwert,5)) {
            cbi(PORTB,1);            // Zugehrige LED an
            cbi(PORTD,5);            // Ausgang nachziehen
		}
        else {
            sbi(PORTB,1);            // Zugehrige LED aus
            sbi(PORTD,5);            // Ausgang nachziehen
		}
    }
}

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0xFF;                      // Alle Ausgnge auf 1
        
    DDRD=0xFF;                       // Port D auf Ausgang
    PORTD=0xFF;                      // Alle Ausgnge auf 1

    // Timer-0 Vorteiler auf 64,
    // Startwert setzen und Interrupt einschalten
    TCCR0=(0<<CS02)|(1<<CS01)|(1<<CS00);
    TCNT0=TIMER0_STARTWERT;
    sbi(TIMSK,TOIE0);

    zaehler=250;                     // Zhlvariable auf Startwert setzen
    blinken=0;                       // Steuerungsflag initialisieren

    sei();                           // Interrupts aktivieren
    
    for (;;) {}                      // Endlosschleife
}
