/*****************************************************************************

Programmbeispiel 11: cw

Funktion:
Morst einen Text ber den an Leitung 0 des Port D angeschlossenen Lautsprecher.
Die Tonerzeugung erfolgt in der Interruptroutine. Dort wird auch der auszugebende
Text zeichenweise in die zu gebenden Symbole umgesetzt. Die Symbole legen die
Lngen fr Tne und Pausen fest. In der Hauptschleife erfolgt die Auswertung der
Taster fr die Bedienung. Mit dem linken Taster kann das Tempo verringert werden,
mit dem mittleren Taster kann das Tempo erhht werden. Der rechte Taster wechselt
nacheinander durch die fest im Programm vorgegebenen Texte. Der ausgewhlte Text
wird in der Hauptschleife immer wieder zur Ausgabe bereitgestellt.

Timing fr die Morsezeichen:
- Ein dah ist dreimal so lang wie ein dit. 
- Die Pause zwischen zwei gesendeten Symbolen ist ein dit lang.
- Zwischen Buchstaben in einem Wort wird eine Pause von einem dah (= 3 dit) Dauer
  eingeschoben.
- Zwischen Wrtern wird eine Pause von sieben dits gemacht.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <string.h>                  // Allgemeine Bibliotheken
#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

#define TIMER0_STARTWERT 0xEB        // Startwert fr Timer-0

#define DIT_BASIS 800                // Basiswert fr Tempo
#define TON_BASIS 6                  // Basiswert fr Tonhhe

volatile uint16_t zaehler_tonhoehe;  // Zhler fr Tonhhe
volatile uint16_t dit_aktuell;       // Aktuelles Tempo

volatile uint16_t zaehler_tempo;     // Zhler fr Tempo
volatile uint8_t ausgabe_ton;        // Schalter fr Tonerzeugung
volatile uint8_t ausgabe_text;       // Schalter fr Textausgabe
volatile uint8_t ausgabe_zeichen;    // Schalter fr Zeichenausgabe

volatile uint8_t text_pos;           // Position im Textpuffer
volatile uint8_t zeichen_pos;        // Position im Zeichenpuffer

volatile uint8_t text_index;         // Index fr auzugebenden Text
volatile uint8_t anzeige_tempo;      // Anzeige fr Tempo

char text[80];                       // Textpuffer
char zeichen[6];                     // Zeichenpuffer

void warte_ms(uint16_t t) {          // Funktion "Warteschleife"
    uint16_t i, j;
    
    for (i=0;i<t;i++) {              // Verschachtelte Schleife mit
        for (j=1;j<475;j++) {        // Befehl NOP="Tue nichts", damit
            asm volatile ("nop");    // die Schleife nicht wegoptimiert
        }                            // wird
    }
}

SIGNAL(SIG_OVERFLOW0) {
    TCNT0 = TIMER0_STARTWERT;        // Timer-0 Startwert setzen
    if (zaehler_tonhoehe>0)          // Zhler fr Tonhhe herunterzhlen
        zaehler_tonhoehe--;
    else {
        zaehler_tonhoehe=TON_BASIS;  // Zhler fr Tonhhe wieder initialisieren
        if (ausgabe_ton==1) {        // Wenn Tonausgabe an, dann Ausgang
            ausgabe_ton=2;           // regelmssig umschalten
            cbi(PORTD,0);
        }
        else if (ausgabe_ton==2) {
            ausgabe_ton=1;
            sbi(PORTD,0);
        }
        else                         // Sonst Ausgang auf 1 halten
            sbi(PORTD,0);
    }
    if (zaehler_tempo>0)             // Zhler fr Tempo herunterzhlen
        zaehler_tempo--;
    else {
        if (ausgabe_zeichen==1) {    // Fr die Symbole eines Zeichens werden Tne oder
            ausgabe_zeichen=2;       // Pausen der entsprechenden Lngen erzeugt.
            switch (zeichen[zeichen_pos++]) {
                // Ein Punkt ist ein dit lang.
                case '.': zaehler_tempo=dit_aktuell;
                          ausgabe_ton=1;
                          break;
                // Ein Strich ist drei dit lang.
                case '-': zaehler_tempo=3*dit_aktuell;
                          ausgabe_ton=1;
                          break;
                // Sieben dit Pause zwischen zwei Worten.
                case ' ': zaehler_tempo=7*dit_aktuell;
                          ausgabe_ton=0;
                          ausgabe_zeichen=0;
                          break;
                // Drei dit Pause am Ende eines Zeichens.
                default:  zaehler_tempo=3*dit_aktuell;
                          ausgabe_ton=0;
                          ausgabe_zeichen=0;
                          break;
            }
        }
        // Ein dit Pause zwischen zwei gesendeten Symbolen.
        else if (ausgabe_zeichen==2) {
            ausgabe_zeichen=1;
            zaehler_tempo=dit_aktuell;
            ausgabe_ton=0;
        }
        else if (ausgabe_text==1) {  // Symbole fr das nchste Zeichen des
            zeichen_pos=0;           // Textes holen oder Ausgabe beenden.
            ausgabe_zeichen=1;
            switch (text[text_pos++]) {
                case 'a': strcpy_P(zeichen,PSTR(".-"));
                          break;
                case '': strcpy_P(zeichen,PSTR(".-.-"));
                          break;
                case 'b': strcpy_P(zeichen,PSTR("-..."));
                          break;
                case 'c': strcpy_P(zeichen,PSTR("-.-."));
                          break;
                case 'd': strcpy_P(zeichen,PSTR("-.."));
                          break;
                case 'e': strcpy_P(zeichen,PSTR("."));
                          break;
                case 'f': strcpy_P(zeichen,PSTR("..-."));
                          break;
                case 'g': strcpy_P(zeichen,PSTR("--."));
                          break;
                case 'h': strcpy_P(zeichen,PSTR("...."));
                          break;
                case 'i': strcpy_P(zeichen,PSTR(".."));
                          break;
                case 'j': strcpy_P(zeichen,PSTR(".---"));
                          break;
                case 'k': strcpy_P(zeichen,PSTR("-.-"));
                          break;
                case 'l': strcpy_P(zeichen,PSTR(".-.."));
                          break;
                case 'm': strcpy_P(zeichen,PSTR("--"));
                          break;
                case 'n': strcpy_P(zeichen,PSTR("-."));
                          break;
                case 'o': strcpy_P(zeichen,PSTR("---"));
                          break;
                case '': strcpy_P(zeichen,PSTR("---."));
                          break;
                case 'p': strcpy_P(zeichen,PSTR(".--."));
                          break;
                case 'q': strcpy_P(zeichen,PSTR("--.-"));
                          break;
                case 'r': strcpy_P(zeichen,PSTR(".-."));
                          break;
                case 's': strcpy_P(zeichen,PSTR("..."));
                          break;
                case 't': strcpy_P(zeichen,PSTR("-"));
                          break;
                case 'u': strcpy_P(zeichen,PSTR("..-"));
                          break;
                case '': strcpy_P(zeichen,PSTR("..--"));
                          break;
                case 'v': strcpy_P(zeichen,PSTR("...-"));
                          break;
                case 'w': strcpy_P(zeichen,PSTR(".--"));
                          break;
                case 'x': strcpy_P(zeichen,PSTR("-..-"));
                          break;
                case 'y': strcpy_P(zeichen,PSTR("-.--"));
                          break;
                case 'z': strcpy_P(zeichen,PSTR("--.."));
                          break;
                case '1': strcpy_P(zeichen,PSTR(".----"));
                          break;
                case '2': strcpy_P(zeichen,PSTR("..---"));
                          break;
                case '3': strcpy_P(zeichen,PSTR("...--"));
                          break;
                case '4': strcpy_P(zeichen,PSTR("....-"));
                          break;
                case '5': strcpy_P(zeichen,PSTR("....."));
                          break;
                case '6': strcpy_P(zeichen,PSTR("-...."));
                          break;
                case '7': strcpy_P(zeichen,PSTR("--..."));
                          break;
                case '8': strcpy_P(zeichen,PSTR("---.."));
                          break;
                case '9': strcpy_P(zeichen,PSTR("----."));
                          break;
                case '0': strcpy_P(zeichen,PSTR("-----"));
                          break;
                case ' ': strcpy_P(zeichen,PSTR(" "));
                          break;
                default:  ausgabe_zeichen=0;
                          ausgabe_text=0;
                          break;
            }
        }
    }
}

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0xFF;                      // Alle Ausgnge auf 1

    DDRD=0x97;                       // Port D auf Ausgang, Taster auf Eingang
    PORTD=0xFF;                      // Alle Ausgnge auf 1, Bit 3, 5 und 6 auf Eingang
        
    // Timer-0 Vorteiler auf 64,
    // Startwert setzen und Interrupt einschalten
    TCCR0=(0<<CS02)|(1<<CS01)|(1<<CS00);
    TCNT0=TIMER0_STARTWERT;
    sbi(TIMSK,TOIE0);

    zaehler_tonhoehe=TON_BASIS;      // Zhler fr Tonhhe initialisieren
    dit_aktuell=DIT_BASIS;           // Tempo initialisieren

    zaehler_tempo=0;                 // Zhler fr Tempo initialisieren
    ausgabe_ton=0;                   // Tonausgabe zunchst aus
    ausgabe_text=0;                  // Textausgabe zunchst aus
    ausgabe_zeichen=0;               // Zeichenausgabe zunchst aus
    text_index=1;                    // Textindex auf den ersten Text setzen

    anzeige_tempo=0x10;              // Anzeige fr Tempo initialisieren
    PORTB=~anzeige_tempo;

    sei();                           // Interrupts aktivieren
    
    for (;;) {                       // Endlosschleife
        if ((PIND&0x68)!=0x68) {     // Wurde ein Taster gedrckt?
            warte_ms(10);            // Entprellen (durch kurzes Warten)

            // Taster 1 auswerten (gedrueckt = Bit geht auf 0)
            // Tempo verringern und Azeige nachfhren
            if (bit_is_clear(PIND,6)) {
                if (anzeige_tempo!=0x80) {
                    cli();           // Kollision mit Interrupt verhindern
                    dit_aktuell=dit_aktuell+75;
                    sei();
                    anzeige_tempo=anzeige_tempo<<1;
                    PORTB=~anzeige_tempo;
                }
            }

            // Taster 2 auswerten (gedrueckt = Bit geht auf 0)
            // Tempo erhhen und Azeige nachfhren
            if (bit_is_clear(PIND,3)) {
                if (anzeige_tempo!=0x02) {
                    cli();           // Kollision mit Interrupt verhindern
                    dit_aktuell=dit_aktuell-75;
                    sei();
                    anzeige_tempo=anzeige_tempo>>1;
                    PORTB=~anzeige_tempo;
                }
            }

            // Taster 3 auswerten (gedrueckt = Bit geht auf 0)
            if (bit_is_clear(PIND,5)) {
                text_index++;        // Nchsten Text whlen
                if (text_index>3)
                    text_index=1;
                cli();               // Kollision mit Interrupt verhindern
                zaehler_tempo=0;     // Laufende Ausgabe stoppen
                ausgabe_ton=0;
                ausgabe_text=0;
                ausgabe_zeichen=0;
                sei();
            }

            // Warte, bis kein Taster gedrueckt ist
            while ((PIND&0x68)!=0x68);
            warte_ms(10);            // Entprellen (durch kurzes Warten)
        }

        if (ausgabe_text==0) {       // Neuen auszugebenden Text setzen
            cli();                   // Kollision mit Interrupt verhindern
            switch (text_index) {    // Text auswhlen
                case 1: strcpy_P(text,PSTR("dies ist der erste text   "));
                        break;
                case 2: strcpy_P(text,PSTR("hier kommt einen alternativer text   "));
                        break;
                case 3: strcpy_P(text,PSTR("und das ist ein weiterer text   "));
                        break;
            }            
            text_pos=0;              // Ausgabe starten
            ausgabe_text=1;
            sei();
        }
    }
}
