/*****************************************************************************

Programmbeispiel 08: taster_mit_umschalten

Funktion:
Initialisiert Port B (I/O-Pins auf Ausgang, Ausgnge auf 1)
Initialisiert Port D (I/O-Pins auf Ausgang, Ausgnge auf 0)
Die fr die Taster verwendeteten Leitungen werden hier als Ausgang
benutzt. In einer Unterroutine werden die Taster durch kurzes Umschalten
auf Eingang abgefragt. Die Hautschleife prft den Zustand der Taster und
schaltet die den Tastern zugeordneten LEDs ein oder aus.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

volatile uint8_t tasterwert;         // Variable fr Taster

uint8_t taster(void) {               // Tasterabfrage durch kurzes Umschalten
    uint8_t status, ret_val;         // auf Eingang
    
    status=PORTD&0x68;               // Alten Status merken
    DDRD=DDRD&0x97;                  // Bits auf Eingang schalten
    PORTD=PORTD|0x68;

    asm volatile ("nop");
    asm volatile ("nop");
    asm volatile ("nop");
    asm volatile ("nop");
    
    ret_val=PIND&0x68;               // Bits einlesen
    
    PORTD=(PORTD&0x97)|status;       // Alten Status wieder herstellen
    DDRD=DDRD|0x68;                  // Bits wieder auf Ausgang schalten
    
    return ret_val;
}

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0xFF;                      // Alle Ausgnge auf 1
    
    DDRD=0xFF;                       // Port D auf Ausgang
    PORTD=0x00;                      // Alle Ausgnge auf 0

    for (;;) {                       // Endlosschleife
        tasterwert=taster();         // Tasterwert speichern

        // Taster 1 auswerten
        // (gedrueckt = Bit geht auf 0)
        if (bit_is_clear(tasterwert,6))
            cbi(PORTB,7);            // Zugehrige LED an
        else
            sbi(PORTB,7);            // Zugehrige LED aus

        // Taster 2 auswerten
        // (gedrueckt = Bit geht auf 0)
        if (bit_is_clear(tasterwert,3))
            cbi(PORTB,0);            // Zugehrige LED an
        else
            sbi(PORTB,0);            // Zugehrige LED aus

        // Taster 3 auswerten
        // (gedrueckt = Bit geht auf 0)
        if (bit_is_clear(tasterwert,5))
            cbi(PORTB,1);            // Zugehrige LED an
        else
            sbi(PORTB,1);            // Zugehrige LED aus
    }
}
