/*****************************************************************************

Programmbeispiel 07b: taster_zaehler

Funktion:
Initialisiert Port B (I/O-Pins auf Ausgang, Ausgnge auf 1)
Initialisiert Port D (I/O-Pins auf Ausgang, Ausgnge auf 1, Taster auf Eingang)
In der Hauptschleife wird ein Binrzhler ausgegeben. Mit den Tastern
kann der Binrzhler erhht, verringert oder auf Null gesetzt werden.
Durch kurzes Warten nach der Abfrage der Taster wird ein Prellen unterdrckt.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

volatile uint8_t binaerzaehler;      // Variable fr Binrzhler

void warte_ms(uint16_t t) {          // Funktion "Warteschleife"
    uint16_t i, j;
    
    for (i=0;i<t;i++) {              // Verschachtelte Schleife mit
        for (j=1;j<475;j++) {        // Befehl NOP="Tue nichts", damit
            asm volatile ("nop");    // die Schleife nicht wegoptimiert
        }                            // wird
    }
}

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0xFF;                      // Alle Ausgnge auf 1

    DDRD=0x97;                       // Port D auf Ausgang, Taster auf Eingang
    PORTD=0xFF;                      // Alle Ausgnge auf 1, Bit 3, 5 und 6 auf Eingang
    
    binaerzaehler=0;                 // Binrzhler initialisieren

    for (;;) {                       // Endlosschleife
        if ((PIND&0x68)!=0x68) {     // Wurde ein Taster gedrckt?
            warte_ms(10);            // Entprellen (durch kurzes Warten)

            // Taster 1 auswerten
            // (gedrueckt = Bit geht auf 0)
            if (bit_is_clear(PIND,6))
                 binaerzaehler++;    // Binrzhler erhhen, durch berlauf
                                     // beginnt der Zhler nach 255
                                     // automatisch wieder bei 0

            // Taster 2 auswerten
            // (gedrueckt = Bit geht auf 0)
            if (bit_is_clear(PIND,3))
                 binaerzaehler--;    // Binrzhler veringern, durch berlauf
                                     // beginnt der Zhler nach 0
                                     // automatisch wieder bei 255

            // Taster 3 auswerten
            // (gedrueckt = Bit geht auf 0)
            if (bit_is_clear(PIND,5))
                 binaerzaehler=0;    // Binrzhler initialisieren

            // Warte, bis kein Taster gedrueckt ist
            while ((PIND&0x68)!=0x68);
            warte_ms(10);            // Entprellen (durch kurzes Warten)
        }
        PORTB=~binaerzaehler;        // Binrzhler ausgeben
    }
}
