/*****************************************************************************

Programmbeispiel 07a: taster_direkt

Funktion:
Initialisiert Port B (I/O-Pins auf Ausgang, Ausgnge auf 1)
Initialisiert Port D (I/O-Pins auf Ausgang, Ausgnge auf 1, Taster auf Eingang)
Die Hautschleife prft den Zustand der Taster und schaltet
die den Tastern zugeordneten LEDs ein oder aus.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0xFF;                      // Alle Ausgnge auf 1
    
    DDRD=0x97;                       // Port D auf Ausgang, Taster auf Eingang
    PORTD=0xFF;                      // Alle Ausgnge auf 1, Bit 3, 5 und 6 auf Eingang

    for (;;) {                       // Endlosschleife
        // Taster 1 auswerten
        // (gedrueckt = Bit geht auf 0)
        if (bit_is_clear(PIND,6))
            cbi(PORTB,7);            // Zugehrige LED an
        else
            sbi(PORTB,7);            // Zugehrige LED aus

        // Taster 2 auswerten
        // (gedrueckt = Bit geht auf 0)
        if (bit_is_clear(PIND,3))
            cbi(PORTB,0);            // Zugehrige LED an
        else
            sbi(PORTB,0);            // Zugehrige LED aus

        // Taster 3 auswerten
        // (gedrueckt = Bit geht auf 0)
        if (bit_is_clear(PIND,5))
            cbi(PORTB,1);            // Zugehrige LED an
        else
            sbi(PORTB,1);            // Zugehrige LED aus
    }
}
