/*****************************************************************************

Programmbeispiel 05b: wuerfel

Funktion:
Initialisiert Port D (I/O-Pins auf Ausgang, Ausgnge auf 1)
In der durch Timer 0 ausgelsten Interruptroutine wird ein Zustandsautomat
aufgerufen, der schrittweise die Muster eines Wrfels ausgibt.
ber eine Zhlvariable wird die Wartezeit bis zum jeweils nchsten Aufruf
des Zustandautomaten bestimmt.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

#define WUERFEL_1 0x08               // Muster fr 1
#define WUERFEL_2 0x41               // Muster fr 2
#define WUERFEL_3 0x2A               // Muster fr 3
#define WUERFEL_4 0x63               // Muster fr 4
#define WUERFEL_5 0x6B               // Muster fr 5
#define WUERFEL_6 0x77               // Muster fr 6

#define TIMER0_STARTWERT 0x64        // Startwert fr Timer-0
volatile uint8_t zustand;            // Variable fr Zustandsautomat
volatile uint16_t zaehler;           // Zhler fr Zeitsteuerung

SIGNAL(SIG_OVERFLOW0) {
    TCNT0 = TIMER0_STARTWERT;        // Timer-0 Startwert setzen
    if (zaehler>0)                   // Zhler herunterzhlen
        zaehler--;
    else {
        switch (zustand) {
            case 1: zustand=2;       // Zustand 1
                    PORTD=~WUERFEL_1;
                    zaehler=500;
                    break;
            case 2: zustand=3;       // Zustand 2
                    PORTD=~WUERFEL_2;
                    zaehler=500;
                    break;
            case 3: zustand=4;       // Zustand 3
                    PORTD=~WUERFEL_3;
                    zaehler=500;
                    break;
            case 4: zustand=5;       // Zustand 4
                    PORTD=~WUERFEL_4;
                    zaehler=500;
                    break;
            case 5: zustand=6;       // Zustand 5
                    PORTD=~WUERFEL_5;
                    zaehler=500;
                    break;
            case 6: zustand=1;       // Zustand 6
                    PORTD=~WUERFEL_6;
                    zaehler=500;
                    break;
        }
    }
}

int main (void) {
    DDRD=0xFF;                       // Port D auf Ausgang
    PORTD=0xFF;                      // Alle Ausgnge auf 1

    // Timer-0 Vorteiler auf 64,
    // Startwert setzen und Interrupt einschalten
    TCCR0=(0<<CS02)|(1<<CS01)|(1<<CS00);
    TCNT0=TIMER0_STARTWERT;
    sbi(TIMSK,TOIE0);

    zustand=1;                       // Startzustand
    zaehler=0;                       // Wartezeit fr ersten Aufruf
                                     // des Zustandsautomaten

    sei();                           // Interrupts aktivieren
    
    for (;;) {}                      // Endlosschleife
}
