/*****************************************************************************

Programmbeispiel 04c: led_lauflicht_interrupt_zaehler

Funktion:
Initialisiert Port B (I/O-Pins auf Ausgang, Ausgnge auf 1)
In der durch Timer 0 ausgelsten Interruptroutine wird eine Zhlvariable
heruntergezhlt. Wenn die Zhlvariable bei Null ankommt, wird das Lauflicht
weitergeschaltet, und die Zhlvariable wird wieder auf ihren Startwert gesetzt.
Dadurch wird die Geschwindigkeit reduziert.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

#define TIMER0_STARTWERT 0x64        // Startwert fr Timer-0
volatile uint16_t zaehler;           // Zhler fr Zeitsteuerung

volatile uint8_t lauflicht;          // Variable fr Lauflicht

SIGNAL(SIG_OVERFLOW0) {
    TCNT0 = TIMER0_STARTWERT;        // Timer-0 Startwert setzen
    if (zaehler>0)                   // Zhler herunterzhlen
        zaehler--;
    else {
        lauflicht<<=1;               // Lauflicht um 1 Bit nach links
                                     // weiterschieben
        if (lauflicht==0)            // Wenn Lauflicht durchgelaufen ist,
            lauflicht=1;             // dann wieder am Anfang beginnen
        PORTB=~lauflicht;            // Lauflicht auf PORT B ausgeben
        zaehler=1000;                // Zhlvariable auf Startwert setzen
    }
}

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0xFF;                      // Alle Ausgnge auf 1

    lauflicht=1;                     // Lauflicht initialisieren
        
    // Timer-0 Vorteiler auf 64,
    // Startwert setzen und Interrupt einschalten
    TCCR0=(0<<CS02)|(1<<CS01)|(1<<CS00);
    TCNT0=TIMER0_STARTWERT;
    sbi(TIMSK,TOIE0);

    zaehler=1000;                    // Zhlvariable auf Startwert setzen

    sei();                           // Interrupts aktivieren
    
    for (;;) {}                      // Endlosschleife
}
