/*****************************************************************************

Programmbeispiel 03b: led_zaehler_interrupt

Funktion:
Initialisiert Port B (I/O-Pins auf Ausgang, Ausgnge auf 1)
Der Binrzhler wird in einer durch Timer 0 ausgelsten Interruptroutine
weitergeschaltet. Trotz maximaler Vorteilung ist die Geschwindigkeit
immer noch recht schnell.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

volatile uint8_t binaerzaehler;      // Variable fr Binrzhler

SIGNAL(SIG_OVERFLOW0) {
    TCNT0=0x00;                      // Timer-0 Startwert setzen
    binaerzaehler++;                 // Binrzhler erhhen, durch berlauf
                                     // beginnt der Zhler nach 255
                                     // automatisch wieder bei 0
    PORTB=~binaerzaehler;            // Binrzhler auf PORT B ausgeben
}

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0xFF;                      // Alle Ausgnge auf 1
    
    binaerzaehler=0;                 // Binrzhler initialisieren
    
    // Timer-0 Vorteiler auf 1024,
    // Startwert setzen und Interrupt einschalten
    TCCR0=(1<<CS02)|(0<<CS01)|(1<<CS00);
    TCNT0=0x00;
    sbi(TIMSK,TOIE0);
    
    sei();                           // Interrupts aktivieren
    
    for (;;) {}                      // Endlosschleife
}
