/*****************************************************************************

Programmbeispiel 03a: led_blinken_interrupt

Funktion:
Initialisiert Port B (I/O-Pins auf Ausgang, Ausgnge auf 1)
Die Ausgnge werden in einer durch Timer 0 ausgelsten Interruptroutine
abwechselnd auf 0 oder 1 gesetzt. Trotz maximaler Vorteilung blinken die LEDs
immer noch recht schnell.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

SIGNAL(SIG_OVERFLOW0) {
    TCNT0=0x00;                      // Timer-0 Startwert setzen
    PORTB=~PORTB;                    // Ausgnge invertieren
}

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0xFF;                      // Alle Ausgnge auf 1
    
    // Timer-0 Vorteiler auf 1024,
    // Startwert setzen und Interrupt einschalten
    TCCR0=(1<<CS02)|(0<<CS01)|(1<<CS00);
    TCNT0=0x00;
    sbi(TIMSK,TOIE0);
    
    sei();                           // Interrupts aktivieren
    
    for (;;) {}                      // Endlosschleife
}
