/*****************************************************************************

Programmbeispiel 02c: led_lauflicht

Funktion:
Initialisiert Port B (I/O-Pins auf Ausgang, Ausgnge auf 1)
In der Hauptschleife wird ein Lauflicht ausgegeben.
Die Geschwindigkeit wird ber eine Warteschleife gesteuert.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

volatile uint8_t lauflicht;          // Variable fr Lauflicht

void warte_ms(uint16_t t) {          // Funktion "Warteschleife"
    uint16_t i, j;
    
    for (i=0;i<t;i++) {              // Verschachtelte Schleife mit
        for (j=1;j<475;j++) {        // Befehl NOP="Tue nichts", damit
            asm volatile ("nop");    // die Schleife nicht wegoptimiert
        }                            // wird
    }
}

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0xFF;                      // Alle Ausgnge auf 1

    lauflicht=1;                     // Lauflicht initialisieren

    for (;;) {                       // Endlosschleife
        lauflicht<<=1;               // Lauflicht um 1 Bit nach links
                                     // weiterschieben
        if (lauflicht==0)            // Wenn Lauflicht durchgelaufen ist,
            lauflicht=1;             // dann wieder am Anfang beginnen
        PORTB=~lauflicht;            // Lauflicht auf PORT B ausgeben
        warte_ms(1000);              // Warten (1000 ms)
    }
}
