/*****************************************************************************

Programmbeispiel 01: led

Funktion:
Initialisiert Port B (I/O-Pins auf Ausgang, Ausgnge auf 0)
Die I/O-Pins von Port B gehen dadurch auf 0 Volt, damit die
gegen 5 Volt geschalteten Leuchtdioden leuchten.

Autor: Kai Ludwig / Version: 1.01

Copyright 2005-2006 Talentraspel Elektronikversand K. Ludwig

Historie:
V1.00 - Erste Version
V1.01 - Anpassung an WinAVR-20060421

*****************************************************************************/

#include <inttypes.h>                // Allgemeine Bibliotheken
#include <avr/io.h>
#include <avr/interrupt.h>

#define sbi(ADDRESS,BIT) ((ADDRESS) |= (1<<(BIT)))
#define cbi(ADDRESS,BIT) ((ADDRESS) &= ~(1<<(BIT)))

int main (void) {
    DDRB=0xFF;                       // Port B auf Ausgang
    PORTB=0x00;                      // Alle Ausgnge auf 0
    
    for (;;) {}                      // Endlosschleife
}
