
; PicBasic Pro Compiler Demo, (c) 1998, 2004 microEngineering Labs, Inc. All Rights Reserved.  
PM_USED			EQU	1

	INCLUDE	"16F84A.INC"


; Define statements.
#define		DEBUG_REG		  PortB                         
#define		DEBUG_BIT		  7
#define		DEBUG_BAUD		 9600
#define		DEBUG_MODE		 1
#define		DEBUG_PACING		 1000

RAM_START       		EQU	0000Ch
RAM_END         		EQU	0004Fh
RAM_BANKS       		EQU	00001h
BANK0_START     		EQU	0000Ch
BANK0_END       		EQU	0004Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0213Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
T1              		EQU	RAM_START + 012h
FLAGS           		EQU	RAM_START + 014h
GOP             		EQU	RAM_START + 015h
RM1             		EQU	RAM_START + 016h
RM2             		EQU	RAM_START + 017h
RR1             		EQU	RAM_START + 018h
RR2             		EQU	RAM_START + 019h
_Puls            		EQU	RAM_START + 01Ah
_Key             		EQU	RAM_START + 01Ch
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
#define _TRISB_2         	 TRISB, 002h
#define _PORTB_1         	 PORTB, 001h
#define _PORTB_2         	 PORTB, 002h
#define _PORTA_4         	 PORTA, 004h
#define _INTCON_1        	 INTCON, 001h
	INCLUDE	"MOT110~1.MAC"
	INCLUDE	"PBPPIC14.LIB"

	MOVE?CB	01Fh, TRISA
	MOVE?CT	001h, _TRISB_2
	MOVE?CB	090h, INTCON
	LOW?T	_PORTB_1
	ONINT?LL	_Fire, L00001

	LABEL?L	_Loop	
	ICALL?L	L00001
	CMPEQ?TCL	_PORTB_2, 001h, _Loop
	DISABLE?	

	LABEL?L	_Key_in	
	MOVE?BB	PORTA, _Key
	XOR?BCW	_Key, 00Fh, T1
	AND?WCB	T1, 00Fh, _Key
	MUL?CBW	042h, _Key, _Puls
	DEBUG?C	06Bh
	DEBUG?C	065h
	DEBUG?C	079h
	DEBUG?C	065h
	DEBUG?C	064h
	DEBUG?C	020h
	DEBUGCOUNT?C	000h
	DEBUGNUM?B	_Key
	DEBUGDEC?	
	DEBUG?C	020h
	DEBUG?C	020h
	DEBUG?C	020h
	DEBUG?C	020h
	DEBUG?C	050h
	DEBUG?C	075h
	DEBUG?C	06Ch
	DEBUG?C	073h
	DEBUG?C	020h
	DEBUG?C	03Dh
	DEBUG?C	020h
	DEBUGCOUNT?C	000h
	DEBUGNUM?W	_Puls
	DEBUGDEC?	
	DEBUG?C	020h
	DEBUG?C	020h
	DEBUG?C	064h
	DEBUG?C	069h
	DEBUG?C	072h
	DEBUG?C	065h
	DEBUG?C	063h
	DEBUG?C	074h
	DEBUG?C	069h
	DEBUG?C	06Fh
	DEBUG?C	06Eh
	DEBUG?C	020h
	DEBUG?C	03Dh
	DEBUG?C	020h
	DEBUGCOUNT?C	000h
	DEBUGNUM?T	_PORTA_4
	DEBUGBIN?	
	DEBUG?C	00Ah
	DEBUG?C	00Dh
	CMPEQ?TCL	_PORTB_2, 000h, _Key_in
	ENABLE?	
	ICALL?L	L00001
	GOTO?L	_Loop

	LABEL?L	_Fire	
	DISABLE?	
	CMPNE?TCL	_PORTA_4, 000h, L00002
	PAUSE?C	00Ah
	LABEL?L	L00002	
	PULSOUT?TW	_PORTB_1, _Puls
	MOVE?CT	000h, _INTCON_1
	RESUME?	
	ENABLE?	
	ICALL?L	L00001
	END?	

	END

