unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ComCtrls, mmsystem;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Button2: TButton;
    Edit1: TEdit;
    GroupBox2: TGroupBox;
    Button1: TButton;
    ProgressBar1: TProgressBar;
    GroupBox3: TGroupBox;
    ComboBox1: TComboBox;
    TrackBar1: TTrackBar;
    TrackBar2: TTrackBar;
    Button3: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Button4: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    TrackBar3: TTrackBar;
    Label7: TLabel;
    Label8: TLabel;
    TrackBar4: TTrackBar;
    Label9: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

    wavefile        :file of byte;
    textfile        :Text;
    b               :byte;
    i               :longint ;
    f0,scale        :longint ;
    w_fsize         :longint ;
    w_nsamples      :longint ;
    w_sample_rate   :longint ;
    nsamples        :longint;
    fs              :longint;
    tempo           :longint;
    summe           :longint;
    zeit            :longint;

implementation

{$R *.DFM}

//Schreiben eines Byte in eine Datei
procedure put(b:byte) ;
begin write(wavefile,b) ; end ;

//Schreiben eines Word in eine Datei
procedure putw(w:word) ;
begin put(lo(w)) ; put(hi(w)) ; end ;

//Schreiben eines Integer in eine Datei
procedure putdw(l:longint) ;
begin
put(( l shr  0) and $FF) ; put(( l shr 8) and $FF) ;
put(( l shr  16) and $FF) ; put(( l shr 24 ) and $FF) ; end ;

//Schreiben eines Strings in eine Datei
procedure putstr(s:string) ;
var k:integer ;
begin
for k:=1 to length(s) do put(ord(s[k]) ) ;
end ;

//Schreiben einer gerundeten Zahl in eine Datei
procedure output(v:real) ;
begin
{putw(word(round(v)));}
putw(round(v));
end ;

//Speichern der Tonfolge fr einen Punkt
procedure savepunkt;
var psample : longint;
    i       :integer;
    t       :extended ;
begin
//  Punktlaenge in ms = 6000/tempo
//  fs = Sample pro Sekunde
//  Punktsample = fs * Punktlnge
  psample := round(fs * 6/tempo);
  for i:=1 to psample do
  begin
  t:=2*pi*f0/fs*i ;
  output(scale*(sin(t))) ;
  end ;
  for i:=1 to psample do  output(0);
  summe:= summe + 2*psample
end;

//Speichern der Tonfolge fr einen Strich
procedure savestrich;
var psample,ssample : longint;
    i       :integer;
    t       :extended ;
begin
  psample := round(fs * 6/tempo);
  ssample := 3* psample;
  for i:=1 to ssample do
  begin
  t:=2*pi*f0/fs*i ;
  output(scale*(sin(t))) ;
  end ;
  for i:=1 to psample do  output(0);
  summe:= summe + ssample + psample
end;

//Speichern der Tonfolge fr eine Buchstabenpause
procedure bpause;
var psample,pausesample : longint;
    i       :integer;
begin
  psample := round(fs * 6/tempo);
  pausesample := 3* psample;
  for i:=1 to pausesample do  output(0);
  summe:= summe + pausesample
end;

//Speichern der Tonfolge fr eine Wortpause
procedure wpause;
var psample,pausesample : longint;
    i       :integer;
begin
  psample := round(fs * 6/tempo);
  pausesample := 7* psample;
  for i:=1 to pausesample do  output(0);
  summe:= summe + pausesample
end;

//Speichern der Tonfolge fr einen Buchstaben
procedure buchstabe(buchst :byte);
const   marray : array[0..63] of byte =($00,$00,$4a,$00,$00,$00,$00,$7a, { !"#$%&'} {   ab 20hex}
                                        $b4,$b6,$00,$54,$ce,$86,$56,$94, {()*+,-./}
                                        $fc,$7c,$3c,$1c,$0c,$04,$84,$c4, {01234567}
                                        $e4,$f4,$e2,$aa,$00,$8c,$00,$32, {89:;<=>?}
                                        $6a,$60,$88,$a8,$90,$40,$28,$d0, {@abcdefg}
                                        $08,$20,$78,$b0,$48,$e0,$a0,$f0, {hijklmno}
                                        $68,$d8,$50,$10,$c0,$30,$18,$70, {pqrstuvw}
                                        $98,$b8,$c8,$00,$00,$00,$00,$00);{xyz     } {ende bei 5fhex}
var b  : byte;
begin
  if (buchst> $20) and (buchst<$7f) then
  begin
   if buchst > $3f then buchst := (buchst and $5F)-$20 else buchst := buchst-$20;
   b := marray[buchst];
   if b <> $00 then
   begin
    repeat
     if (b and $80) = 0 then savepunkt else savestrich;
     b := b shl 1;
    until (b and $7F)=0;
    bpause;
   end
  end;
  if (buchst=$20) then wpause;
  if (buchst=$0d) then wpause;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
tempo := 100;
fs:=8000;
f0:=800;
scale:=round($7fff * 80/100);
end;

procedure TForm1.Button1Click(Sender: TObject);
var wname      :string;
   c           :char;
   anzahl      :integer;
   count       :integer;
begin
if OpenDialog1.Execute then
begin
wname := openDialog1.FileName;
delete(wname,pos('.',wname)+1,3);
wname:= wname+'wav';
assignfile(wavefile,wname);
rewrite(wavefile);
// Kopf der *.wav Datei aufbauen
nsamples:=22050; // Pseudowert
w_sample_rate:=fs ;
w_nsamples:=nsamples ;
putstr('RIFF') ;
w_fsize:=44+2*w_nsamples ;
putdw(w_fsize-8) ;
putstr('WAVEfmt ') ;
putdw(16) ;
putw(1) ; { pcm }
putw(1) ; { channels }
putdw(w_sample_rate) ;
putdw(2*w_sample_rate) ; { data rate }
putw(2) ; { bytes per sample }
putw(16) ; { bits per smple }
putstr('data') ;
putdw(w_fsize-44) ;
// Textdatei ffnen und konvertieren
assignfile(textfile,OpenDialog1.FileName);
anzahl:=0;
reset(textfile);
while not eof(textfile) do
 begin
 application.processmessages;
 read(textfile,c);
 anzahl:=anzahl+1;
 end;
reset(textfile);
 count:=0;
while not eof(textfile) do
 begin
 application.processmessages;
 count:=count+1;
 progressBar1.Position:=Round(count/Anzahl*100);
 read(textfile,c);
 buchstabe(ord(c));
 end;
closefile(textfile);
//Kopfdatei der *.wav Datei berschreiben, da nun die Lnge feststeht
reset(wavefile);
w_sample_rate:=fs ;
w_nsamples:=summe ;
putstr('RIFF') ;
w_fsize:=44+2*w_nsamples ;
putdw(w_fsize-8) ;
putstr('WAVEfmt ') ;
putdw(16) ;
putw(1) ; { pcm }
putw(1) ; { channels }
putdw(w_sample_rate) ;
putdw(2*w_sample_rate) ; { data rate }
putw(2) ; { bytes per sample }
putw(16) ; { bits per smple }
putstr('data') ;
putdw(w_fsize-44) ;
closefile(wavefile);
end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var str1  :string;
    i     :integer;
    flag  :word;
    ndatei:string;
begin
if SaveDialog1.Execute then
begin
ndatei := SaveDialog1.FileName;
assignfile(wavefile,SaveDialog1.FileName);
rewrite(wavefile);
// Kopf der *.wav Datei aufbauen
nsamples:=22050; // Pseudowert
w_sample_rate:=fs ;
w_nsamples:=nsamples ;
putstr('RIFF') ;
w_fsize:=44+2*w_nsamples ;
putdw(w_fsize-8) ;
putstr('WAVEfmt ') ;
putdw(16) ;
putw(1) ; { pcm }
putw(1) ; { channels }
putdw(w_sample_rate) ;
putdw(2*w_sample_rate) ; { data rate }
putw(2) ; { bytes per sample }
putw(16) ; { bits per smple }
putstr('data') ;
putdw(w_fsize-44) ;
// String konvertieren
str1:= edit1.text;
for i:=1 to length(str1) do  buchstabe(ord(str1[i]));
//Kopfdatei der *.wav Datei berschreiben, da nun die Lnge feststeht
reset(wavefile);
w_sample_rate:=fs ;
w_nsamples:=summe ;
putstr('RIFF') ;
w_fsize:=44+2*w_nsamples ;
putdw(w_fsize-8) ;
putstr('WAVEfmt ') ;
putdw(16) ;
putw(1) ; { pcm }
putw(1) ; { channels }
putdw(w_sample_rate) ;
putdw(2*w_sample_rate) ; { data rate }
putw(2) ; { bytes per sample }
putw(16) ; { bits per smple }
putstr('data') ;
putdw(w_fsize-44) ;
closefile(wavefile);

 {Folgende Flags knnen benutzt werden:
  SND_SYNC = Spielt den Sound ab, die Anwendung "steht"
  SND_ASYNC = Spielt den Sound ab, die Anwendung luft weiter
  SND_LOOP = Spielt den Sound endlos}

  {Es knnen auch mehrere Flags kombiniert werden:}
  //flag:=SND_ASYNC;

  {Abspielen kann man einen Sound dann ganz einfach so:}
  //sndPlaySound('call.wav', Flag);

  {Um einen endlosen Sound zu stoppen, ruft die Funktion mit folgenden
  Parametern auf:}
  //sndPlaySound(NIL,0);



end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
if SaveDialog1.Execute then
begin
assignfile(wavefile,SaveDialog1.FileName);
rewrite(wavefile);
// Kopf der *.wav Datei aufbauen
nsamples:=trackbar3.Position*fs;
w_sample_rate:=fs ;
w_nsamples:=nsamples ;
putstr('RIFF') ;
w_fsize:=44+2*w_nsamples ;
putdw(w_fsize-8) ;
putstr('WAVEfmt ') ;
putdw(16) ;
putw(1) ; { pcm }
putw(1) ; { channels }
putdw(w_sample_rate) ;
putdw(2*w_sample_rate) ; { data rate }
putw(2) ; { bytes per sample }
putw(16) ; { bits per smple }
putstr('data') ;
putdw(w_fsize-44) ;

for i:=1 to nsamples do
 begin
  application.processmessages;
  output(scale*(sin(2*pi*f0/fs*i ))) ;
 end ;
end;
closefile(wavefile)
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
close();
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
var str1  :string;
begin
tempo:= Trackbar1.position;
if tempo < 100 then str1:=' '+inttostr(tempo) else str1:=inttostr(tempo);
Label5.caption:=str1 + ' BPM';
end;

procedure TForm1.TrackBar2Change(Sender: TObject);
var str1  :string;
begin
f0:= Trackbar2.position;
if f0 < 1000 then str1:=' '+inttostr(f0) else  str1:=inttostr(f0);
Label6.caption:=str1+ ' Hz';
end;

procedure TForm1.TrackBar3Change(Sender: TObject);
var str1  :string;
begin
zeit:= Trackbar3.position;
if zeit < 10 then
             begin
             str1:='  '+inttostr(Zeit);
             Label8.caption:=str1+ ' Sekunden';
             end
             else
              if zeit < 100
              then
               begin str1:=' '+inttostr(Zeit);
                     Label8.caption:=str1+ ' Sekunden';
               end
              else
               begin
               str1:=inttostr(zeit);
               Label8.caption:=str1+ ' Sekunden';
               end;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
fs:= strtoint(comboBox1.text);
end;

procedure TForm1.TrackBar4Change(Sender: TObject);
begin
scale:=round($7fff * trackbar4.Position/100);
end;

end.
