/***************************************************************************

  CCheckBox.cpp

  The CheckBox class

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __CCHECKBOX_CPP



#include <qapplication.h>
#include <qcheckbox.h>

#include "gambas.h"

#include "CCheckBox.h"


DECLARE_EVENT(EVENT_Click);


BEGIN_METHOD(CCHECKBOX_new, GB_OBJECT parent)

  QCheckBox *wid = new QCheckBox(CONTAINER(VARG(parent)));

  QObject::connect(wid, SIGNAL(toggled(bool)), &CCheckBox::manager, SLOT(clicked()));

  CWIDGET_new(wid, (void *)_object, "CheckBox");

  wid->show();

END_METHOD


BEGIN_PROPERTY(CCHECKBOX_text)

  if (READ_PROPERTY)
    GB.ReturnNewZeroString(TO_UTF8(WIDGET->text()));
  else
    WIDGET->setText(QSTRING_PROP());

END_PROPERTY


BEGIN_PROPERTY(CCHECKBOX_value)

  if (READ_PROPERTY)
    GB.ReturnBoolean(WIDGET->isChecked());
  else
    WIDGET->setChecked(VPROP(GB_BOOLEAN));

END_PROPERTY


/* Class CCheckBox */

CCheckBox CCheckBox::manager;

void CCheckBox::clicked(void)
{
  RAISE_EVENT(EVENT_Click);
}

GB_DESC CCheckBoxDesc[] =
{
  GB_DECLARE("CheckBox", sizeof(CCHECKBOX)), GB_INHERITS("Control"),

  GB_METHOD("_new", NULL, CCHECKBOX_new, "(Parent)Container;"),

  GB_PROPERTY("Text", "s", CCHECKBOX_text),
  GB_PROPERTY("Caption", "s", CCHECKBOX_text),

  GB_PROPERTY("Value", "b", CCHECKBOX_value),

  GB_CONSTANT("_Properties", "s", CCHECKBOX_PROPERTIES),
  GB_CONSTANT("_DefaultEvent", "s", "Click"),

  GB_EVENT("Click", NULL, NULL, &EVENT_Click),

  GB_END_DECLARE
};


