/***************************************************************************

  CExample.h

  A component example

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

/* This file is the header file of a class implementation.

   You define there some useful macros, constants, and the structure used
   for representing the Gambas object created when the class is 
   instanciated.
*/


#ifndef __CEXAMPLE_H
#define __CEXAMPLE_H

/* You must include gambas.h in each class file of your component.

   This include file declares all the macros, datatypes, and interface
   functions used for communicating with the interpreter.
*/

#include "gambas.h"

/* main.c will include the class include files, so it must have an
   access to the class description.
*/

#ifndef __CEXAMPLE_C

extern GB_DESC CExampleDesc[];
extern GB_DESC CExamplePixelsDesc[];

#else

/* This constant makes the code more readable. It can only be used where
   _object is declared, i.e. inside a method or property implementation.
*/

#define THIS ((CEXAMPLE *)_object)

#endif


/* This structure represents an instance of your class.
   If your class is not creatable, then this structure does not exist !

   The structure must begin with a GB_BASE. The other fields are free.
*/

typedef
  struct {
    GB_BASE ob;
    long width;
    long height;
    unsigned long *data;
    }
  CEXAMPLE;

#endif
