/***************************************************************************

  gb.eval.h

  The evaluator plug-in

  (c) 2000-2003 Benot Minisini <gambas@freesurf.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __GB_EVAL_H
#define __GB_EVAL_H

#include "gambas.h"

/*#define DEBUG*/

typedef
  bool (*EVAL_FUNCTION)(const char *, long, GB_VARIANT *);

typedef
  void *EVAL_EXPRESSION;

#define EVAL_NORMAL       0
#define EVAL_USE_CONTEXT  1

typedef
  struct {
    long version;
    void (*New)(EVAL_EXPRESSION *expr, const char *src, long len);
    bool (*Compile)(EVAL_EXPRESSION expr);
    bool (*Run)(EVAL_EXPRESSION expr, EVAL_FUNCTION func);
    void (*Free)(EVAL_EXPRESSION *expr);
    }
  EVAL_INTERFACE;

#define EVAL_INTERFACE_VERSION 1

#endif

