/***************************************************************************

  regexp.c

  Regular expression management

  Copyright (C) 2000 Benot Minisini <gambas@freesurf.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __GBX_REGEXP_C

#include "gb_common.h"
#include "gb_common_case.h"

/*#include <regex.h>*/
#include <fnmatch.h>
#include <ctype.h>

#include "gb_alloc.h"
#include "gb_error.h"

#include "gbx_regexp.h"

/*
PUBLIC boolean REGEXP_match(char *pattern, char *string)
{
  regex_t expr;
  regmatch_t match[1];
  char *pattern;
  int err;

  err = regcomp(&expr, pattern,  REG_NOSUB);
  if (err != 0)
    goto _ERROR;

  err = regexec(&expr, string, 1, match, REG_NOTBOL | REG_NOTEOL);

  printf("REGEXP_match: %d %d\n", match->rm_so, match->rm_eo);

  regfree(&expr);

  if (err != 0 && err != REG_NOMATCH)
    goto _ERROR;

  return (err == 0);

_ERROR:

  regerror(err, &expr, COMMON_buffer, COMMON_BUF_MAX);
  THROW(E_REGEXP, COMMON_buffer);
}
*/

PUBLIC bool REGEXP_match(const char *pattern, long len_pattern, const char *string, long len_string)
{
  unsigned char cp;
  unsigned char cs;

  void _next_pattern(void)
  {
    cp = *pattern;
    pattern++; len_pattern--;
  }

  void _next_string(void)
  {
    cs = *string;
    string++; len_string--;
  }

  /*if (len_pattern == 0 || len_string == 0)
    return FALSE;*/

  for(;;)
  {
    if (len_pattern == 0)
      return (len_string == 0);

    _next_pattern();

    if (cp == '*')
    {
      if (len_pattern == 0)
        return TRUE;

      for(;;)
      {
        if (REGEXP_match(pattern, len_pattern, string, len_string))
          return TRUE;
        if (len_string == 0)
          return FALSE;
        _next_string();
      }
      return FALSE;
    }

    if (len_string == 0)
      return FALSE; /*end || (len_pattern == 0);*/

    _next_string();

    if (cp == '?')
      continue;

    if (cp == '[' && len_pattern > 0)
    {
      boolean not = FALSE;
      boolean in = FALSE;

      _next_pattern();
      if (cp == '^')
      {
        not = TRUE;
        _next_pattern();
      }

      if (cp == cs)
      {
        in = TRUE;
        _next_pattern();
      }
      else
      {
        for(;;)
        {
          if (cp == '-' && len_pattern > 1)
          {
            _next_pattern();
            if (pattern[-3] <= cs && cs <= cp)
            {
              in = TRUE;
              break;
            }
          }
          else if (cp == cs)
          {
            in = TRUE;
            break;
          }

          _next_pattern();
          if (cp == ']')
            break;
        }
      }

      for(;;)
      {
        if (cp == ']')
          break;
        if (len_pattern == 0)
          THROW(E_REGEXP, "Brace missing");
        _next_pattern();
      }

      if (in ^ not)
        continue;

      return FALSE;
    }

    if (cp == '\\')
    {
      if (len_pattern == 0)
        THROW(E_REGEXP, "Trailing backslash");
      _next_pattern();
    }

    if (tolower(cp) != tolower(cs))
      return FALSE;
  }
}

