/***************************************************************************

  compile.h

  Compiler initialization, reserved keywords table and subroutines table.

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef _COMPILE_H
#define _COMPILE_H

#include "gb_array.h"
#include "gb_buffer.h"
#include "gb_table.h"
#include "gb_alloc.h"

#include "gb_limit.h"
#include "gb_reserved.h"
#include "gbc_read.h"

#include "gbc_class.h"

typedef
  struct {
    const char *name;                /* nom du fichier source */
    long line;                 /* numro de ligne courante */
    char *source;              /* contenu du fichier source */
    unsigned verbose    : 1;   /* compilation prolixe */
    unsigned debug      : 1;   /* informations de dboguage */
    unsigned trans      : 1;   /* Fabriquer les fichiers de traduction */
    unsigned is_module  : 1;   /* si le source est une classe ou un module */
    unsigned is_form    : 1;   /* if the source is a class form */
    unsigned declared   : 1;   /* module dclar */
    unsigned nobreak    : 1;   /* no breakpoint */
    unsigned _reserved  : 25;  /* rserv */
    const char *output;              /* fichier gnr */
    PATTERN *pattern;          /* analyse lexicale du source */
    PATTERN *current;          /* position de traduction courante */
    PATTERN *end;              /* fin de traduction */
    FUNCTION *func;            /* fonction en cours de compilation */
    CLASS *class;              /* classe en cours de compilation */
    const char *form;                /* nom du fichier formulaire */
    const char *tname;               /* nom du fichier *.pot */
    const char *class_file;          /* fichier contenant des classes  dclarer */
    }
  PACKED
  COMPILE;

#ifndef __GBC_COMPILE_C

EXTERN COMPILE COMP_current;

EXTERN char *COMP_project;
EXTERN char *COMP_info_path;
EXTERN char *COMP_classes;

#endif

#define JOB (&COMP_current)

PUBLIC void COMPILE_init(const char *exec);
PUBLIC void COMPILE_load(void);
PUBLIC void COMPILE_exit(void);
PUBLIC void COMPILE_begin(const char *file, bool trans);
PUBLIC void COMPILE_end(void);

#endif
